package cn.yw.sign.service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.yw.repairmanage.dao.SignDao;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

@Service("signService")
public class SignService extends BaseService {
	
	private static Log log = LogFactory.getLog(SignService.class);
	
	@Autowired
	private SignDao SignDao;
	
	/**
	 * ¼
	 */
	public void insert_Sign(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		SignDao.insert_Sign(map);
	}

	
	/**
	 * ޸ļ¼
	 */
	public Integer update_Sign(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return SignDao.update_Sign(map);
	}
	
	/**
	 * ɾ¼
	 */
	public Integer delete_Sign(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return SignDao.delete_Sign(map);

	}
	
	/**
	 * ɾ¼
	 */
	public Integer batch_delete_Sign(Map map) throws SQLException{
		return SignDao.batch_delete_Sign(map);
	}
	
	/**
	 * ѯ
	 */
	public Integer count_Sign(Map map) throws SQLException{
		return SignDao.count_Sign(map);
	}
	
	/**
	 * ѯб¼SELECT
	 */
	public List<Map> query_Sign(Map map) throws SQLException{
		return SignDao.query_Sign(map);
	}
	
	/**
	 * ѯһ
	 */
	 
	public Map get_Sign(Map map) throws SQLException{
		return SignDao.get_Sign(map);
	}
	
	/**
	 * EXCEL
	 */
	 
	/*
	public Map exportSign(Map map) throws SQLException{
		return this.listSignByPage(map);
	}
	*/
	
	/**
	 * Sign ҳ
	 */
	public Map listSignByPage(Map map) throws SQLException {
		List<Map> list = SignDao.query_Sign(map);
		Integer totalCount = SignDao.count_Sign(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}


}
