package cn.yw.operationcount.videoappraisecount.service;


import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.base.util.RHUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.base.util.StringUtil;
import cn.yw.operationcount.videoappraisecount.dao.YwcountvideoappraiseDao;
import net.sf.json.JSONObject;

@Service("ywcountvideoappraiseService")
public class YwcountvideoappraiseService extends BaseService {

    private static Log log = LogFactory.getLog(YwcountvideoappraiseService.class);

    @Autowired
    private YwcountvideoappraiseDao ywcountvideoappraiseDao;

    /**
     * ¼
     */
    public void insert_Ywcountvideoappraise(Map map) throws SQLException {
        CommUtils.addParams(map, false);
        ywcountvideoappraiseDao.insert_Ywcountvideoappraise(map);
    }

    public void insertWeight(Map map) throws SQLException {
        ywcountvideoappraiseDao.insertWeight(map);
    }


    /**
     * ޸ļ¼
     */
    public Integer update_Ywcountvideoappraise(Map map) throws SQLException {
        CommUtils.validateUpdateParams(map);
        CommUtils.addParams(map, true);
        return ywcountvideoappraiseDao.update_Ywcountvideoappraise(map);
    }

    public Integer updateWeight(Map map) throws SQLException {
        return ywcountvideoappraiseDao.updateWeight(map);
    }

    /**
     * ɾ¼
     */
    public Integer delete_Ywcountvideoappraise(Map map) throws SQLException {
        CommUtils.validateDeleteParams(map);
        return ywcountvideoappraiseDao.delete_Ywcountvideoappraise(map);
    }

    /**
     * ɾ¼
     */
    public Integer batch_delete_Ywcountvideoappraise(Map map) throws SQLException {
        return ywcountvideoappraiseDao.batch_delete_Ywcountvideoappraise(map);
    }

    /**
     * ѯ
     */
    public Integer count_Ywcountvideoappraise(Map map) throws SQLException {
        return ywcountvideoappraiseDao.count_Ywcountvideoappraise(map);
    }

    /**
     * ѯб¼SELECT
     */
    public List<Map> query_Ywcountvideoappraise(Map map) throws SQLException {
        return ywcountvideoappraiseDao.query_Ywcountvideoappraise(map);
    }

    /**
     * ѯһ
     */

    public Map get_Ywcountvideoappraise(Map map) throws SQLException {
        return ywcountvideoappraiseDao.get_Ywcountvideoappraise(map);
    }

    public Map getWeight(Map map) throws SQLException {
        return ywcountvideoappraiseDao.getWeight(map);
    }

    /**
     * EXCEL
     */

    public Map exportYwcountvideoappraise(Map map) throws SQLException {
        return this.listYwcountvideoappraiseByPage(map);
    }

    /**
     * Ywcountvideoappraise ҳ
     */
    public Map listYwcountvideoappraiseByPage(Map map) throws SQLException {
        List<Map> list = ywcountvideoappraiseDao.query_Ywcountvideoappraise(map);
        Integer totalCount = ywcountvideoappraiseDao.count_Ywcountvideoappraise(map);
        map.clear();
        map.put("total", totalCount);
        map.put("rows", list);
        return map;
    }

    public Map regionAssessmentCountList(Map map) throws SQLException {
        List<Map> result = new ArrayList<Map>();
        int monitorSum = 0, totalSum = 0, vqdnormalSum = 0, lalnormalSum = 0,
                recorddurationnormalSum = 0, norecorddurationnormalSum = 0, jobtotalSum = 0, jobnormalSum = 0;
        double lxscSum = 0.0, zxscSum = 0.0, scoreSum = 0.0;
        int total = 0, jksum = 0, vqdnormalnum = 0, lalnormalnum = 0, recorddurationnormalnum = 0,
                norecorddurationnormalnum = 0, jobtotal = 0, jobnormalnum = 0;
        double score = 0.0, zxsc = 0.0, lxsc = 0.0, zxRate = 0.0, videoIntactRate = 0.0, lalIntactRate = 0.0, recordIntactRate = 0.0, jobIntactRate = 0.0;
        //ܼ
        Map<String, Object> totalMap = new HashMap<String, Object>();
        Map weightMap = ywcountvideoappraiseDao.getWeight(new HashMap());
        if (weightMap == null) {
            map.clear();
            map.put("total", 0);
            map.put("rows", null);
            return map;
        }
        if (null != map.get("xzbh")) {
            String xzbh = map.get("xzbh").toString();
            map.put("xzbh", xzbh.split(","));
        }
        List<Map> list = ywcountvideoappraiseDao.regionAssessmentCountList(map);
       int grouptotal = ywcountvideoappraiseDao.CountregionAssessmentCountList(map);
        if (null != map.get("alarmdevicetype")) {
            String alarmdevicetype = String.valueOf(map.get("alarmdevicetype"));
            if (alarmdevicetype.equals("1")) {
                if (list != null && list.size() > 0) {
                    for (Map m : list) {
                        Map<String, Object> mapTemp = new HashMap<String, Object>();
                        mapTemp.put("areanum", m.get("areanum"));
                        mapTemp.put("areaname", m.get("areaname"));
                        total = StringUtil.str2Numeric(m.get("total") + "");
                        mapTemp.put("total", total);
                        score = 0.0;

                        jksum = StringUtil.str2Numeric(m.get("jksum") + "");
                        mapTemp.put("jksum", jksum);

                        zxsc = StringUtil.str2Double(m.get("zxsc") + "");
                        mapTemp.put("zxsc", zxsc);

                        lxsc = StringUtil.str2Double(m.get("lxsc") + "");
                        mapTemp.put("lxsc", lxsc);
                        zxRate = 0;
                        if ((zxsc + lxsc) > 0) {
                            //zxRate = zxsc / (zxsc + lxsc);
                            zxRate = zxsc / total;
                        }
                        score += zxRate * StringUtil.str2Numeric(weightMap.get("onlineweight") + "");
                        mapTemp.put("zxRate", new DecimalFormat("0.00").format(zxRate * 100.0) + "%");

                        vqdnormalnum = StringUtil.str2Numeric(m.get("vqdnormalnum") + "");
                        mapTemp.put("vqdnormalnum", vqdnormalnum);
                        lalnormalnum = StringUtil.str2Numeric(m.get("lalnormalnum") + "");
                        mapTemp.put("lalnormalnum", lalnormalnum);
                        if (total > 0) {
                            videoIntactRate = vqdnormalnum * 1.0 / total;
                            score += videoIntactRate * StringUtil.str2Numeric(weightMap.get("videoweight") + "");
                            mapTemp.put("videoIntactRate", new DecimalFormat("0.00").format(videoIntactRate * 100.0) + "%");

                            lalIntactRate = lalnormalnum * 1.0 / total;
                            score += lalIntactRate * StringUtil.str2Numeric(weightMap.get("lalweight") + "");
                            mapTemp.put("lalIntactRate", new DecimalFormat("0.00").format(lalIntactRate * 100.0) + "%");
                        } else {
                            mapTemp.put("videoIntactRate", "0.00%");
                            mapTemp.put("lalIntactRate", "0.00%");
                        }

                        recorddurationnormalnum = StringUtil.str2Numeric(m.get("recorddurationnormalnum") + "");
                        norecorddurationnormalnum = StringUtil.str2Numeric(m.get("norecorddurationnormalnum") + "");
                        mapTemp.put("recorddurationnormalnum", recorddurationnormalnum);
                        mapTemp.put("norecorddurationnormalnum", norecorddurationnormalnum);
                        recordIntactRate = 0;
                        if ((recorddurationnormalnum + norecorddurationnormalnum) > 0) {
                            recordIntactRate = recorddurationnormalnum * 1.0 / (recorddurationnormalnum + norecorddurationnormalnum);
                            score += recordIntactRate * StringUtil.str2Numeric(weightMap.get("recordweight") + "");
                        }
                        mapTemp.put("recordIntactRate", new DecimalFormat("0.00").format(recordIntactRate * 100.0) + "%");

                        jobtotal = StringUtil.str2Numeric(m.get("jobtotal") + "");
                        jobnormalnum = StringUtil.str2Numeric(m.get("jobnormalnum") + "");
                        mapTemp.put("jobtotal", jobtotal);
                        mapTemp.put("jobnormalnum", jobnormalnum);
                        jobIntactRate = 0;
                        if (jobtotal > 0) {
                            jobIntactRate = jobnormalnum * 1.0 / jobtotal;
                            score += jobIntactRate * StringUtil.str2Numeric(weightMap.get("repairweight") + "");
                        }
                        mapTemp.put("jobIntactRate", new DecimalFormat("0.00").format(jobIntactRate * 100.0) + "%");
                        mapTemp.put("score", new DecimalFormat("0.00").format(score) + "");
                        result.add(mapTemp);
                        totalSum += total;
                        monitorSum += jksum;
                        zxscSum += zxsc;
                        lxscSum += lxsc;
                        vqdnormalSum += vqdnormalnum;
                        lalnormalSum += lalnormalnum;
                        recorddurationnormalSum += recorddurationnormalnum;
                        norecorddurationnormalSum += norecorddurationnormalnum;
                        jobtotalSum += jobtotal;
                        jobnormalSum += jobnormalnum;
                        scoreSum += score;
                    }

                    totalMap.put("jksum", monitorSum);
                    totalMap.put("zxscSum", zxscSum);
                    totalMap.put("scoreSum", new DecimalFormat("0.00").format(scoreSum));
                    if ((zxscSum + lxscSum) > 0) {
                        totalMap.put("zxscRate", new DecimalFormat("0.00").format(zxscSum * 100.0 / (zxscSum + lxscSum)) + "%");
                    } else {
                        totalMap.put("zxscRate", "0.00%");
                    }
                    if (totalSum > 0) {
                        totalMap.put("videoRate", new DecimalFormat("0.00").format((vqdnormalSum * 100.0 / totalSum)) + "%");
                        totalMap.put("lalRate", new DecimalFormat("0.00").format((lalnormalSum * 100.0 / totalSum)) + "%");
                    } else {
                        totalMap.put("videoRate", "0.00%");
                        totalMap.put("lalRate", "0.00%");
                    }

                    if ((recorddurationnormalSum + norecorddurationnormalSum) > 0) {
                        totalMap.put("recordRate", new DecimalFormat("0.00").format((recorddurationnormalSum * 100.0 / (recorddurationnormalSum + norecorddurationnormalSum))) + "%");
                    } else {
                        totalMap.put("recordRate", "0.00%");
                    }
                    if (jobtotalSum > 0) {
                        totalMap.put("jobRate", new DecimalFormat("0.00").format((jobnormalSum * 100.0 / jobtotalSum)) + "%");
                    } else {
                        totalMap.put("jobRate", "0.00%");
                    }
//			result.add(totalMap);
                }
                Map[] maps = new Map[result.size()];
                maps = result.toArray(maps);
                for (int i = 0; i < maps.length; i++) {
                    for (int j = i + 1; j < maps.length; j++) {
                        if (  Double.valueOf((maps[i].get("score") + ""))< Double.valueOf((maps[j].get("score") + ""))) {
                            Map t = maps[i];
                            maps[i] = maps[j];
                            maps[j] = t;
                        }
                    }
                }
                Map[] newMaps = Arrays.copyOf(maps, maps.length + 1);
                newMaps[newMaps.length - 1] = totalMap;
                map.clear();
                map.put("total", grouptotal);
                map.put("rows", newMaps);
            } else {//źŵƣյشţ΢״
                if (list != null && list.size() > 0) {
                    if (list != null && list.size() > 0) {
                        for (Map m : list) {
                            Map<String, Object> mapTemp = new HashMap<String, Object>();
                            total = 0;
                            score = 0.0;//÷
                            zxRate = 0.0;//
                            recordIntactRate = 0;//Ƶ
                            jobIntactRate = 0.0;//޸
                            mapTemp.put("areanum", m.get("areanum"));
                            mapTemp.put("areaname", m.get("areaname"));
                            if (RHUtil.isNotEmpty(m.get("total"))) {
                                total = StringUtil.str2Numeric(String.valueOf(m.get("total")));
                                mapTemp.put("total", total);
                            }
                            if (RHUtil.isNotEmpty(m.get("jksum"))) {
                                jksum = StringUtil.str2Numeric(String.valueOf(m.get("jksum")));
                                mapTemp.put("jksum", jksum);
                            }
                            if (RHUtil.isNotEmpty(m.get("zxsc"))) {
                                zxsc = StringUtil.str2Double(String.valueOf(m.get("zxsc")));
                                mapTemp.put("zxsc", zxsc);
                            }
                            if (RHUtil.isNotEmpty(m.get("lxsc"))) {
                                lxsc = StringUtil.str2Double(String.valueOf(m.get("lxsc")));
                                mapTemp.put("lxsc", lxsc);
                            }
                            //֮豸Ϊ߸/ܸ
                            if ((zxsc + lxsc) > 0) {
                                zxRate = zxsc / total;
                            }
                            if (RHUtil.isNotEmpty(weightMap.get("onlineweight"))) {
                                score += zxRate * StringUtil.str2Numeric(weightMap.get("onlineweight") + "");
                                mapTemp.put("zxRate", new DecimalFormat("0.00").format(zxRate * 100.0) + "%");
                            }
                            if (RHUtil.isNotEmpty(m.get("vqdnormalnum"))) {
                                vqdnormalnum = StringUtil.str2Numeric(String.valueOf(m.get("vqdnormalnum")));
                                mapTemp.put("vqdnormalnum", vqdnormalnum);
                            }
                            if (RHUtil.isNotEmpty(m.get("lalnormalnum"))) {
                                lalnormalnum = StringUtil.str2Numeric(String.valueOf(m.get("lalnormalnum")));
                                mapTemp.put("lalnormalnum", lalnormalnum);
                            }
                            if (total > 0) {
                                videoIntactRate = vqdnormalnum * 1.0 / total;
                                if (RHUtil.isNotEmpty(weightMap.get("videoweight"))) {
                                    score += videoIntactRate * StringUtil.str2Numeric(weightMap.get("videoweight") + "");
                                    mapTemp.put("videoIntactRate", new DecimalFormat("0.00").format(videoIntactRate * 100.0) + "%");
                                }
                                lalIntactRate = lalnormalnum * 1.0 / total;
                                score += lalIntactRate * StringUtil.str2Numeric(weightMap.get("lalweight") + "");
                                mapTemp.put("lalIntactRate", new DecimalFormat("0.00").format(lalIntactRate * 100.0) + "%");
                            } else {
                                mapTemp.put("videoIntactRate", "0.00%");
                                mapTemp.put("lalIntactRate", "0.00%");
                            }
                            if (RHUtil.isNotEmpty(m.get("recorddurationnormalnum"))) {
                                recorddurationnormalnum = StringUtil.str2Numeric(m.get("recorddurationnormalnum") + "");
                            }
                            if (RHUtil.isNotEmpty(m.get("recorddurationnormalnum"))) {
                                norecorddurationnormalnum = StringUtil.str2Numeric(m.get("norecorddurationnormalnum") + "");
                            }
                            mapTemp.put("recorddurationnormalnum", recorddurationnormalnum);
                            mapTemp.put("norecorddurationnormalnum", norecorddurationnormalnum);
                            if ((recorddurationnormalnum + norecorddurationnormalnum) > 0) {
                                recordIntactRate = recorddurationnormalnum * 1.0 / (recorddurationnormalnum + norecorddurationnormalnum);
                                score += recordIntactRate * StringUtil.str2Numeric(weightMap.get("recordweight") + "");
                                mapTemp.put("recordIntactRate", new DecimalFormat("0.00").format(recordIntactRate * 100.0) + "%");
                            }
                            jobtotal = StringUtil.str2Numeric(m.get("jobtotal") + "");
                            jobnormalnum = StringUtil.str2Numeric(m.get("jobnormalnum") + "");
                            mapTemp.put("jobtotal", jobtotal);
                            mapTemp.put("jobnormalnum", jobnormalnum);
                            if (jobtotal > 0) {
                                jobIntactRate = jobnormalnum * 1.0 / jobtotal;
                                score += jobIntactRate * StringUtil.str2Numeric(weightMap.get("repairweight") + "");
                            }
                            mapTemp.put("jobIntactRate", new DecimalFormat("0.00").format(jobIntactRate * 100.0) + "%");
                            mapTemp.put("score", new DecimalFormat("0.00").format(score) + "");
                            result.add(mapTemp);
                            totalSum += total;
                            monitorSum += jksum;
                            zxscSum += zxsc;
                            lxscSum += lxsc;
                            vqdnormalSum += vqdnormalnum;
                            lalnormalSum += lalnormalnum;
                            recorddurationnormalSum += recorddurationnormalnum;
                            norecorddurationnormalSum += norecorddurationnormalnum;
                            jobtotalSum += jobtotal;
                            jobnormalSum += jobnormalnum;
                            scoreSum += score;
                        }
                        totalMap.put("totalSum", totalSum);
                        totalMap.put("jksum", monitorSum);
                        totalMap.put("zxscSum", zxscSum);
                        totalMap.put("scoreSum", new DecimalFormat("0.00").format(scoreSum));
                        if ((zxscSum + lxscSum) > 0) {
                            totalMap.put("zxscRate", new DecimalFormat("0.00").format(zxscSum * 100.0 / (zxscSum + lxscSum)) + "%");
                        } else {
                            totalMap.put("zxscRate", "0.00%");
                        }
                        if (totalSum > 0) {
                            totalMap.put("videoRate", new DecimalFormat("0.00").format((vqdnormalSum * 100.0 / totalSum)) + "%");
                            totalMap.put("lalRate", new DecimalFormat("0.00").format((lalnormalSum * 100.0 / totalSum)) + "%");
                        } else {
                            totalMap.put("videoRate", "0.00%");
                            totalMap.put("lalRate", "0.00%");
                        }

                        if ((recorddurationnormalSum + norecorddurationnormalSum) > 0) {
                            totalMap.put("recordRate", new DecimalFormat("0.00").format((recorddurationnormalSum * 100.0 / (recorddurationnormalSum + norecorddurationnormalSum))) + "%");
                        } else {
                            totalMap.put("recordRate", "0.00%");
                        }
                        if (jobtotalSum > 0) {
                            totalMap.put("jobRate", new DecimalFormat("0.00").format((jobnormalSum * 100.0 / jobtotalSum)) + "%");
                        } else {
                            totalMap.put("jobRate", "0.00%");
                        }
//			result.add(totalMap);
                    }
                    Map[] maps = new Map[result.size()];
                    maps = result.toArray(maps);
                    for (int i = 0; i < maps.length; i++) {
                        for (int j = i + 1; j < maps.length; j++) {
                            if (Double.valueOf((maps[i].get("score") + ""))<Double.valueOf(((maps[j].get("score") + "")))) {
                                Map t = maps[i];
                                maps[i] = maps[j];
                                maps[j] = t;
                            }
                        }
                    }
                    Map[] newMaps = Arrays.copyOf(maps, maps.length + 1);
                    newMaps[newMaps.length - 1] = totalMap;
                    map.clear();
                    map.put("total", grouptotal);
                    map.put("rows", newMaps);
                    map.put("alarmdevicetype", alarmdevicetype);
                }
            }
        }
        return map;

    }

    public Map regionAssessmentCountListByRegion(Map map) throws SQLException {
        List<Map> result = new ArrayList<Map>();
        Map weightMap = ywcountvideoappraiseDao.getWeight(new HashMap());//ȡȨ
        int monitorSum = 0, totalSum = 0, vqdnormalSum = 0, lalnormalSum = 0,
                recorddurationnormalSum = 0, norecorddurationnormalSum = 0, jobtotalSum = 0, jobnormalSum = 0,
                scoreSum = 0;
        double lxscSum = 0.0, zxscSum = 0.0;
        String alarmdevicetype = "";
        List<Map> list = ywcountvideoappraiseDao.regionAssessmentCountListByRegion(map);//ȡ
        Integer zs = ywcountvideoappraiseDao.count_regionAssessmentCountListByRegion(map);//ȡ
        if (list != null && list.size() > 0) {//÷ֵ
            double score = 0.0;
            for (Map m : list) {
                Map<String, Object> mapTemp = new HashMap<String, Object>();
                mapTemp.put("areanum", m.get("areanum"));
                mapTemp.put("areaname", m.get("areaname"));
                mapTemp.put("devicenum", m.get("devicenum"));
                if (RHUtil.isNotEmpty(map.get("alarmdevicetype"))) {
                    alarmdevicetype = map.get("alarmdevicetype").toString();
                }
                if (alarmdevicetype.equals("1")) {
                    mapTemp.put("channelnum", m.get("channelnum"));
                }
                mapTemp.put("videoname", m.get("videoname"));
                int total = StringUtil.str2Numeric(m.get("total") + "");//
                mapTemp.put("total", total);
                score = 0.0;
                if (total == 0) {
                    map.clear();
                    map.put("total", 0);
                    map.put("rows", null);
                    return map;
                }
				/*int jksum = StringUtil.str2Numeric(m.get("jksum")+"");
				mapTemp.put("jksum",jksum);*/

                double zxsc = StringUtil.str2Double(m.get("zxsc") + "");
                mapTemp.put("zxsc", zxsc);

                double lxsc = StringUtil.str2Double(m.get("lxsc") + "");
                mapTemp.put("lxsc", lxsc);
                double zxRate = 0.0;
                zxRate = zxsc / total;
                // if ((zxsc + lxsc) > 0) {
                //  zxRate = zxsc / total;
//                    if (alarmdevicetype.equals("1")) {
//                        zxRate = zxsc / (zxsc + lxsc);
//                    } else {
//                        zxRate = zxsc / total;
//                    }
                //   }
                score += zxRate * StringUtil.str2Numeric(weightMap.get("onlineweight") + "");
                mapTemp.put("zxRate", new DecimalFormat("0.00").format(zxRate * 100.0) + "%");

                if (alarmdevicetype.equals("1")) {
                    int vqdnormalnum = StringUtil.str2Numeric(m.get("vqdnormalnum") + "");
                    mapTemp.put("vqdnormalnum", vqdnormalnum);
                    double videoIntactRate = vqdnormalnum * 1.0 / total;
                    score += videoIntactRate * StringUtil.str2Numeric(weightMap.get("videoweight") + "");
                    mapTemp.put("videoIntactRate", new DecimalFormat("0.00").format(videoIntactRate * 100.0) + "%");

                    int recorddurationnormalnum = StringUtil.str2Numeric(m.get("recorddurationnormalnum") + "");
                    int norecorddurationnormalnum = StringUtil.str2Numeric(m.get("norecorddurationnormalnum") + "");
                    mapTemp.put("recorddurationnormalnum", recorddurationnormalnum);
                    mapTemp.put("norecorddurationnormalnum", norecorddurationnormalnum);
                    double recordIntactRate = 0;
                    if ((recorddurationnormalnum + norecorddurationnormalnum) != 0) {
                        recordIntactRate = recorddurationnormalnum * 1.0 / (recorddurationnormalnum + norecorddurationnormalnum);
                        score += recordIntactRate * StringUtil.str2Numeric(weightMap.get("recordweight") + "");
                    }
                    mapTemp.put("recordIntactRate", new DecimalFormat("0.00").format(recordIntactRate * 100.0) + "%");

                }
                if (!alarmdevicetype.equals("2")) {
                    int lalnormalnum = StringUtil.str2Numeric(m.get("lalnormalnum") + "");
                    mapTemp.put("lalnormalnum", lalnormalnum);
                    double lalIntactRate = lalnormalnum * 1.0 / total;
                    score += lalIntactRate * StringUtil.str2Numeric(weightMap.get("lalweight") + "");
                    mapTemp.put("lalIntactRate", new DecimalFormat("0.00").format(lalIntactRate * 100.0) + "%");
                }
//				int recordnormalnum = StringUtil.str2Numeric(m.get("recordnormalnum")+"");
                int jobtotal = StringUtil.str2Numeric(m.get("jobtotal") + "");
                int jobnormalnum = StringUtil.str2Numeric(m.get("jobnormalnum") + "");
                mapTemp.put("jobtotal", jobtotal);
                mapTemp.put("jobnormalnum", jobnormalnum);
                double jobIntactRate = 0;
                if (jobtotal != 0) {
                    jobIntactRate = jobnormalnum * 1.0 / jobtotal;
                    score += jobIntactRate * StringUtil.str2Numeric(weightMap.get("repairweight") + "");
                }
                mapTemp.put("jobIntactRate", new DecimalFormat("0.00").format(jobIntactRate * 100.0) + "%");
                mapTemp.put("score", new DecimalFormat("0.00").format(score) + "");
                result.add(mapTemp);
            }
        }
        Map[] maps = new Map[result.size()];
        maps = result.toArray(maps);
        for (int i = 0; i < maps.length; i++) {
            for (int j = i + 1; j < maps.length; j++) {
                if ((maps[i].get("score") + "").compareTo((maps[j].get("score") + "")) < 0) {
                    Map t = maps[i];
                    maps[i] = maps[j];
                    maps[j] = t;
                }
            }
        }
        map.clear();
        map.put("total", zs);
        map.put("rows", maps);
        map.put("alarmdevicetype", alarmdevicetype);
        return map;
    }

    // λ¼ͳ                           /start
    public List query_dwlx(Map map) throws SQLException {
        return ywcountvideoappraiseDao.query_dwlx(map);
    }

    public Integer count_dwlx(Map map) throws SQLException {
        return ywcountvideoappraiseDao.count_dwlx(map);
    }

    //	ͳ ״ͼ
    public List show_bar(Map map) throws SQLException {
        return ywcountvideoappraiseDao.show_bar(map);
    }

    // λ¼ͳ                           /end


    public static void main(String[] args) {
        System.out.println(1.0 * 1 == 1);
    }

}
