package cn.yw.operationcount.alarmcount.action;


import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.pdf.ExportPDF;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.operationcount.alarmcount.service.YwcountuserrepairjobService;

@SuppressWarnings({"all"})
@Component("ywcountuserrepairjobAction")
public class YwcountuserrepairjobAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwcountuserrepairjobAction.class);
	
	@Autowired
	private YwcountuserrepairjobService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwcountuserrepairjobByPage")
	public void listYwcountuserrepairjobByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwcountuserrepairjobByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountuserrepairjobAction-listYwcountuserrepairjobByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// ҳͳ
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_OrderHomepage")
	public void count_OrderHomepage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {			
			Struts2Utils.renderJson(this.service.count_OrderHomepage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountuserrepairjobAction-count_OrderHomepage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ѯ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywcountuserrepairjob")
	public void count_Ywcountuserrepairjob(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywcountuserrepairjob(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountuserrepairjobAction-count_Ywcountuserrepairjob-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Ywcountuserrepairjob
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywcountuserrepairjob")
	public void query_Ywcountuserrepairjob(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {

			Struts2Utils.renderJson(this.service.query_Ywcountuserrepairjob(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountuserrepairjobAction-query_Ywcountuserrepairjob-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// ״ͼͳ
	@OperateType(value = LogConstants.LOG_GET ,info ="count_showBar")
	public void count_showBar(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_showBar(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountuserrepairjobAction-count_showBar-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywcountuserrepairjob")
	public void exp_Ywcountuserrepairjob(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ywcountuserrepairjob(map);		

			
			String[] zdbm = {"areaname", "useraccount","username","reportjobcount","rejectjobcount","acceptjobcount","feedbackjobcount","hangupjobcount","confirmjobcount"};
			String[] zdmc = {"λ", "¼˺", "Ա","ϱ","ع","","","𹤵","ȷϷ"};
			int excelNum = zdmc.length;
			ExcelCol[] cells = new ExcelCol[excelNum];
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ͳԱ-"+dateTime);
			params.put("sheetName", "ͳԱ");
			params.put("header", "ͳԱ");	
			new ExportEngine().exportCommData(params, cells, sList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountuserrepairjobAction-exoprtExcel-error:" +e);
			
		}
	}
	/**
	 * pdf
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="expPDF_Ywcountuserrepairjob")
	public void expPDF_Ywcountuserrepairjob(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ywcountuserrepairjob(map);		
			
			//ͷ
			String[] header = {"λ", "¼˺", "Ա","ϱ","ع","","","𹤵","ȷϷ"};
			//
			String[][] expArr = null;
			if(RHUtil.isNotEmpty(sList)) {
				expArr = new String[sList.size()][header.length];
				int index = 0;
				for(Map m : sList){
					expArr[index][0] = StringUtil.transEmpty(m.get("areaname")+"");
					expArr[index][1] = StringUtil.transEmpty(m.get("useraccount")+"");
					expArr[index][2] = StringUtil.transEmpty(m.get("username")+"");
					expArr[index][3] = StringUtil.str2Numeric(m.get("reportjobcount")+"")+"";
					expArr[index][4] = StringUtil.str2Numeric(m.get("rejectjobcount")+"")+"";
					expArr[index][5] = StringUtil.str2Numeric(m.get("acceptjobcount")+"")+"";
					expArr[index][6] = StringUtil.str2Numeric(m.get("feedbackjobcount")+"")+"";
					expArr[index][7] = StringUtil.str2Numeric(m.get("hangupjobcount")+"")+"";
					expArr[index][8] = StringUtil.str2Numeric(m.get("confirmjobcount")+"")+"";
					index++;
				}
			}
				
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
			String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "Աͳ-"+dateTime);
			params.put("sheetName", "Աͳ");
			params.put("header", "Աͳ(Ʊʱ䣺"+DateUtil.currentDateTime()+")");
			new ExportPDF().exportCommPDF(params,header,new ArrayList(),0, expArr, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountuserrepairjobAction-exoprtPDF-error:" +e);
			
		}
	}
	
	
	
}
