package cn.yw.detector.service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.base.util.DateUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.detector.dao.DetectorDao;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("detectorService")
public class DetectorService extends BaseService {

    private static Log log = LogFactory.getLog(DetectorService.class);

    @Autowired
    private DetectorDao detectorDao;

    /**
     * ¼
     */
    public void insert_Detector(Map map) throws SQLException {
        CommUtils.addParams(map, false);
        detectorDao.insert_Detector(map);
    }


    /**
     * ޸ļ¼
     */
    public Integer update_Detector(Map map) throws SQLException {
        CommUtils.addParams(map, true);
        map.put("updatetime", new Date());
        return detectorDao.update_Detector(map);
    }


    /**
     * ޸ıעά״̬¼
     */
    public Integer update_DetectorRemarks(Map map) throws SQLException {
        CommUtils.validateUpdateParams(map);
        CommUtils.addParams(map, true);
        return detectorDao.update_DetectorRemarks(map);
    }
    public Integer delete_channelset_Detector(Map map) throws SQLException {
        CommUtils.validateDeleteParams(map);
        return detectorDao.delete_channelset_Detector(map);
    }

    /**
     * ɾ¼
     */
    public Integer delete_Detector(Map map) throws SQLException {
        CommUtils.validateDeleteParams(map);
        return detectorDao.delete_Detector(map);
    }

    /**
     * ɾ¼
     */
    public Integer batch_delete_Detector(List l) throws SQLException {
        return detectorDao.batch_delete_Detector(l);
    }

    public Integer batch_update_Detector(Map m) throws SQLException {
        return detectorDao.batch_update_Detector(m);
    }

    /**
     * ѯ
     */
    public Integer count_Detector(Map map) throws SQLException {
        return detectorDao.count_Detector(map);
    }

    /**
     * ѯб¼SELECT
     */
    public List<Map> query_Detector(Map map) throws SQLException {
        return detectorDao.query_Detector(map);
    }

    public List<Map> query_Detector_children(Map map) throws SQLException {
        return detectorDao.query_Detector_children(map);
    }

    /**
     * ѯһ
     */

    public Map get_Detector(Map map) throws SQLException {
        return detectorDao.get_Detector(map);
    }

    /**
     * EXCEL
     */

	/*
	public Map exportDetector(Map map) throws SQLException{
		return this.listDetectorByPage(map);
	}
	*/
    public List<Map> getApproveUser(Map map) throws SQLException {
        return detectorDao.getApproveUser(map);
    }

    /**
     * Detector ҳ
     */
    public Map listDetectorByPage(Map map) throws SQLException {
        List<Map> list = detectorDao.query_Detector(map);
        Integer totalCount = detectorDao.count_Detector(map);
        map.clear();
        map.put("total", totalCount);
        map.put("rows", list);
        return map;
    }

    public Map listDetectortaskByPage(Map map) throws SQLException {
        List<Map> list = detectorDao.query_DetectortaskByPage(map);
        Integer totalCount = detectorDao.count_Detector(map);
        map.clear();
        map.put("total", totalCount);
        map.put("rows", list);
        return map;
    }

    public Map listDetectorNotaskByPage(Map map) throws SQLException {
        List<Map> list = detectorDao.query_DetectorNotaskByPage(map);
        Integer totalCount = detectorDao.count_DetectorNotask(map);
        map.clear();
        map.put("total", totalCount);
        map.put("rows", list);
        return map;
    }

    public Map listNhywxlydptaskByPage(Map map) throws SQLException {
        List<Map> list = detectorDao.query_NhywxlydptaskByPage(map);
        Integer totalCount = detectorDao.count_Nhywxlydptask(map);
        map.clear();
        map.put("total", totalCount);
        map.put("rows", list);
        return map;
    }

    /**
     * ɾ¼
     */
    public Integer delete_Nhywxlydp(Map map) throws SQLException {
        CommUtils.validateDeleteParams(map);
        return detectorDao.delete_Nhywxlydp(map);
    }

    public Integer batchdelete_Nhywxlydp(Map map) throws SQLException {
        CommUtils.validateDeleteParams(map);
        return detectorDao.batchdelete_Nhywxlydp(map);
    }

    public void batchinsert_Nhywxlydp(List map) throws SQLException {
        detectorDao.batchinsert_Nhywxlydp(map);
    }


    // 
    public Integer edit_Detector(Map map) throws SQLException {
        return detectorDao.edit_Detector(map);
    }

    /**
     * ҳյͳ
     *
     * @return
     * @throws SQLException
     */
    public Map statisticsDetectorRate() throws SQLException {
        Map<String, Object> result = new HashMap<String, Object>();
        List<Map> list = detectorDao.statisticsDetectorRate();
        if (list != null && list.size() > 0) {
            for (Map m : list) {
                String name = m.get("name") + "";
                result.put(name, m.get("totalcount"));
            }
        }
        return result;
    }

    public Map listDetectorStatus(Map map) throws SQLException {
        List<Map> list = detectorDao.listDetectorStatus(map);
        Integer totalCount = detectorDao.countDetectorStatus(map);
        map.clear();
        map.put("total", totalCount);
        map.put("rows", list);
        return map;
    }

    public Integer updateDetctorJdWdByXh(Map map) throws SQLException {
        CommUtils.validateUpdateParams(map);
        CommUtils.addParams(map, true);
//		String username = ((PtyhBean) Struts2Utils.getSession().getAttribute("userInfo")).getYhmc();
//		map.put("xgry", username);
//		map.put("xgrq", DateUtil.currentDateTime());
        return detectorDao.updateDetctorJdWdByXh(map);
    }

    public Map listDetectorCurrentstateByPage(Map map) throws SQLException {
        List<Map> list = detectorDao.query_DetectorcurrentstateByPage(map);
        Integer totalCount = detectorDao.count_Detector(map);
        map.clear();
        map.put("total", totalCount);
        map.put("rows", list);
        return map;
    }

    public Map listDetectorhistorystateByPage(Map map) throws SQLException {
        List<Map> list = detectorDao.query_DetectorhistoryByPage(map);
        Integer totalCount = detectorDao.count_Detectorhistory(map);
        map.clear();
        map.put("total", totalCount);
        map.put("rows", list);
        return map;
    }

    public Map listDetectorCurrentstate(Map map) throws SQLException {
        List<Map> list = detectorDao.query_Detectorcurrentstate(map);
        Integer totalCount = detectorDao.count_Detector(map);
        map.clear();
        map.put("total", totalCount);
        map.put("rows", list);
        return map;
    }

    /***
     * µǰ״̬
     * @param map
     * @return
     * @throws SQLException
     */
    public Integer update_DetectorCurrentState(Map map) throws SQLException {
        CommUtils.validateUpdateParams(map);
        CommUtils.addParams(map, true);
        return detectorDao.update_DetectorCurrentState(map);
    }

    public Map getDetectorStatusData(Map map) throws SQLException {
        List<Map> list = detectorDao.query_DetectorStatusData(map);
        Integer totalCount = detectorDao.count_DetectorStatusData(map);
        map.clear();
        map.put("total", totalCount);
        map.put("rows", list);
        return map;

    }

}
