package cn.nhyw.gysgl.action;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.FTPUtil;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.nhyw.gysgl.service.NhywcpxhglService;

@SuppressWarnings({"all"})
@Component("nhywcpxhglAction")
public class NhywcpxhglAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(NhywcpxhglAction.class);
	
	@Autowired
	private NhywcpxhglService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listNhywcpxhglByPage")
	public void listNhywcpxhglByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listNhywcpxhglByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywcpxhglAction-listNhywcpxhglByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Nhywcpxhgl")
	public void count_Nhywcpxhgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Nhywcpxhgl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywcpxhglAction-count_Nhywcpxhgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Nhywcpxhgl
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Nhywcpxhgl")
	public void query_Nhywcpxhgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Nhywcpxhgl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywcpxhglAction-query_Nhywcpxhgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һNhywcpxhgl
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Nhywcpxhgl")
	public void get_Nhywcpxhgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Nhywcpxhgl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywcpxhglActionquery_Nhywcpxhgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteNhywcpxhgl")
	public void delete_Nhywcpxhgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){				
				String zpUrl = (String) map.get("sbzp");
				if(RHUtil.isNotEmpty(zpUrl) && !"null".equals(zpUrl)) {
					FTPUtil.deleteFileFromFtpUrl(zpUrl);
				}
				int result = service.delete_Nhywcpxhgl(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywcpxhglAction-delete_Nhywcpxhgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Nhywcpxhgl")
	public void insert_Nhywcpxhgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("xh"))){
				map.put("xh",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Nhywcpxhgl(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Nhywcpxhgl(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Nhywcpxhgl(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywcpxhglAction-insert_Nhywcpxhgl()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Nhywcpxhgl")
	public void update_Nhywcpxhgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			
			String xh = (String) map.get("XGTJxh");			
			String zpUrl = (String) map.get("sbzp");
			String jcbgUrl = (String) map.get("sbzp");
			
			//ѯ¼
			Map cpxqMap = new HashMap();			// ɾԭеƬ     ٸƬַ
			cpxqMap.put("xh", xh);
			Map cpxhglMap = service.get_Nhywcpxhgl(cpxqMap);
			if(RHUtil.isNotEmpty(zpUrl)) {					// ˵ϴƬ				
				if(RHUtil.isNotEmpty(cpxhglMap)) {
					String sbzp = (String) cpxhglMap.get("sbzp");
					if(RHUtil.isNotEmpty(sbzp)) {
						FTPUtil.deleteFileFromFtpUrl(sbzp);
					}
				}	
			}
			if(RHUtil.isNotEmpty(jcbgUrl)) {					// ˵ϴ˼ⱨ			
				if(RHUtil.isNotEmpty(cpxhglMap)) {
					String jcbg = (String) cpxhglMap.get("jcbg");
					if(RHUtil.isNotEmpty(jcbg)) {
						FTPUtil.deleteFileFromFtpUrl(jcbg);
					}
				}	
			}		
			int result = service.update_Nhywcpxhgl(map);
			
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywcpxhglAction-update_Nhywcpxhgl-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	/*
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Nhywcpxhgl")
	public void batch_delete_Nhywcpxhgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Nhywcpxhgl(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywcpxhglAction-batch_delete_Nhywcpxhgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Nhywcpxhgl")
	public void exp_Nhywcpxhgl(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Nhywcpxhgl(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ƷͺŹ-"+dateTime);
			params.put("sheetName", "ƷͺŹ");
			params.put("header", "ƷͺŹ");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywcpxhglAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Nhywcpxhgl")
	public String imp_Nhywcpxhgl(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("NhywcpxhglAction-imp_Nhywcpxhgl-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
