package cn.im.trafficdevice.action;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.conf.ModuleConfFactory;
import cn.base.conf.RoadDirection;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.im.trafficdevice.service.TrafficroadinfoService;

@SuppressWarnings({"all"})
@Component("trafficroadinfoAction")
public class TrafficroadinfoAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(TrafficroadinfoAction.class);
	
	@Autowired
	private TrafficroadinfoService service;
	
	/**
	 * test
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="test")
	public  void test(){
		Map map = new HashMap<>();
		try{
			Struts2Utils.renderJson(this.service.listTrafficroadinfoByPage(map));
		}catch(Exception e){
			e.printStackTrace();
			iLog.error("TrafficroadinfoAction-listTrafficroadinfoByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ȡ·ηļ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getRoadDirectionInfo")
	public void getRoadDirectionInfo(){
		try{
			RoadDirection rd = ModuleConfFactory.getInstance().getRoadDirection();
			System.out.println(rd);
			Map<String, Object> map = new HashMap<String, Object>();
//			Properties props = new Properties();
//			InputStreamReader ins = new InputStreamReader(GetPropertiesInfo.class.getClassLoader().getResourceAsStream("roadDirection.properties"),"utf-8");
//			props.load(ins);
//			Enumeration en = props.propertyNames();
//            while (en.hasMoreElements()) {
//                String key = (String) en.nextElement();
//                String property = props.getProperty(key);
//                map.put(key, new Gson().fromJson(property, new TypeToken<HashMap<String,String>>(){}.getType()));
//            }
//            ins.close();
            map.put("up", new Gson().fromJson(rd.getUp(), new TypeToken<HashMap<String,String>>(){}.getType()));
            map.put("down", new Gson().fromJson(rd.getDown(), new TypeToken<HashMap<String,String>>(){}.getType()));
			Struts2Utils.renderJson(map);
		}catch(Exception e){
			e.printStackTrace();
			iLog.error("TrafficroadinfoAction-getRoadDirectionInfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ȡȫ·Ϣ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getTrafficroadinfoAll")
	public  void getTrafficroadinfoAll(){
		try{
			Struts2Utils.renderJson(this.service.getTrafficroadinfoAll());
		}catch(Exception e){
			e.printStackTrace();
			iLog.error("TrafficroadinfoAction-getTrafficroadinfoAll-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listTrafficroadinfoByPage")
	public void listTrafficroadinfoByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listTrafficroadinfoByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadinfoAction-listTrafficroadinfoByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Trafficroadinfo")
	public void count_Trafficroadinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Trafficroadinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadinfoAction-count_Trafficroadinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Trafficroadinfo
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Trafficroadinfo")
	public void query_Trafficroadinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Trafficroadinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadinfoAction-query_Trafficroadinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һTrafficroadinfo
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Trafficroadinfo")
	public void get_Trafficroadinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Trafficroadinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadinfoActionquery_Trafficroadinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteTrafficroadinfo")
	public void delete_Trafficroadinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Trafficroadinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadinfoAction-delete_Trafficroadinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Trafficroadinfo")
	public void insert_Trafficroadinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("roadId"))){
				map.put("roadId",StringUtil.getUUID());
			}
			service.insert_Trafficroadinfo(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadinfoAction-listTrafficroadinfoByPage()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ޸
	 */
	
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Trafficroadinfo")
	public void update_Trafficroadinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			map.put("XGTJroadId", map.get("roadId"));        	// id޸
			int result = service.update_Trafficroadinfo(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadinfoAction-update_Trafficroadinfo-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	/*
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Trafficroadinfo")
	public void batch_delete_Trafficroadinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Trafficroadinfo(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadinfoAction-batch_delete_Trafficroadinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="exoprtExcel")
	public void exoprtExcel(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			map = service.exportTrafficroadinfo(map);
			ExcelCol[] cells = new ExcelCol[2];
			cells[0] = new ExcelCol();
			cells[0].setColKey("ֶ");
			cells[0].setColName("ֶ");
			cells[1] = new ExcelCol();
			cells[1].setColKey("ֶ");
			cells[1].setColName("ֶ");
			Map params = new HashMap();
			params.put("fileName", "·Ϣ");
			params.put("sheetName", "·Ϣ");
			params.put("header", "·Ϣ");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadinfoAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * ɾ  ·Ϣ        ɾtrafficdevicerelateеϢ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="delete_TrafficRoadDeviceInfo")
	public void delete_TrafficRoadDeviceInfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_TrafficRoadDeviceInfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadinfoAction-delete_TrafficRoadDeviceInfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
}
