package cn.base.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import flexjson.JSONSerializer;
import net.sf.ezmorph.object.DateMorpher;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONUtils;

@SuppressWarnings("all")
public class JsonUtil {

	/**ҳ洫̨ʱjsonrequestĲ*/
	public final static String JSON_ATTRIBUTE = "json";
	public final static String JSON_ATTRIBUTE1 = "json1";
	public final static String JSON_ATTRIBUTE2 = "json2";
	public final static String JSON_ATTRIBUTE3 = "json3";
	public final static String JSON_ATTRIBUTE4 = "json4";
	
	/**
	 * һJSON ַʽеõһjava磺
	 * {"id" : idValue, "name" : nameValue, "aBean" : {"aBeanId" : aBeanIdValue, ...}}
	 * @param object
	 * @param clazz
	 * @return
	 */
	public static Object getDTO(String jsonString, Class clazz){
		JSONObject jsonObject = null;
		try{
			setDataFormat2JAVA(); 
			jsonObject = JSONObject.fromObject(jsonString);
		}catch(Exception e){
			e.printStackTrace();
		}
		return JSONObject.toBean(jsonObject, clazz);
	}
	
	/**
	 * һJSON ַʽеõһjavabeansListһļϣ磺
	 * {"id" : idValue, "name" : nameValue, "aBean" : {"aBeanId" : aBeanIdValue, ...},
	 * beansList:[{}, {}, ...]}
	 * @param jsonString
	 * @param clazz
	 * @param map Ե (key : , value : class) eg: ("beansList" : Bean.class)
	 * @return
	 */
	public static Object getDTO(String jsonString, Class clazz, Map map){
		JSONObject jsonObject = null;
		try{
			setDataFormat2JAVA(); 
			jsonObject = JSONObject.fromObject(jsonString);
		}catch(Exception e){
			e.printStackTrace();
		}
		return JSONObject.toBean(jsonObject, clazz, map);
	}
	
	/**
	 * һJSONõһjava飬磺
	 * [{"id" : idValue, "name" : nameValue}, {"id" : idValue, "name" : nameValue}, ...]
	 * @param object
	 * @param clazz
	 * @return
	 */
	public static Object[] getDTOArray(String jsonString, Class clazz){
		setDataFormat2JAVA();
		JSONArray array = JSONArray.fromObject(jsonString);
		Object[] obj = new Object[array.size()];
		for(int i = 0; i < array.size(); i++){
			JSONObject jsonObject = array.getJSONObject(i);
			obj[i] = JSONObject.toBean(jsonObject, clazz);
		}
		return obj;
	}
	
	/**
	 * һJSONõһjava飬磺
	 * [{"id" : idValue, "name" : nameValue}, {"id" : idValue, "name" : nameValue}, ...]
	 * @param object
	 * @param clazz
	 * @param map
	 * @return
	 */
	public static Object[] getDTOArray(String jsonString, Class clazz, Map map){
		setDataFormat2JAVA();
		JSONArray array = JSONArray.fromObject(jsonString);
		Object[] obj = new Object[array.size()];
		for(int i = 0; i < array.size(); i++){
			JSONObject jsonObject = array.getJSONObject(i);
			obj[i] = JSONObject.toBean(jsonObject, clazz, map);
		}
		return obj;
	}
	
	/**
	 * һJSONõһjava󼯺
	 * @param object
	 * @param clazz
	 * @return
	 */
	public static List getDTOList(String jsonString, Class clazz){
		setDataFormat2JAVA();
		JSONArray array = JSONArray.fromObject(jsonString);
		List list = new ArrayList();
		for(Iterator iter = array.iterator(); iter.hasNext();){
			JSONObject jsonObject = (JSONObject)iter.next();
			list.add(JSONObject.toBean(jsonObject, clazz));
		}
		return list;
	}
	
	/**
	 * һJSONõһjava󼯺ϣжам
	 * @param object
	 * @param clazz
	 * @param map Ե
	 * @return
	 */
	public static List getDTOList(String jsonString, Class clazz, Map map){
		setDataFormat2JAVA();
		JSONArray array = JSONArray.fromObject(jsonString);
		List list = new ArrayList();
		for(Iterator iter = array.iterator(); iter.hasNext();){
			JSONObject jsonObject = (JSONObject)iter.next();
			list.add(JSONObject.toBean(jsonObject, clazz, map));
		}
		return list;
	}
	
	/**
	 * json HASHʽлȡһmapmap֧Ƕ׹
	 * 磺{"id" : "johncon", "name" : "Сǿ"}
	 * עcommons-collections汾org.apache.commons.collections.map.MultiKeyMap
	 * @param object
	 * @return
	 */
	public static Map getMapFromJson(String jsonString) {
		setDataFormat2JAVA();
        JSONObject jsonObject = JSONObject.fromObject(jsonString);
        Map map = new HashMap();
        for(Iterator iter = jsonObject.keys(); iter.hasNext();){
            String key = (String)iter.next();
            map.put(key, jsonObject.get(key));
        }
        return map;
    }
	
	/**
	 * ObjectתJSONʽַͻ(磺objectListͣҰҲл)
	 * @param object Java,תΪjsonַ.
	 * @param headers Ϊʱ"encoding:UTF-8""no-cache:true"
	 */
	public static String renderDeepJson (final Object object, final String... headers) {
		String jsonString = new JSONSerializer().exclude("class").deepSerialize(object);
		return jsonString;
	}
	
	/**
     * jsonеõӦjava
     * json磺["123", "456"]
     * @param jsonString
     * @return
     */
    public static Object[] getObjectArrayFromJson(String jsonString) {
        JSONArray jsonArray = JSONArray.fromObject(jsonString);
        return jsonArray.toArray();
    }
	
	private static void setDataFormat2JAVA(){
		//趨תʽ
		JSONUtils.getMorpherRegistry().registerMorpher(new DateMorpher(new String[] {"yyyy-MM-dd HH:mm:ss","yyyy-MM-dd"}));
	}
}
