<%@ page language="java" import="java.util.*" pageEncoding="gbk"%>
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=gbk" />
    <%@include file="../../../../../frame/assets/header-all.jsp"%> 
    <link rel="stylesheet" type="text/css" href="../../../../resource/css/map.frame.css">
</head>
<body class="easyui-layout" onselectstart="return false">
    <div data-options="region:'center',split:false" class="easyui-layout"  style="border: none">
        <table id="monitor-tab-grid"></table>
     </div>   
	<div id="monitor-contextMenu" class="easyui-menu" style="width:100px;display: none">   
	      <div iconCls="icon-actMode" onclick="startvideo();">ʵʱƵ</div>   
	      <div iconCls="icon-video" onclick="startrecord();">¼񵹲</div>
	      <div iconCls="icon-info-look" onclick="openWindow()">ϸϢ</div>   
	      <div iconCls="icon-location" onclick="locate();">ͼλ</div> 
	</div>
	<div style="z-index:1;height:0">
		<OBJECT ID="ocx" style="LEFT: 0px; TOP: 0px;"  width="100%" height="100%"
             CLSID="{308F1C9C-98B6-41A7-8320-FA601ABD7341}" TYPE="application/x-itst-activex">  
    	</OBJECT>
	</div>
<script type="text/javascript">
var maingrid = null ,windowid,windowid;

function getGrid (){
	return maingrid;
}

$(function(){
    initGrid();
})
//б
function initGrid(){ 
	var toolbar = [{
        text:'Ƶ',
        iconCls:'icon-actMode',
        handler:videoSelectAll
    },{
        text:'¼',
        iconCls:'icon-video',
        handler:startrecord
    },{
        text:'ɾ',
        iconCls:'icon-delete',
        handler:deleteRows
    },{
        text:'',
        iconCls:'icon-clear',
        handler:clearGrid
    }];
	maingrid = $('#monitor-tab-grid').datagrid({
        queryParams:'',
        rownumbers:true,
        border:false,
        singleSelect:false,
        toolbar:toolbar,
        columns : [
        	[{ 	field: 'A',
				checkbox:'true',
				width:30
        	},{
        		field:'tdmc',title:'ͷ',width:220,
                formatter:function showClick(value,record,index){ 
                	return "<span title="+value+" >"+value+"</span>";
               	}
            }
        ]],
        onRowContextMenu: function (e, rowIndex, rowData) {  
        	$('#monitor-tab-grid').datagrid('selectRow', rowIndex);
        	$.data(document.body, "selectData", rowData);
        	$('#monitor-contextMenu').menu('show', { 
        		left: e.pageX, 
        		top: e.pageY 
        		}); 
        	e.preventDefault();
        },
        onDblClickRow: function(index,row){
        	locate(row);
        }
    });
}
//ѡ
function addtGridData(record,clear){
	var grid = getGrid();
	var rows = grid.datagrid('getData').rows;
	if(grid){
		if(clear){
			grid.datagrid('loadData',{ total: 0, rows: [] });
		}
		if(rows.length != 0){
			for(var i = 0;i<rows.length;i++){
				if(rows[i].id == record.id){
					$.showMsg("Ѽѡ");
					return;
				}
			}
		}
		grid.datagrid('appendRow',record);
	}
	return;
}
//鿴
function openWindow(){
	var records = $.data(document.body, "selectData");
 	windowid = top.$.createWin({
		 title	: 	'ͷ',
		 width  :  600,
		 height :  300,
		 data	:  records,
		 url	:  top.sysUrl+"/szmap/business/base/item/iframe/monitor-tab_show.jsp"
	 });
	$.data(document.body, "selectData", ""); 
}

//ͼλ
function locate(row){
	if(!row){
		var records = $.data(document.body, "selectData");
	}else{
		var records = row;
	}
	parent.MapAPI.centerAtLatLngZoom(records.jd,records.wd,top.ditu.mapLevel );
	parent.MapMain.getLayer(parent.MapConst.LAYER_MONITOR).locateMarker(records);
	$.data(document.body, "selectData","");
}
//ʵʱƵ
function startvideo(){
	var records = $.data(document.body, "selectData");
    if(!ocx) {
        $.log("ocx is undefined...");
        return ;
    } 
    var sbbh      = records.sbbh;
    var tdbh = records.tdbh;
    try {       
        ocx.iSeeOcxNewWindow(3);
        ocx.iSeeOcxSetPopupWndProperties('',300,200);
        ocx.iSeeOcxSetScreenModeEx(0,1);
        ocx.iSeeOcxMonitorStartEx2(0,0,sbbh,tdbh,0);
    } catch(e) {
    	$.showMsg("Ƶ쳣");
    }
    $.data(document.body, "selectData","");
}
//¼ز
function startrecord(){
	var datenow = new Date();
	var records = $("#monitor-tab-grid").datagrid("getSelected");
    if(!ocx) {
        $.log("ocx is undefined...");
        return ;
    } 
    var snapTime = datenow.format("yyyy-MM-dd hh:mm:ss");
        snapTime = snapTime.replace(new RegExp("-","gm"),"/");
    var startTime = (new Date(snapTime)).getTime()-(1000*60*60*24*12);
    var endTime = (new Date(snapTime)).getTime();
    startTime = ($.formatDate(new Date(startTime),"yyyy-MM-dd hh:mm:ss")); 
    endTime = ($.formatDate(new Date(endTime),"yyyy-MM-dd hh:mm:ss")); 
    try {       
        ocx.iSeeOcxNewWindow(3);
        ocx.iSeeOcxSetPopupWndProperties('',300,200);
        ocx.iSeeOcxSetScreenModeEx(0,1);
        var ret = ocx.iSeeOcxDoPlaybackByTime(0,records.sbbh,records.tdbh, startTime, endTime);
        console.log('startrecord: ret:' + ret );
    } catch(e) {
    	$.showMsg("¼񲥷쳣");
    }
}
//һƵ
function videoSelectAll(){
	var resource = $("#monitor-tab-grid").datagrid("getChecked");
 	if(resource==""||resource==null||resource==undefined){
 		$.showMsg("ݣ");
		return;
	}
 	try {       
 		ocx.iSeeOcxNewWindow(3);
 		if(resource.length==1){
 			ocx.iSeeOcxSetPopupWndProperties('',300,200);
 			ocx.iSeeOcxSetScreenModeEx(0,1);
 		}
 		if(resource.length>1&&resource.length<=4){
 			ocx.iSeeOcxSetPopupWndProperties('',400,300);
 			ocx.iSeeOcxSetScreenModeEx(0,4);
 		}
 		if(resource.length>4&&resource.length<=9){
 			ocx.iSeeOcxSetPopupWndProperties('',600,400);
 			ocx.iSeeOcxSetScreenModeEx(0,9);
 		}
 		if(resource.length>9&&resource.length){
 			ocx.iSeeOcxSetPopupWndProperties('',800,600);
 			ocx.iSeeOcxSetScreenModeEx(0,16);
 		}
 		for(var i=0;i<resource.length;i++){	
 			if(resource[i].sbbh && resource[i].tdbh){
 				ocx.iSeeOcxMonitorStartEx2(0,i,resource[i].sbbh, resource[i].tdbh, 0);
 			}
 		} 
    } catch(e) {
    	$.showMsg("Ƶ쳣");
    }
 	
}
//ɾѡ
function deleteRows(){
	 var selRows = $('#monitor-tab-grid').datagrid('getSelections'),j=0,rowIndex;
	 if(selRows.length==0){
		 $.showMsg('ѡһ! ');
		 return;
	 }else{
		top.$.dlg.confirm('ȷɾѡ?',function(){ 
		    for(var i=0;i<selRows.length;i++){
		    	rowIndex = $('#monitor-tab-grid').datagrid('getRowIndex',selRows[i]);
		    	$('#monitor-tab-grid').datagrid('deleteRow',rowIndex);
		    }
		}); 
	}
}
//
function clearGrid(){
	var data=$('#monitor-tab-grid').datagrid('getData').rows;
	if(data.length==0){
		$.showMsg('ݣ ');
		return;
	}else{
		top.$.dlg.confirm('ȷ?',function(){ 
			$("#monitor-tab-grid").datagrid('loadData',{total:0,rows:[]});
		});
	}
	
}
</script>
</body>
</html>	
