package cn.im.trafficplan.action;

 import cn.im.trafficplan.service.TrafficplanalarmdeviceService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;

@SuppressWarnings({"all"})
@Component("trafficplanalarmdeviceAction")
public class TrafficplanalarmdeviceAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(TrafficplanalarmdeviceAction.class);
	
	@Autowired
	private TrafficplanalarmdeviceService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listTrafficplanalarmdeviceByPage")
	public void listTrafficplanalarmdeviceByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listTrafficplanalarmdeviceByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanalarmdeviceAction-listTrafficplanalarmdeviceByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="delete_Trafficplanalarmdevice")
	public void delete_Trafficplanalarmdevice(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Trafficplanalarmdevice(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanalarmdeviceAction-delete_Trafficplanalarmdevice-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Trafficplanalarmdevice")
	public void insert_Trafficplanalarmdevice(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("alarmID"))){
				map.put("alarmID",StringUtil.getUUID());
			}
			service.insert_Trafficplanalarmdevice(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanalarmdeviceAction-listTrafficplanalarmdeviceByPage()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Trafficplanalarmdevice")
	public void update_Trafficplanalarmdevice(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Trafficplanalarmdevice(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficplanalarmdeviceAction-update_Trafficplanalarmdevice-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
}
