package cn.im.trafficcount.action;

 import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.conf.ModuleConfFactory;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.Struts2Utils;
import cn.im.trafficcount.service.BigScreenService;

@SuppressWarnings({"all"})
@Component("bigScreenAction")
public class BigScreenAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(BigScreenAction.class);
	
	@Autowired
	private BigScreenService service;
	
	
	// ҳ  ѯ ͷϢ 
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getBigScreenInfo")
	public void getBigScreenInfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.getBigScreenInfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("bigScreenAction-getBigScreenInfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// ҳ  ѯ ͷϢ 
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getEventInfo")
	public void getEventInfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			
			// òѯʱ     ʱ      Ŀǰֻѯ1
			String occurTimeStart = DateUtil.getYMD();
			String occurTimeEnd = DateUtil.currentDateTime();
//			map.put("occurTimeStart", occurTimeStart);
//			map.put("occurTimeEnd", occurTimeStart);
			map.put("start",0 );
			map.put("limit",1 );
			
			Struts2Utils.renderJson(this.service.getEventInfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("bigScreenAction-getBigScreenInfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	//ѯ
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getSbtdspsr")
	public void getSbtdspsr() {
		Map map = Struts2Utils.getRequestParameterMap();	
		try {	
			Struts2Utils.renderJson(this.service.getSbtdspsr(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("bigScreenAction-getSbtdspsr-error:" +e);
			Struts2Utils.renderJson(null);
		}

	}	
	
	// ҳ Ҳ澯¼ѯ  ҳ
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getAlarmEvent")
	public void getAlarmEvent() {
		Map map = Struts2Utils.getRequestParameterMap();	
		try {	
			if("3".equals(ModuleConfFactory.getModuleConfService().getTraffAccident().getAlarmSearchChoose())){
				map.put("createAccount", "webservice");
			}else if("2".equals(ModuleConfFactory.getModuleConfService().getTraffAccident().getAlarmSearchChoose())){
				map.put("createAccount", "sqlserver");
			}else{
				map.put("createAccount", "");
			}
			Struts2Utils.renderJson(this.service.getAlarmEvent(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("bigScreenAction-getAlarmEvent-error:" +e);
			Struts2Utils.renderJson(null);
		}

	}
}
