package cn.im.ptdlfw.service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.im.ptdlfw.dao.PtdlfwzDao;

@Service("ptdlfwzService")
public class PtdlfwzService extends BaseService {
	
	private static Log log = LogFactory.getLog(PtdlfwzService.class);
	
	@Autowired
	private PtdlfwzDao ptdlfwzDao;
	
	/**
	 * ¼
	 * 
	 * @param
	 * @return
	 */
	public void insert_Ptdlfwz(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ptdlfwzDao.insert_Ptdlfwz(map);
	}

	
	/**
	 * ޸ļ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer update_Ptdlfwz(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ptdlfwzDao.update_Ptdlfwz(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer delete_Ptdlfwz(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ptdlfwzDao.delete_Ptdlfwz(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 */
	public Integer batch_delete_Ptdlfwz(Map map) throws SQLException{
		return ptdlfwzDao.batch_delete_Ptdlfwz(map);
	}

	
	/**
	 * ѯ
	 * 
	 * @param
	 * @return
	 */
	public Integer count_Ptdlfwz(Map map) throws SQLException{
		return ptdlfwzDao.count_Ptdlfwz(map);
	}
	
	/**
	 * ѯб¼SELECT
	 * 
	 * @param
	 * @return
	 */
	public List<Map> query_Ptdlfwz(Map map) throws SQLException{
		return ptdlfwzDao.query_Ptdlfwz(map);
	}
	
	/**
	 * ѯһ
	 * 
	 * @param
	 * @return
	 */
	public Map get_Ptdlfwz(Map map) throws SQLException{
		return ptdlfwzDao.get_Ptdlfwz(map);
	}
	
	/**
	 * EXCEL
	 * 
	 * @param
	 * @return
	 */
	public Map exportPtdlfwz(Map map) throws SQLException{
		return this.listPtdlfwzByPage(map);
	}
	
	/**
	 * Ptdlfwz ҳ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listPtdlfwzByPage(Map map) throws SQLException {
		List<Map> list = ptdlfwzDao.query_Ptdlfwz(map);
		Integer totalCount = ptdlfwzDao.count_Ptdlfwz(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
}
