package cn.base.excel;

import java.io.OutputStream;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;

@SuppressWarnings("all")
public class ExportEngine {
	private static Log iLog = LogFactory.getLog(ExportEngine.class.getName());

	public void exportData(String sheetName, ExcelCol[] headertxt, List<Map> list, HttpServletResponse responses) {
		OutputStream os = null;
		try {
			os = responses.getOutputStream();
			responses.reset();// 
			responses.setHeader("Content-disposition", "attachment; filename=" + (new Date()).getTime() + ".xls");// 趨ļͷ
			responses.setContentType("application/msexcel");// 
			HSSFWorkbook workbook = new HSSFWorkbook();
			// 
			HSSFFont font = workbook.createFont();
			// Ӵ
			font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
			// ʲô
			font.setFontName(" ");
			// Ԫʽ
			HSSFCellStyle cellStyle = workbook.createCellStyle();
			// ԪʲôúõĶ
			cellStyle.setFont(font);
			cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
			HSSFSheet sheet = workbook.createSheet(sheetName);
			sheet.setDefaultColumnWidth((short) 12);
			// ɱͷ
			HSSFRow row = sheet.createRow((short) 0);
			if (headertxt != null && headertxt.length > 0) {
				short j = 0;
				for (ExcelCol s : headertxt) {
					HSSFCell cell1 = row.createCell(j);
					cell1.setCellValue(headertxt[j].getColName());
					cell1.setCellStyle(cellStyle);
					j = (short) (j + 1);
				}

			}
			HSSFCellStyle cs = workbook.createCellStyle();
			cs.setAlignment(HSSFCellStyle.ALIGN_CENTER);
			// 
			for (int i = 0; i < list.size(); i++) {
				HSSFRow datarow = sheet.createRow((short) i + 1);
				Map mp = list.get(i);
				for (short k = 0; k < headertxt.length; k++) {
					HSSFCell datacell = datarow.createCell(k);
					datacell.setCellStyle(cs);
					datacell.setCellValue(mp.get(headertxt[k].getColKey()) == null ? "" : mp.get(headertxt[k].getColKey()) + "");
				}
			}
			workbook.write(os);
			iLog.info("ɹExcel!");
			// дļ
		} catch (Exception ex) {
			iLog.error("Excel", ex);
		} finally {
			try {
				os.close();
			} catch (Exception ex) {
				iLog.error("رosʧ", ex);
			}
		}
	}
	/**
	 * ׼ʽExcelͨ÷
	 * 
	 * @param map
	 * @param headertxt
	 * @param list
	 *            Ŀǰֻ֧List<Map> ʽ
	 * @param responses
	 */
	public void exportCommData(Map map, ExcelCol[] headertxt, List<HashMap> list, HttpServletResponse responses) {
		OutputStream os = null;
		try {
			os = responses.getOutputStream();
			responses.reset();// 
			String fileName = map.get("fileName").toString();
			fileName = toUtf8String(fileName);
			responses.setHeader("Content-disposition", "attachment; filename=" + fileName + ".xls");// 趨ļͷ
			responses.setContentType("application/msexcel");// 
			HSSFWorkbook workbook = new HSSFWorkbook();
			HSSFFont font = workbook.createFont();// 
			font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);// Ӵ
			font.setFontName(" ");// 
			// Sheet
			HSSFSheet sheet = workbook.createSheet(map.get("sheetName").toString());
			sheet.setDefaultColumnWidth((short) 14);// Ĭп
			// ϲԪ,ͷ˵Ϣ
			sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, headertxt.length - 1));
			HSSFCellStyle cellStyle2 = setHeadRegionStyle(workbook);// úϲͷԪʽ
			// һ
			HSSFRow row2 = sheet.createRow(0);
			row2.setHeight((short) 400);
			HSSFCell cell2 = row2.createCell(0);
			cell2.setCellValue(map.get("header").toString());
			cell2.setCellStyle(cellStyle2);
			for (int k = 1; k < headertxt.length; k++) {
				row2.createCell(k).setCellStyle(cellStyle2);
			}
			HSSFCellStyle cellStyle = setRowsRegionStyle(workbook);// úϲеԪʽ
			// ڶУɱͷ
			HSSFRow row = sheet.createRow(1);
			if (headertxt != null && headertxt.length > 0) {
				short j = 0;
				for (ExcelCol s : headertxt) {
					HSSFCell cell1 = row.createCell(j);
					cell1.setCellValue(headertxt[j].getColName());
					cell1.setCellStyle(cellStyle);
					j = (short) (j + 1);
				}
			}
			HSSFCellStyle cs = setCommonStyle(workbook);// ͨԪʽ
			// 
			for (int i = 0; i < list.size(); i++) {
				HSSFRow datarow = sheet.createRow((short) i + 2);
				Map mp = list.get(i);
				for (short k = 0; k < headertxt.length; k++) {
					HSSFCell datacell = datarow.createCell(k);
					datacell.setCellStyle(cs);
					datacell.setCellValue(mp.get(headertxt[k].getColKey()) == null ? "" : mp.get(headertxt[k].getColKey()) + "");
				}
			}
			workbook.write(os);
			os.flush();    
			iLog.info("ɹExcel!");
			// дļ
		} catch (Exception ex) {
			iLog.error("Excel", ex);
		} finally {
			try {
				os.close();
			} catch (Exception ex) {
				iLog.error("رosʧ", ex);
			}
		}
	}

	// ͷϲԪʽ
	public HSSFCellStyle setHeadRegionStyle(HSSFWorkbook workbook) {
		HSSFCellStyle cellStyle = setCommonStyle(workbook);
		HSSFFont font = workbook.createFont();
		font.setFontHeightInPoints((short) 15);// С
		font.setFontName("");// 
		cellStyle.setFont(font);
		return cellStyle;
	}

	// кϲԪʽ
	public HSSFCellStyle setRowsRegionStyle(HSSFWorkbook workbook) {
		HSSFFont font = workbook.createFont();
		font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);// Ӵ
		font.setFontName("");
		HSSFCellStyle cellStyle = setCommonStyle(workbook);
		cellStyle.setFont(font);
		return cellStyle;
	}

	// ͨԪʽ
	public HSSFCellStyle setCommonStyle(HSSFWorkbook workbook) {
		HSSFCellStyle cellStyle = workbook.createCellStyle();
		cellStyle.setBorderLeft(HSSFCellStyle.BORDER_THIN);// ߿
		cellStyle.setBorderTop(HSSFCellStyle.BORDER_THIN);// ϱ߿
		cellStyle.setBorderRight(HSSFCellStyle.BORDER_THIN);// ұ߿
		cellStyle.setBorderBottom(HSSFCellStyle.BORDER_THIN);// ±߿
		cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER); // ˮƽ
		cellStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);// ֱ
		return cellStyle;
	}

	// ַתutf8룬֤ļ
	public static String toUtf8String(String s) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < s.length(); i++) {
			char c = s.charAt(i);
			if (c >= 0 && c <= 255) {
				sb.append(c);
			} else {
				byte[] b;
				try {
					b = Character.toString(c).getBytes("utf-8");
				} catch (Exception ex) {
					b = new byte[0];
				}
				for (int j = 0; j < b.length; j++) {
					int k = b[j];
					if (k < 0)
						k += 256;
					sb.append("%" + Integer.toHexString(k).toUpperCase());
				}
			}
		}
		return sb.toString();
	}

}
