package cn.im.trafficdevice.dao;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import org.springframework.stereotype.Repository;
import com.ibatis.sqlmap.client.SqlMapClient;

@Repository("trafficdevicerelateDao")
public class TrafficdevicerelateDao  extends SqlMapClientDaoSupport{

	@Autowired 
    private SqlMapClient sqlMapClient;  
      
	@PostConstruct          
    public  void initSqlMapClient(){  
    	super.setSqlMapClient(sqlMapClient);      
    }
	
	
	/**
	 * Ӽ¼
	 */
	
	public void insert_Trafficdevicerelate(Map map) throws SQLException{
		this.getSqlMapClientTemplate().insert("insert_Trafficdevicerelate",map);
	}
	public List<Map> getTunnelDeviceList() throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getTunnelDeviceList");
	}
	public List<Map> getTunnelLedDeviceList() throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getTunnelLedDeviceList");
	}
	public List<Map> getTunnelLightDeviceList() throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getTunnelLightDeviceList");
	}
	public List<Map> getTunnelAerationDeviceList() throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getTunnelAerationDeviceList");
	}
	public List<Map> getTunnelLaneindicateDeviceList() throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getTunnelLaneindicateDeviceList");
	}
	public List<Map> getTunnelBigscreenDeviceList() throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getTunnelBigscreenDeviceList");
	}
	public List<Map> getTunnelVoicelightDeviceList() throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getTunnelVoicelightDeviceList");
	}
	public List<Map> getTunnelVoiceDeviceList() throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getTunnelVoiceDeviceList");
	}
	public List<Map> getTunnelLightcontrolDeviceList() throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getTunnelLightcontrolDeviceList");
	}
	
	/**
	 * Ӽ¼
	 */
	
	public void batch_insert_Trafficdevicerelate(List batch) throws SQLException{
		this.getSqlMapClientTemplate().insert("batch_insert_Trafficdevicerelate",batch);
	}
	
	
	public Integer update_TrafficdevicePositionRelate(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().update("update_TrafficdevicePositionRelate",map);
	}
	
	/**
	 * ޸ļ¼
	 */
	public Integer update_Trafficdevicerelate(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().update("update_Trafficdevicerelate",map);
	}
	public Integer updateRemarks(List<Map<String,String>> list) throws SQLException{
//		return this.getSqlMapClientTemplate().update("updateRemarks",map);
		try { 
			this.getSqlMapClient().startTransaction(); 
			this.getSqlMapClient().startBatch();
			for(Map<String,String> m : list){
				this.getSqlMapClient().update("updateRemarks",m);
			}
			this.getSqlMapClient().executeBatch(); 
			this.getSqlMapClient().commitTransaction(); 
			return 1;
			}catch (Exception e) { 
				e.printStackTrace(); 
				return 0;
			} finally { 
					this.getSqlMapClient().endTransaction(); 
			}
	}
	/**
	 * ɾ¼
	 */
	
	public Integer delete_Trafficdevicerelate(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().delete("delete_Trafficdevicerelate",map);
	}
	
	
	/**
	 * ɾ¼
	 */
	
	
	public Integer batch_delete_Trafficdevicerelate(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().delete("batch_delete_Trafficdevicerelate",map);
	}
	
	
	/**
	 * ѯ
	 */
	
	public Integer count_Trafficdevicerelate(Map map) throws SQLException{
		return (Integer)this.getSqlMapClientTemplate().queryForObject("count_Trafficdevicerelate",map);
	}
	
	
	/**
	 * ѯб¼
	 */
	
	
	public List<Map> query_Trafficdevicerelate(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("query_Trafficdevicerelate",map);
	}
	
	/**
	 * ѯԤ豸
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public List<Map> getPlanVideoInfo(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getPlanVideoInfo",map);
	}
	
	/**
	 * roadIdsѯ·αԴ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public List<Map> getRoadAlarmSourceByRoadIds(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getRoadAlarmSourceByRoadIds",map);
	}
	public List<Map> getRoadDeviceByRoadIds(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("getRoadDeviceByRoadIds",map);
	}
	
	/**
	 * roadIdsѯ·μϢ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public List<Map> query_VideoOrderByRoadId(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("query_VideoOrderByRoadId",map);
	}
	
	/**
	 * ѯroadId
	 */
	
	public Integer count_RoadAlarmSourceByRoadIds(Map map) throws SQLException{
		return (Integer)this.getSqlMapClientTemplate().queryForObject("count_RoadAlarmSourceByRoadIds",map);
	}
	public Integer count_getRoadDeviceByRoadIds(Map map) throws SQLException{
		return (Integer)this.getSqlMapClientTemplate().queryForObject("count_getRoadDeviceByRoadIds",map);
	}
	
	/**
	 * ѯб¼
	 */
	/*
	public Map get_Trafficdevicerelate(Map map) throws SQLException{
		return (Map) this.getSqlMapClientTemplate().queryForObject("query_Trafficdevicerelate",map);
	}
	*/
	//ѯͷҳ
		public List<Map> getVideoListPage(Map map) throws SQLException{
			return this.getSqlMapClientTemplate().queryForList("getVideoListPage",map);
		}
		public Integer getVideoListPageCount(Map map) throws SQLException{
			return (Integer) this.getSqlMapClientTemplate().queryForObject("getVideoListPageCount",map);
		}
		
		//ѯ鱨岢ҳ
		public List<Map> getLedListPage(Map map) throws SQLException{
			return this.getSqlMapClientTemplate().queryForList("getLedListPage",map);
		}
		public Integer getLedListPageCount(Map map) throws SQLException{
			return (Integer) this.getSqlMapClientTemplate().queryForObject("getLedListPageCount",map);
		}
		
		//ѯյƲҳ
		public List<Map> getLightListPage(Map map) throws SQLException{
			return this.getSqlMapClientTemplate().queryForList("getLightListPage",map);
		}
		public Integer getLightListPageCount(Map map) throws SQLException{
			return (Integer) this.getSqlMapClientTemplate().queryForObject("getLightListPageCount",map);
		}
		
		//	ѯƽ̨Ϣ
		public List<Map> getPtxzsPage(Map map) throws SQLException{
			return this.getSqlMapClientTemplate().queryForList("getPtxzsPage",map);
		}
		public Integer getPtxzsPageCount(Map map) throws SQLException{
			return (Integer) this.getSqlMapClientTemplate().queryForObject("getPtxzsPageCount",map);
		}
		
		// 豸ҳ  ȫ
		public List getDeviceRelatePage(Map map) throws SQLException{
			return this.getSqlMapClientTemplate().queryForList("getDeviceRelatePage",map);			
		}
		public Integer getDeviceRelatePageCount(Map map) throws SQLException{
			return (Integer) this.getSqlMapClientTemplate().queryForObject("getDeviceRelatePageCount",map);			
		}
		
 /*============== ·ιҳ    Ϣ    /start  =================*/  
		    // 1.ͷѯ
		public List getRoadVideo(Map map) throws SQLException{
			return this.getSqlMapClientTemplate().queryForList("getRoadVideo", map);
		}
		public Integer getRoadVideoCount(Map map) throws SQLException{
			return (Integer) this.getSqlMapClientTemplate().queryForObject("getRoadVideoCount", map);
		}
			// 2.ѯ
		public List getRoadTunnel(Map map) throws SQLException{
			return this.getSqlMapClientTemplate().queryForList("getRoadTunnel", map);
		}
		public Integer getRoadTunnelCount(Map map) throws SQLException{
			return (Integer) this.getSqlMapClientTemplate().queryForObject("getRoadTunnelCount", map);
		}
			// 3.鱨ѯ
		public List getRoadLed(Map map) throws SQLException{
			return this.getSqlMapClientTemplate().queryForList("getRoadLed", map);
		}
		public Integer getRoadLedCount(Map map) throws SQLException{
			return (Integer) this.getSqlMapClientTemplate().queryForObject("getRoadLedCount", map);
		}
		//  4. ѯͨźŵ
		public List getRoadLight(Map map) throws SQLException{
			return this.getSqlMapClientTemplate().queryForList("getRoadLight", map);
		}
		public Integer getRoadLightCount(Map map) throws SQLException{
			return (Integer) this.getSqlMapClientTemplate().queryForObject("getRoadLightCount", map);
		}
		//	 5. ѯָʾ
		public List getRoadLane(Map map) throws SQLException{
			return this.getSqlMapClientTemplate().queryForList("getRoadLane", map);
		}
		public Integer getRoadLaneCount(Map map) throws SQLException{
			return (Integer) this.getSqlMapClientTemplate().queryForObject("getRoadLaneCount", map);
		}
		//	 6. ѯͨ
		public List getRoadArea(Map map) throws SQLException{
			return this.getSqlMapClientTemplate().queryForList("getRoadArea", map);
		}
		public Integer getRoadAreaCount(Map map) throws SQLException{
			return (Integer) this.getSqlMapClientTemplate().queryForObject("getRoadAreaCount", map);
		}
		//	 7. ѯⱨ 
		public List getRoadVoiLig(Map map) throws SQLException{
			return this.getSqlMapClientTemplate().queryForList("getRoadVoiLig", map);
		}
		public Integer getRoadVoiLigCount(Map map) throws SQLException{
			return (Integer) this.getSqlMapClientTemplate().queryForObject("getRoadVoiLigCount", map);
		}
		//	 8. ѯ
		public List getRoadVoice(Map map) throws SQLException{
			return this.getSqlMapClientTemplate().queryForList("getRoadVoice", map);
		}
		public Integer getRoadVoiceCount(Map map) throws SQLException{
			return (Integer) this.getSqlMapClientTemplate().queryForObject("getRoadVoiceCount", map);
		}
		//	 9. ѯ
		public List getRoadLigCon(Map map) throws SQLException{
			return this.getSqlMapClientTemplate().queryForList("getRoadLigCon", map);
		}
		public Integer getRoadLigConCount(Map map) throws SQLException{
			return (Integer) this.getSqlMapClientTemplate().queryForObject("getRoadLigConCount", map);
		}
		//	10. ѯ豸
		public List getBigScreen(Map map) throws SQLException{
			return this.getSqlMapClientTemplate().queryForList("getBigScreen", map);
		}
		public Integer getgetBigScreenCount(Map map) throws SQLException{
			return (Integer) this.getSqlMapClientTemplate().queryForObject("getgetBigScreenCount", map);
		}
/*============== ·ιҳ    Ϣ    /end  =================*/  	
		
		
		
		
//	==========================	ѯ·豸Ϣ	start
	// 1. ·ιͨźŵ
	public List get_roadLight(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("get_roadLight", map);
	}
	public Integer get_roadLightCount(Map map) throws SQLException{
		return (Integer) this.getSqlMapClientTemplate().queryForObject("get_roadLightCount", map);
	}
	
	// 2. ·ιⱨ豸
	public List get_roadVoicelight(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("get_roadVoicelight", map);
	}
	public Integer get_roadVoicelightCount(Map map) throws SQLException{
		return (Integer) this.getSqlMapClientTemplate().queryForObject("get_roadVoicelightCount", map);
	}	
	
	// 3. ·ι鱨豸
	public List get_roadLed(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("get_roadLed", map);
	}
	public Integer get_roadLedCount(Map map) throws SQLException{
		return (Integer) this.getSqlMapClientTemplate().queryForObject("get_roadLedCount", map);
	}
	
	// 4. ·ι豸
	public List get_roadLightcontrol(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("get_roadLightcontrol", map);
	}
	public Integer get_roadLightcontrolCount(Map map) throws SQLException{
		return (Integer) this.getSqlMapClientTemplate().queryForObject("get_roadLightcontrolCount", map);
	}
	
	// 5. ·ι豸
	public List get_roadVoice(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("get_roadVoice", map);
	}
	public Integer get_roadVoiceCount(Map map) throws SQLException{
		return (Integer) this.getSqlMapClientTemplate().queryForObject("get_roadVoiceCount", map);
	}

	// 6. ·ιָʾ豸
	public List get_roadlaneind(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("get_roadlaneind", map);
	}
	public Integer get_roadlaneindCount(Map map) throws SQLException{
		return (Integer) this.getSqlMapClientTemplate().queryForObject("get_roadlaneindCount", map);
	}
	
	// 7. ·ιͨ豸
	public List get_roadArea(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("get_roadArea", map);
	}
	public Integer get_roadAreaCount(Map map) throws SQLException{
		return (Integer) this.getSqlMapClientTemplate().queryForObject("get_roadAreaCount", map);
	}
	
	// 8. ·ι豸
	public List get_roadVideo(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("get_roadVideo", map);
	}
	public Integer get_roadVideoCount(Map map) throws SQLException{
		return (Integer) this.getSqlMapClientTemplate().queryForObject("get_roadVideoCount", map);
	}
	
	
	// ޸ĺͳһô˷
	public List get_roadRelate(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().queryForList("get_roadRelate", map);		
	}
	public Integer get_roadRelateCount(Map map) throws SQLException{
		return (Integer) this.getSqlMapClientTemplate().queryForObject("get_roadRelateCount",map);
	}
//	==========================	ѯ·豸Ϣ	end
	
	//  豸λΪnull
	public Integer update_TrafficdevicePositionNull(Map map) throws SQLException{
		return this.getSqlMapClientTemplate().update("update_TrafficdevicePositionNull",map);
	}
}
