package cn.im.trafficdevice.action;

 import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.constant.Constants;
import cn.base.util.CommUtils;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.im.trafficdevice.service.TrafficroadgridinfoService;

@SuppressWarnings({"all"})
@Component("trafficroadgridinfoAction")
public class TrafficroadgridinfoAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(TrafficroadgridinfoAction.class);
	
	@Autowired
	private TrafficroadgridinfoService service;
	
	/**
	 * ҳ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listTrafficroadgridinfoByPage")
	public void listTrafficroadgridinfoByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listTrafficroadgridinfoByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadgridinfoAction-listTrafficroadgridinfoByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	/*
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Trafficroadgridinfo")
	public void count_Trafficroadgridinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Trafficroadgridinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadgridinfoAction-count_Trafficroadgridinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * ѯ Trafficroadgridinfo
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Trafficroadgridinfo")
	public void query_Trafficroadgridinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Trafficroadgridinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadgridinfoAction-query_Trafficroadgridinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/*@OperateType(value = LogConstants.LOG_GET ,info ="getPreRoad")
	public void getPreRoad(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.getPreRoad(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadgridinfoAction-getPreRoad-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}*/
	
	/**
	 * ѯ һTrafficroadgridinfo
	 */
	/*
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Trafficroadgridinfo")
	public void get_Trafficroadgridinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Trafficroadgridinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadgridinfoActionquery_Trafficroadgridinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteTrafficroadgridinfo")
	public void delete_Trafficroadgridinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Trafficroadgridinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadgridinfoAction-delete_Trafficroadgridinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Trafficroadgridinfo")
	public void insert_Trafficroadgridinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("roadGridId"))){
				map.put("roadGridId",StringUtil.getUUID());
			}
			
			service.insert_Trafficroadgridinfo(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
					
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadgridinfoAction-insert_Trafficroadgridinfo()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ޸
	 */
	/*
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Trafficroadgridinfo")
	public void update_Trafficroadgridinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Trafficroadgridinfo(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Trafficroadgridinfo(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Trafficroadgridinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadgridinfoAction-update_Trafficroadgridinfo-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	 // ѯ·Ϣ
	@OperateType(value = LogConstants.LOG_GET ,info ="get_TrafficroadgridinfoById")
	public void get_TrafficroadgridinfoById(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_TrafficroadgridinfoById(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficroadgridinfoActionquery_get_TrafficroadgridinfoById-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
}
