package cn.bsystem.ptmenu.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.AbstractAttribute;

import cn.bsystem.ptmenu.model.ConfigNode;

@SuppressWarnings({"all"})
public class ConfigXml {
	private static final Logger iLog = Logger.getLogger(ConfigXml.class);
	private static List<ConfigNode> listNode = new ArrayList<ConfigNode>();
	private static List<ConfigNode> listNodes = new ArrayList<ConfigNode>();
	private static List<ConfigNode> listNodesNode = new ArrayList<ConfigNode>();
	private static ConfigXml ConfigXml  = new ConfigXml();
	private static String initInfo;
	
	public static ConfigXml getInstance() {
		return ConfigXml;
	}
	
	public List<ConfigNode> getFirstNode(){
		return listNode;
	}
	
	public String getFirstNodeValue(String name){
		for(ConfigNode node:listNode){
			if(node.getName().equals(name)){
				return node.getValue();
			}
		}
		return null;
	}
	
	public List<ConfigNode> getSecondNodes(){
		return listNodes;
	}
	//public List<CofigNode> getThirdNodesNode(){
	//	return listNodesNode;
	//}
	
	public List<ConfigNode> getThirdNodesNode(String name){
		if(listNodesNode.size()<=0){
			parseXml();
			return null;
		};
		List<ConfigNode> listItem = new ArrayList<ConfigNode>();
		for (ConfigNode node  : listNodesNode) {
			if (node.getParentId().equals(name)) {
				listItem.add(node);
			}
		}
		return listItem;
	}
	public void parseXml() {
		String m =this.getClass().getResource("/").getPath()+"siyou.xml";
		File xmlFile = new File(m);
		FileInputStream fis = null;
		try {
			fis = new FileInputStream(xmlFile);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			iLog.info("siyou.xml·ȷ" + m);
		}

		try {
			
			SAXReader saxReader = new SAXReader();
			Document doc = saxReader.read(fis);
			for (Iterator<?> iter = doc.selectNodes("//imp/scatter").iterator(); iter
					.hasNext();) {
				Element element = (Element) iter.next();
				listNode.add(parseCofigNodeAttr(element));
			}
			for (Iterator<?> iter = doc.selectNodes("//imp/scatter/node").iterator(); iter
					.hasNext();) {
				Element element = (Element) iter.next();
				listNodes.add(parseCofigNodeAttr(element));
			}
			for (Iterator<?> iter = doc.selectNodes("//imp/webrtc").iterator(); iter
					.hasNext();) {
				Element element = (Element) iter.next();
				listNodes.add(parseCofigNodeAttr(element));
			}
			for (Iterator<?> iter = doc.selectNodes("//imp/webrtc/node").iterator(); iter
					.hasNext();) {
				Element element = (Element) iter.next();
				listNodesNode.add(parseCofigNodeAttr(element));
			}
			for (Iterator<?> iter = doc.selectNodes("//imp/traffAccident").iterator(); iter
					.hasNext();) {
				Element element = (Element) iter.next();
				listNodes.add(parseCofigNodeAttr(element));
			}
			for (Iterator<?> iter = doc.selectNodes("//imp/traffAccident/node").iterator(); iter
					.hasNext();) {
				Element element = (Element) iter.next();
				listNodesNode.add(parseCofigNodeAttr(element));
			}
			
			CofigNodeAddToParent(listNodes, listNodesNode);
		} catch (DocumentException e) {
			e.printStackTrace();
			iLog.info("˵ļʽȷ." + e);
		}
	}

	public void CofigNodeAddToParent(List<ConfigNode> listChild,
			List<ConfigNode> listParent) {
		for (ConfigNode menuparent : listParent) {
			for (ConfigNode menuchild : listChild) {
				if (menuchild.getName().equals(menuparent.getParentId())) {
					menuparent.addSubConfigNode(menuchild);
				}
			}
		}
	}

	public String getParentElementName(Element element) {
		String name = null;
		for (Iterator iter1 = element.getParent().attributes().iterator(); iter1
				.hasNext();) {
			AbstractAttribute abattr = (AbstractAttribute) iter1.next();
			if (abattr.getName().equals("name")) {
				name = abattr.getValue();
				break;
			}
		}
		return name;
	}

	public ConfigNode parseCofigNodeAttr(Element element) {
		ConfigNode menu = new ConfigNode();
		String parentId = getParentElementName(element);
		if (StringUtils.isNotBlank(parentId)) {
			menu.setParentId(parentId);
		}
		for (Iterator<?> iter1 = element.attributes().iterator(); iter1.hasNext();) {
			AbstractAttribute abattr = (AbstractAttribute) iter1.next();
			if (abattr.getName().equals("name")) {
				menu.setName(abattr.getValue());
				continue;
			}
			if (abattr.getName().equals("value")) {
				menu.setValue(abattr.getValue());
				continue;
			}
			if (abattr.getName().equals("comment")) {
				menu.setComment(abattr.getValue());
				continue;
			}
			
		}
		return menu;
	}
	/**
	 * ȡsiyou.xmlϢ
	 * @return
	 */
	public String parestSiYouXML(){
		String m =this.getClass().getResource("/").getPath()+"siyou.xml";
		File xmlFile = new File(m);
		FileInputStream fis = null;
		String info = null;
		String privateInfo = null;
		try {
			fis = new FileInputStream(xmlFile);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			iLog.info("siyou.xml·ȷ" + m);
		}
			byte[] buf = new byte[1024];
			int hasRead = 0;  
			StringBuffer out = new StringBuffer(); 
			 try {
				while( (hasRead = fis.read(buf)) > 0){  
				        //ֽתΪַ  
					out.append(new String(buf,0,hasRead));  
				          
				    }
				privateInfo = out.toString();
				fis.close();
			} catch (IOException e) {
				iLog.info("configNode getPrivate error" + e);
				e.printStackTrace();
			}
			 return privateInfo; 
	}
}
