package cn.amq.peas;

import java.util.LinkedList;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import cn.amq.basis.AmqBasisEvent;
import cn.amq.basis.AmqConst;
import java.util.LinkedList;
// [֪ͨ_holder]
public class ModuleOnlineNotifyHolder extends AmqBasisEvent {
	private String fsmkmc;
	private List<ModuleOnlineNotifyPeas> list = new LinkedList<ModuleOnlineNotifyPeas>();
	public ModuleOnlineNotifyHolder() {
		msgType = AmqConst.AMQ_MSG_moduleOnlineNotify;
		fsmkmc = "";
	}
	public String getFsmkmc() {
		return fsmkmc;
	}
	public void setFsmkmc(String fsmkmc) {
		this.fsmkmc = fsmkmc;
	}
	public List<ModuleOnlineNotifyPeas> getList() {
		return list;
	}
	public void setList(List<ModuleOnlineNotifyPeas> list) {
		this.list = list;
	}
	public void writeObjToXml() {
		super.writeObjToXml();
		Element fdListElement = outMsgTypeElement.addElement("liebiao");
		for (int i = 0; i < list.size(); i++) {
			ModuleOnlineNotifyPeas info = list.get(i);
			Element element = fdListElement.addElement("jiedian");
 			this.addTextToElement(element, "gjxh", info.getGjxh());//[澯]
 			this.addTextToElement(element, "gjbh", info.getGjbh());//[澯]
 			this.addTextToElement(element, "gjsj", info.getGjsj());//[澯ʱ]
 			this.addTextToElement(element, "mkbh", info.getMkbh());//[ģ]
 			this.addTextToElement(element, "mkmc", info.getMkmc());//[ģ]
 			this.addTextToElement(element, "ip", info.getIp());//[ip]
 			this.addTextToElement(element, "zt", info.getZt());//[״̬]
 			this.addTextToElement(element, "jd", info.getJd());//[]
 			this.addTextToElement(element, "wd", info.getWd());//[γ]
 		}
	}
	public void readTextToObject(String text) throws Exception {
		super.readTextToObject(text);
		Node node = this.inDocument.selectSingleNode("/amq/fsmkmc");
		fsmkmc = this.readStringByFullPath("/amq/fsmkmc");
		List nodeList = this.inDocument.selectNodes("/amq/liebiao/jiedian");
		for (int i = 0; i < nodeList.size(); i++) {
 			ModuleOnlineNotifyPeas info = new ModuleOnlineNotifyPeas();
 			Element element = (Element) nodeList.get(i);
 			info.setGjxh(this.readStringFromElement(element, "gjxh"));//[澯]
 			info.setGjbh(this.readIntFromElement(element, "gjbh"));//[澯]
 			info.setGjsj(this.readStringFromElement(element, "gjsj"));//[澯ʱ]
 			info.setMkbh(this.readStringFromElement(element, "mkbh"));//[ģ]
 			info.setMkmc(this.readStringFromElement(element, "mkmc"));//[ģ]
 			info.setIp(this.readStringFromElement(element, "ip"));//[ip]
 			info.setZt(this.readIntFromElement(element, "zt"));//[״̬]
 			info.setJd(this.readStringFromElement(element, "jd"));//[]
 			info.setWd(this.readStringFromElement(element, "wd"));//[γ]
 			list.add(info);
 		}
	}
}
