package cn.yw.softwaremanage.action;


import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.bean.BeanHelper;
import cn.base.conf.Ywsoftware;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.softwaremanage.service.YwsoftwareinfoService;

@SuppressWarnings({"all"})
@Component("ywsoftwareinfoAction")
public class YwsoftwareinfoAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwsoftwareinfoAction.class);
	
	@Autowired
	private YwsoftwareinfoService service;
	
	/**
	 * ҳ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwsoftwareinfoByPage")
	public void listYwsoftwareinfoByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwsoftwareinfoByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwareinfoAction-listYwsoftwareinfoByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywsoftwareinfo")
	public void count_Ywsoftwareinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywsoftwareinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwareinfoAction-count_Ywsoftwareinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Ywsoftwareinfo
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywsoftwareinfo")
	public void query_Ywsoftwareinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywsoftwareinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwareinfoAction-query_Ywsoftwareinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һYwsoftwareinfo
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywsoftwareinfo")
	public void get_Ywsoftwareinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywsoftwareinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwareinfoActionquery_Ywsoftwareinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwsoftwareinfo")
	public void delete_Ywsoftwareinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywsoftwareinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwareinfoAction-delete_Ywsoftwareinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywsoftwareinfo")
	public void insert_Ywsoftwareinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String curTime = DateUtil.getDateTimeStr(new Date());
			map.put("createaccount", username);
			map.put("createtime", curTime);
			map.put("modifyaccount", username);
			map.put("modifytime", curTime);
			
			if(StringUtil.checkEmpty(map.get("softwareid"))){
				map.put("softwareid",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywsoftwareinfo(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Ywsoftwareinfo(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Ywsoftwareinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwareinfoAction-insert_Ywsoftwareinfo()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ޸
	 */
	
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywsoftwareinfo")
	public void update_Ywsoftwareinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String curTime = DateUtil.getDateTimeStr(new Date());
			
			map.put("modifyaccount", username);
			map.put("modifytime", curTime);
			
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywsoftwareinfo(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywsoftwareinfo(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywsoftwareinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwareinfoAction-update_Ywsoftwareinfo-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywsoftwareinfo")
	public void batch_delete_Ywsoftwareinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String keywords = map.get("keyword").toString();
			if(RHUtil.isNotEmpty(keywords)) {
				String[] ids = keywords.split(",");
				map.clear();
				map.put("ids", ids);
			}
			int result = service.batch_delete_Ywsoftwareinfo(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwareinfoAction-batch_delete_Ywsoftwareinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// 
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="edit_Ywmachinecpu")
	public void edit_Ywsoftwareinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String time = DateUtil.getDateTimeStr(new Date());
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			String ids = (String) map.get("ids");
			if(RHUtil.isNotEmpty(ids)) {
				String[] keys = ids.split(",");
				map.put("keys", keys);
			}				
			int result = service.edit_Ywsoftwareinfo(map);
			Struts2Utils.renderJson(Constants.SUCCESS);			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwareinfoAction-edit_Ywsoftwareinfo-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
		
		
	// ȡ˽ļȡ ӦϢ
	public void get_Ywsiyou(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {		
			Ywsoftware yw = BeanHelper.getModuleConfFactory().getYwsoftware();
			Struts2Utils.renderJson(yw.getList());			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwareinfoAction-edit_Ywsoftwareinfo-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	public void get_YwsiyouByName(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {		
			String nodeName = (String) map.get("nodeName");	
			Ywsoftware yw = BeanHelper.getModuleConfFactory().getYwsoftware();
			String comment = null;
			String value = null;
			if(RHUtil.isNotEmpty(nodeName)) {				
				if("amq".equals(nodeName)) {
					value = yw.getAmq();
					comment = yw.getAcComment();
				}else if("dac".equals(nodeName)) {
					value = yw.getDac();
					comment = yw.getDacComment();
				}else if("tomcat".equals(nodeName)) {
					value = yw.getTomcat();
					comment = yw.getTomcatComment();
				}else if("ftps".equals(nodeName)) {
					value = yw.getFtps();
					comment = yw.getFtpsComment();
				}else if("imc".equals(nodeName)) {
					value = yw.getImc();
					comment = yw.getImcComment();
				}else if("pan".equals(nodeName)) {
					value = yw.getPan();
					comment = yw.getPanComment();
				}else if("ac".equals(nodeName)) {
					value = yw.getAc();
					comment = yw.getAcComment();
				}else if("msn".equals(nodeName)) {
					value = yw.getMsn();
					comment = yw.getMsnComment();
				}else if("mdn".equals(nodeName)) {
					value = yw.getMdn();
					comment = yw.getMdnComment();
				}else if("sdb33".equals(nodeName)) {
					value = yw.getSdb33();
					comment = yw.getSdb33Comment();
				}else if("sgb".equals(nodeName)) {
					value = yw.getSgb();
					comment = yw.getSgbComment();
				}else if("adh".equals(nodeName)) {
					value = yw.getAdh();
					comment = yw.getAdhComment();
				}else if("ahk".equals(nodeName)) {
					value = yw.getAhk();
					comment = yw.getAhkComment();
				}
			}
			Map res = new HashMap();
			value = value.replace("{", "").replace("}", "");
			String[] arr = value.split(","); 
			if(RHUtil.isNotEmpty(arr)) {
				for(String str : arr) {
					String[] valArr = str.split(":");
					if(RHUtil.isNotEmpty(valArr)) {
						map.put(valArr[0], valArr[1]);
					}
				}
			}
			res.put("nodeValue", map);
			res.put("comment", comment);
			Struts2Utils.renderJson(res);			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwareinfoAction-edit_Ywsoftwareinfo-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
		
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywsoftwareinfo")
	public void exp_Ywsoftwareinfo(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ywsoftwareinfo(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "άӦϵͳϢ-"+dateTime);
			params.put("sheetName", "άӦϵͳϢ");
			params.put("header", "άӦϵͳϢ");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwsoftwareinfoAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywsoftwareinfo")
	public String imp_Ywsoftwareinfo(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("YwsoftwareinfoAction-imp_Ywsoftwareinfo-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
