package cn.yw.operationcount.arearecordcount.action;


import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
//import cn.base.excel.ExcelReader;
import cn.base.excel.ExportEngine;
import cn.base.excel.ExportExcel;
import cn.base.pdf.ExportPDF;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.operationcount.arearecordcount.service.YwcountarearecordService;
import net.sf.json.JSONObject;

@SuppressWarnings({"all"})
@Component("ywcountarearecordAction")
public class YwcountarearecordAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwcountarearecordAction.class);
	
	@Autowired
	private YwcountarearecordService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwcountarearecordByPage")
	public void listYwcountarearecordByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwcountarearecordByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountarearecordAction-listYwcountarearecordByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ¼ͳչʾ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listareaRecordCount")
	public void listareaRecordCount(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String bmbh = ptyh.getBmbh();
			if(ptyh.getSfgly()!=1){
				map.put("bmbh",bmbh);
			}
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );

			if(null!=map.get("xzbh"))
			{
				String  xzbh=map.get("xzbh").toString();
				map.put("xzbh",xzbh.split(","));
			}
			Struts2Utils.renderJson(this.service.listareaRecordCount(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountarearecordAction-listareaRecordCount-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywcountarearecord")
	public void count_Ywcountarearecord(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywcountarearecord(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountarearecordAction-count_Ywcountarearecord-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	public void count_listareaRecordCount(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String bmbh = ptyh.getBmbh();
			if(ptyh.getSfgly()!=1){
				map.put("bmbh",bmbh);
			}
			Struts2Utils.renderJson(this.service.count_listareaRecordCount(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountarearecordAction-count_listareaRecordCount-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Ywcountarearecord
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywcountarearecord")
	public void query_Ywcountarearecord(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywcountarearecord(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountarearecordAction-query_Ywcountarearecord-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һYwcountarearecord
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywcountarearecord")
	public void get_Ywcountarearecord(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywcountarearecord(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountarearecordActionquery_Ywcountarearecord-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwcountarearecord")
	public void delete_Ywcountarearecord(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywcountarearecord(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountarearecordAction-delete_Ywcountarearecord-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywcountarearecord")
	public void insert_Ywcountarearecord(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("countId"))){
				map.put("countId",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywcountarearecord(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Ywcountarearecord(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Ywcountarearecord(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountarearecordAction-insert_Ywcountarearecord()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywcountarearecord")
	public void update_Ywcountarearecord(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywcountarearecord(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywcountarearecord(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywcountarearecord(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountarearecordAction-update_Ywcountarearecord-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywcountarearecord")
	public void batch_delete_Ywcountarearecord(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Ywcountarearecord(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountarearecordAction-batch_delete_Ywcountarearecord-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywcountarearecord")
	public void exp_Ywcountarearecord(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			Map queryMap = JSONObject.fromObject(map.get("downParam"));
			// ȡûϢ
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			Integer sfgly = ptyh.getSfgly();
			if(sfgly != 1) {
				queryMap.put("bmbh", ptyh.getBmbh()); // ȡű
			}
			queryMap.put("start",0 );
			queryMap.put("limit",5000);
			Map result = service.listareaRecordCount(queryMap);	
			List<Map> sList = null;
			if(result!=null && result.get("rows")!=null){
				sList = (List<Map>) result.get("rows");
			}
			List<Map> expList = new ArrayList<Map>();
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			List<String> headerList = new ArrayList<String>();
			headerList.add("");
			headerList.add("");
			headerList.add("λ");
			headerList.add("δ");
			headerList.add("¼");
			headerList.add("¼쳣");
			headerList.add("¼");
			for(int i  =0;i<sList.size()-1;i++ ){
				Map exportMap = new HashMap();
				exportMap.put("", i+1);
				exportMap.put("", sList.get(i).get("areaname")==null?"":sList.get(i).get("areaname"));
				exportMap.put("λ", sList.get(i).get("totalnum"));
				exportMap.put("δ", sList.get(i).get("notconfignum"));
				exportMap.put("¼", sList.get(i).get("recordnormalcount"));
				exportMap.put("¼쳣", sList.get(i).get("recordabnormalcount"));
				exportMap.put("¼", sList.get(i).get("recordintactrate"));
				expList.add(exportMap);
			}
			List footerList = new ArrayList();
			if(sList.size()>0){
				
				Map json = JSONObject.fromObject(sList.get(sList.size()-1));
				footerList.add( "ܼ");
				footerList.add("ܼ");
				footerList.add( json.get("totalSum"));
				footerList.add( json.get("notconfigSum"));
				footerList.add( json.get("recordnormalSum"));
				footerList.add( json.get("recordabnormalSum"));
				footerList.add( json.get("recordintactrate"));
			}
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
			String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "¼ͳ-"+dateTime);
			params.put("sheetName", "¼ͳ");
			params.put("header", "¼ͳ(Ʊʱ䣺"+DateUtil.currentDateTime()+")");	
			new ExportExcel().exportCommExcel(params,headerList,footerList, expList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountarearecordAction-exoprtExcel-error:" +e);
			
		}
	}
	/**
	 * pdf
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="expPDF_Ywcountarearecord")
	public void expPDF_Ywcountarearecord(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			Map queryMap = JSONObject.fromObject(map.get("downParam"));
			// ȡûϢ
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			Integer sfgly = ptyh.getSfgly();
			if(sfgly != 1) {
				queryMap.put("bmbh", ptyh.getBmbh()); // ȡű
			}
			queryMap.put("start",0 );
			queryMap.put("limit",5000);
			Map result = service.listareaRecordCount(queryMap);	
			List<Map> sList = null;
			if(result!=null && result.get("rows")!=null){
				sList = (List<Map>) result.get("rows");
			}
			List<Map> expList = new ArrayList<Map>();
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhzh();
			List<String> headerList = new ArrayList<String>();
			headerList.add("");
			headerList.add("");
			headerList.add("λ");
			headerList.add("δ");
			headerList.add("¼");
			headerList.add("¼쳣");
			headerList.add("¼");
			for(int i  =0;i<sList.size()-1;i++ ){
				Map exportMap = new HashMap();
				exportMap.put("", i+1);
				exportMap.put("", sList.get(i).get("areaname")==null?"":sList.get(i).get("areaname"));
				exportMap.put("λ", sList.get(i).get("totalnum"));
				exportMap.put("δ", sList.get(i).get("notconfignum"));
				exportMap.put("¼", sList.get(i).get("recordnormalcount"));
				exportMap.put("¼쳣", sList.get(i).get("recordabnormalcount"));
				exportMap.put("¼", sList.get(i).get("recordintactrate"));
				expList.add(exportMap);
			}
			List footerList = new ArrayList();
			if(sList.size()>0){
				
				Map json = JSONObject.fromObject(sList.get(sList.size()-1));
				footerList.add( "ܼ");
				footerList.add("ܼ");
				footerList.add( json.get("totalSum"));
				footerList.add( json.get("notconfigSum"));
				footerList.add( json.get("recordnormalSum"));
				footerList.add( json.get("recordabnormalSum"));
				footerList.add( json.get("recordintactrate"));
			}
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
			String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "¼ͳ-"+dateTime);
			params.put("sheetName", "¼ͳ");
			params.put("header", "¼ͳ(Ʊʱ䣺"+DateUtil.currentDateTime()+")");	
			new ExportPDF().exportCommPDF(params,headerList,footerList, expList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwcountarearecordAction-expPDF_Ywcountarearecord-error:" +e);
			
		}
	}
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywcountarearecord")
	public String imp_Ywcountarearecord(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("YwcountarearecordAction-imp_Ywcountarearecord-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
