package cn.yw.machinemanage.service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.yw.machinemanage.dao.YwmachinememoryDao;

@Service("ywmachinememoryService")
public class YwmachinememoryService extends BaseService {
	
	private static Log log = LogFactory.getLog(YwmachinememoryService.class);
	
	@Autowired
	private YwmachinememoryDao ywmachinememoryDao;
	
	/**
	 * ¼
	 */
	
	public void insert_Ywmachinememory(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ywmachinememoryDao.insert_Ywmachinememory(map);
	}
	

	
	/**
	 * ޸ļ¼
	 */
	
	public Integer update_Ywmachinememory(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, false);
		return ywmachinememoryDao.update_Ywmachinememory(map);
	}
	
	
	/**
	 * ɾ¼
	 */
	
	public Integer delete_Ywmachinememory(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ywmachinememoryDao.delete_Ywmachinememory(map);
	}
	
	
	/**
	 * ɾ¼
	 */
	
	public Integer batch_delete_Ywmachinememory(Map map) throws SQLException{
		return ywmachinememoryDao.batch_delete_Ywmachinememory(map);
	}
	
	
	/**
	 * ѯ
	 */
	
	public Integer count_Ywmachinememory(Map map) throws SQLException{
		return ywmachinememoryDao.count_Ywmachinememory(map);
	}
	
	
	/**
	 * ѯб¼SELECT
	 */
	
	public List<Map> query_Ywmachinememory(Map map) throws SQLException{
		return ywmachinememoryDao.query_Ywmachinememory(map);
	}
	
	
	/**
	 * ѯһ
	 */
	 
	
	public Map get_Ywmachinememory(Map map) throws SQLException{
		return ywmachinememoryDao.get_Ywmachinememory(map);
	}
	
	
	/**
	 * EXCEL
	 */
	 
	/*
	public Map exportYwmachinememory(Map map) throws SQLException{
		return this.listYwmachinememoryByPage(map);
	}
	*/
	
	/**
	 * Ywmachinememory ҳ
	 */
	
	public Map listYwmachinememoryByPage(Map map) throws SQLException {
		List<Map> list = ywmachinememoryDao.query_Ywmachinememory(map);
		Integer totalCount = ywmachinememoryDao.count_Ywmachinememory(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	// 
	public Integer edit_Ywmachinememory(Map map) throws SQLException{
		return ywmachinememoryDao.edit_Ywmachinememory(map);
	}
}
