package cn.yw.nhyw.ksh_kkxx.action;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.yw.nhyw.ksh_kkxx.service.KSH_KKXXService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.FTPUtil;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;

@SuppressWarnings({"all"})
@Component("kSH_KKXXAction")
public class KSH_KKXXAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(KSH_KKXXAction.class);

	@Autowired
	private KSH_KKXXService service;

	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listKsh_kkxxByPage")
	public void listKsh_kkxxByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listKsh_kkxxByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("Ksh_kkxxAction-listKsh_kkxxByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ѯ
	 */
	/*
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ksh_kkxx")
	public void count_Ksh_kkxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ksh_kkxx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("Ksh_kkxxAction-count_Ksh_kkxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/

	/**
	 * ѯ Ksh_kkxx
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ksh_kkxx")
	public void query_Ksh_kkxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_AllKsh_kkxx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("Ksh_kkxxAction-query_Ksh_kkxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ѯ һKsh_kkxx
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ksh_kkxx")
	public void get_Ksh_kkxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ksh_kkxx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("Ksh_kkxxActionquery_Ksh_kkxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteKsh_kkxx")
	public void delete_Ksh_kkxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				String zpUrl = (String) map.get("sjzp");
				if(RHUtil.isNotEmpty(zpUrl) && !"null".equals(zpUrl)) {
					FTPUtil.deleteFileFromFtpUrl(zpUrl);
				}
				int result = service.delete_Ksh_kkxx(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("Ksh_kkxxAction-delete_Ksh_kkxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ksh_kkxx")
	public void insert_Ksh_kkxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("lkbh"))){
				map.put("lkbh",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("lkbh"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", " and lkbh='" + map.get("lkbh") + "' ");
				List ls = service.query_Ksh_kkxx(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Ksh_kkxx(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Ksh_kkxx(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("Ksh_kkxxAction-insert_Ksh_kkxx()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ksh_kkxx")
	public void update_Ksh_kkxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("xh"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", " and xh='" + map.get("xh") + "' ");
				List ls = service.query_Ksh_kkxx(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ksh_kkxx(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ksh_kkxx(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("Ksh_kkxxAction-update_Ksh_kkxx-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}

	@OperateType(value = LogConstants.LOG_UPDATE ,info ="updateJtbzJdWdByXh")
	public void updateJtbzJdWdByXh() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ksh_kkxx(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.updateJtbzJdWdByXh(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.updateJtbzJdWdByXh(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("Ksh_kkxxAction-updateJtbzJdWdByXh-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * ɾ
	 */
	/*
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ksh_kkxx")
	public void batch_delete_Ksh_kkxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Ksh_kkxx(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("Ksh_kkxxAction-batch_delete_Ksh_kkxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/

	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ksh_kkxx")
	public void exp_Ksh_kkxx(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ksh_kkxx(map);
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");
        	String dateTime=formart.format(new Date());
			Map params = new HashMap();
			params.put("fileName", "ͨ־-"+dateTime);
			params.put("sheetName", "ͨ־");
			params.put("header", "ͨ־");
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("Ksh_kkxxAction-exoprtExcel-error:" +e);

		}
	}
	*/

	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ksh_kkxx")
	public String imp_Ksh_kkxx(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {

			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("Ksh_kkxxAction-imp_Ksh_kkxx-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
