package cn.nhyw.khpj.action;


import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.nhyw.khpj.service.NhywsbcsglService;

@SuppressWarnings({"all"})
@Component("nhywsbcsglAction")
public class NhywsbcsglAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(NhywsbcsglAction.class);
	
	@Autowired
	private NhywsbcsglService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listNhywsbcsglByPage")
	public void listNhywsbcsglByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listNhywsbcsglByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywsbcsglAction-listNhywsbcsglByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Nhywsbcsgl")
	public void count_Nhywsbcsgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Nhywsbcsgl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywsbcsglAction-count_Nhywsbcsgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	
	/**
	 * ѯ Nhywsbcsgl
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Nhywsbcsgl")
	public void query_Nhywsbcsgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Nhywsbcsgl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywsbcsglAction-query_Nhywsbcsgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һNhywsbcsgl
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Nhywsbcsgl")
	public void get_Nhywsbcsgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Nhywsbcsgl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywsbcsglActionquery_Nhywsbcsgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteNhywsbcsgl")
	public void delete_Nhywsbcsgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Nhywsbcsgl(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywsbcsglAction-delete_Nhywsbcsgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Nhywsbcsgl")
	public void insert_Nhywsbcsgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("xh"))){
				map.put("xh",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Nhywsbcsgl(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Nhywsbcsgl(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Nhywsbcsgl(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywsbcsglAction-insert_Nhywsbcsgl()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Nhywsbcsgl")
	public void update_Nhywsbcsgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Nhywsbcsgl(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Nhywsbcsgl(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Nhywsbcsgl(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywsbcsglAction-update_Nhywsbcsgl-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}

	
	/**
	 * ɾ
	 */
	/*
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Nhywsbcsgl")
	public void batch_delete_Nhywsbcsgl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Nhywsbcsgl(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywsbcsglAction-batch_delete_Nhywsbcsgl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Nhywsbcsgl")
	public void exp_Nhywsbcsgl(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Nhywsbcsgl(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "豸̹-"+dateTime);
			params.put("sheetName", "豸̹");
			params.put("header", "豸̹");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywsbcsglAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Nhywsbcsgl")
	public String imp_Nhywsbcsgl(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("NhywsbcsglAction-imp_Nhywsbcsgl-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
