package cn.map.szmap.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class ConfigHelper {
	private static final Logger iLog = Logger.getLogger(ConfigHelper.class);
	private static  ConfigHelper instance = new ConfigHelper();
	
	public static ConfigHelper getInstance(){
		return instance;
	}
	
	public static void main(String[] args) throws Exception {
		String json = fileToString(
				"E:\\workspace\\npac\\config\\szmap\\cfg.json", "gb2312");
		System.out.println(json);
	}
	
	public static String getRootPath(){
		return ConfigHelper.class.getResource("/").getFile();
	}
	
	public static String getPropertyByKey(String propkey){
		try {
			Properties props = PropertiesLoaderUtils.loadAllProperties("szmap/map.properties");  
			System.out.println(props.toString());
		    return props.getProperty(propkey); 
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("ConfigHelper-getPropertyByKey error:" + e);
		}
	     return null;
	}
	
	public static String fileToString(String filePath, String encoding) {
		StringBuilder builder = new StringBuilder();
		InputStreamReader read = null;
		BufferedReader bufferedReader = null;
		try {
			File file = new File(filePath);
			if (file.isFile() && file.exists()) {
				read = new InputStreamReader(new FileInputStream(file),
						encoding);
				bufferedReader = new BufferedReader(read);
				String lineTxt = null;
				while ((lineTxt = bufferedReader.readLine()) != null) {
					builder.append(lineTxt.trim());
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("ConfigHelper-fileToString error:" + e);
		} finally {
			try {
				//Ҫð lucene-core-4.10.4
				//IOUtils.close(bufferedReader, read);
			} catch (Exception ex) {
			}
		}
		return builder.toString();
	}
	
	public boolean showLayer(String config){
		return "true".equalsIgnoreCase(getPropertyByKey(config));
	}
	
	public int getMaxSizeOfBlock(){
		return Integer.parseInt(getPropertyByKey("szmap.showLayer.maxSizeOfBlock"));
	}
	
	/*
	public static Object currSession(String beanName){
		try {
			return WebContextFactory.get().getSession().getAttribute(beanName);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("CacheRefreshPool currSession error" + e);
		}
		return null;
	}
	*/
}
