package cn.im.trafficplan.service;

 import cn.im.trafficplan.dao.TrafficplanlinkagedeviceDao;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;

@Service("trafficplanlinkagedeviceService")
public class TrafficplanlinkagedeviceService extends BaseService {
	
	private static Log log = LogFactory.getLog(TrafficplanlinkagedeviceService.class);
	
	@Autowired
	private TrafficplanlinkagedeviceDao trafficplanlinkagedeviceDao;
	
	/**
	 * ¼
	 */
	public void insert_Trafficplanlinkagedevice(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		trafficplanlinkagedeviceDao.insert_Trafficplanlinkagedevice(map);
	}

	
	/**
	 * ޸ļ¼
	 */
	public Integer update_Trafficplanlinkagedevice(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return trafficplanlinkagedeviceDao.update_Trafficplanlinkagedevice(map);
	}
	
	/**
	 * ɾ¼
	 */
	public Integer delete_Trafficplanlinkagedevice(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return trafficplanlinkagedeviceDao.delete_Trafficplanlinkagedevice(map);
	}

	/**
	 * planIDɾ¼
	 */
	public Integer delete_TrafficplanlinkagedeviceByPlanID(String str) throws SQLException{
		if(str==null || str ==""){
			throw new SQLException("ɾޣ");
		}
		return trafficplanlinkagedeviceDao.delete_TrafficplanlinkagedeviceByPlanID(str);
	}
	
	
	/**
	 * Trafficplanlinkagedevice ҳ
	 */
	public Map listTrafficplanlinkagedeviceByPage(Map map) throws SQLException {
		List<Map> list = trafficplanlinkagedeviceDao.query_Trafficplanlinkagedevice(map);
		Integer totalCount = trafficplanlinkagedeviceDao.count_Trafficplanlinkagedevice(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	/**
	 * Trafficplanlinkagedevice 
	 */
	public List<Map>  query_Trafficplanlinkagedevice(Map map) throws SQLException {
		return trafficplanlinkagedeviceDao.query_Trafficplanlinkagedevice(map);
	}
	
	public List<Map>  getlinkageDeviceOrigin(Map map) throws SQLException {
		return trafficplanlinkagedeviceDao.getlinkageDeviceOrigin(map);
	}
	
}
