package cn.base.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Vector;

@SuppressWarnings("all")
public class HttpGet {
	public final static boolean DEBUG = true;// 

	private static int BUFFER_SIZE = 8096;// С

	private Vector vDownLoad = new Vector();// URLб

	private Vector vFileList = new Vector();// غıļб

	/**
	 * 췽
	 */
	public HttpGet() {
	}

	/**
	 * б
	 */
	public void resetList() {
		vDownLoad.clear();
		vFileList.clear();
	}

	/**
	 * б
	 * 
	 * @param url String
	 * @param filename String
	 */
	public void addItem(String url, String filename) {
		vDownLoad.add(url);
		vFileList.add(filename);
	}

	/**
	 * бԴ
	 */
	public void downLoadByList() {
		String url = null;
		String filename = null;
		// б˳򱣴Դ
		for (int i = 0; i < vDownLoad.size(); i++) {
			url = (String) vDownLoad.get(i);
			filename = (String) vFileList.get(i);
			try {
				saveToFile(url, filename);
			} catch (IOException err) {
				if (DEBUG) {
					System.out.println("Դ[" + url + "]ʧ!!!");
				}
			}
		}
		if (DEBUG) {
			System.out.println("!!!");
		}
	}

	/**
	 * HTTPԴΪļ
	 * 
	 * @param destUrl String
	 * @param fileName String
	 * @throws Exception
	 */
	public void saveToFile(String destUrl, String fileName) throws IOException {
		FileOutputStream fos = null;
		BufferedInputStream bis = null;
		HttpURLConnection httpUrl = null;

		int index = fileName.lastIndexOf("\\");
		String tmpFile = fileName.substring(0, index);
		File f = new File(tmpFile);
		if (!f.exists()) {
			f.mkdirs();
		}
		URL url = null;
		byte[] buf = new byte[BUFFER_SIZE];
		int size = 0;
		// 
		url = new URL(destUrl);
		httpUrl = (HttpURLConnection) url.openConnection();
		// ָԴ
		httpUrl.connect();
		// ȡ
		bis = new BufferedInputStream(httpUrl.getInputStream());
		// ļ
		fos = new FileOutputStream(fileName);
		if (this.DEBUG)
			System.out.println("ڻȡ[" + destUrl + "]...\n䱣Ϊļ["
					+ fileName + "]");
		// ļ
		while ((size = bis.read(buf)) != -1)
			fos.write(buf, 0, size);
		fos.close();
		bis.close();
		httpUrl.disconnect();
	}

	/**
	 * ô
	 * 
	 * @param proxy String
	 * @param proxyPort String
	 */
	public void setProxyServer(String proxy, String proxyPort) {
		// ô
		System.getProperties().put("proxySet", "true");
		System.getProperties().put("proxyHost", proxy);
		System.getProperties().put("proxyPort", proxyPort);

	}

	/**
	 * ֤û
	 * 
	 * @param uid String
	 * @param pwd String
	 */
	public void setAuthenticator(String uid, String pwd) {
		// Authenticator.setDefault(new MyAuthenticator(uid, pwd));
	}

	/**
	 * (ڲ)
	 * 
	 * @param argv String[]
	 */
	public static void main(String argv[]) {

		HttpGet oInstance = new HttpGet();
		try {
			// ʼ
			long tt = System.currentTimeMillis();
			oInstance.addItem(
					"C:/webOcx/200000000100011801#00#01#20081128085927125.jpg",
					"C:/b.gif");
			long tt1 = System.currentTimeMillis();
			tt1 = tt1 - tt;
			System.out.println("һʱ" + tt1 + "second");
			oInstance.downLoadByList();
		} catch (Exception err) {
		}
	}
}
