package cn.acx;

import org.apache.log4j.Logger;

import Ice.InitializationData;
import Ice.Util;
import cn.base.conf.ModuleConfFactory;
import cn.base.conf.Node;

public class IcxDacService {
	static Logger logger = Logger.getLogger(IcxDacService.class);
	private static IcxDacService instance = null;

	public static IcxDacService getInstacne() {
		if (instance == null) {
			instance = new IcxDacService();
		}
		return instance;
	}

	public boolean init() {
		String dacIp = ModuleConfFactory.getInstance().getDac().getDacIp();
		String dacPort = ModuleConfFactory.getInstance().getDac().getPort();
		//String httpPort = ModuleProps.getInstance().getPac().getHttpPort();
		logger.info("IcxDacService: dacIp=" + dacIp+"=dbaIcePort="+dacPort);
		InitializationData initData = new InitializationData();
		Ice.Properties properties = Util.createProperties();
		for (int i = 0; i < ModuleConfFactory.getInstance().getIce().getList().size(); i++) {
			Node node = ModuleConfFactory.getInstance().getIce().getList().get(i);
			String name = node.getName();
			String value = node.getValue();
			properties.setProperty(name, value);
		}
		initData.properties = properties;
		Ice.Communicator ic = Ice.Util.initialize(initData);
		Ice.ObjectAdapter ioAdapter = ic.createObjectAdapterWithEndpoints("DacAdapter",	"default -p " + dacPort);
		/*
		Ice.Object IObject = (Ice.Object) new DacResourceServiceImpl();
		ioAdapter.add(IObject, Ice.Util.stringToIdentity("DacService"));
		ioAdapter.activate();
		*/
		return true;
	}
}
