package cn.yw.archive.companymanage.action;

 import cn.yw.archive.companymanage.service.YwarchivecompanyService;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;

@SuppressWarnings({"all"})
@Component("ywarchivecompanyAction")
public class YwarchivecompanyAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwarchivecompanyAction.class);
	
	@Autowired
	private YwarchivecompanyService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwarchivecompanyByPage")
	public void listYwarchivecompanyByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
//			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
//			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
//			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
//			map.put("start",start );
//			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwarchivecompanyByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivecompanyAction-listYwarchivecompanyByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywarchivecompany")
	public void count_Ywarchivecompany(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywarchivecompany(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivecompanyAction-count_Ywarchivecompany-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Ywarchivecompany
	 */
	/*
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywarchivecompany")
	public void query_Ywarchivecompany(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywarchivecompany(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivecompanyAction-query_Ywarchivecompany-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * ѯ һYwarchivecompany
	 */
	/*
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywarchivecompany")
	public void get_Ywarchivecompany(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywarchivecompany(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivecompanyActionquery_Ywarchivecompany-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwarchivecompany")
	public void delete_Ywarchivecompany(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywarchivecompany(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivecompanyAction-delete_Ywarchivecompany-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywarchivecompany")
	public void insert_Ywarchivecompany(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("companyid"))){
				map.put("companyid",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywarchivecompany(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Ywarchivecompany(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Ywarchivecompany(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivecompanyAction-insert_Ywarchivecompany()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywarchivecompany")
	public void update_Ywarchivecompany(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywarchivecompany(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywarchivecompany(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywarchivecompany(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivecompanyAction-update_Ywarchivecompany-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	/*
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywarchivecompany")
	public void batch_delete_Ywarchivecompany(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Ywarchivecompany(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivecompanyAction-batch_delete_Ywarchivecompany-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywarchivecompany")
	public void exp_Ywarchivecompany(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ywarchivecompany(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("companyid", m.get("companyid"));
				exportMap.put("companynum", m.get("companynum"));
				exportMap.put("companyname", m.get("companyname"));
				exportMap.put("companyabbreviation", m.get("companyabbreviation"));
				exportMap.put("companytype", m.get("companytype"));
				exportMap.put("legalpeople", m.get("legalpeople"));
				exportMap.put("establishtime", m.get("establishtime"));
				exportMap.put("companycontact", m.get("companycontact"));
				exportMap.put("contackmobilephone", m.get("contackmobilephone"));
				exportMap.put("contackphone", m.get("contackphone"));
				exportMap.put("contackaddrarea", m.get("contackaddrarea"));
				exportMap.put("contackaddress", m.get("contackaddress"));
				exportMap.put("companysynopsis", m.get("companysynopsis"));
				exportMap.put("remarks", m.get("remarks"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 14;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"companyid", "companynum", "companyname", "companyabbreviation", "companytype", "legalpeople", "establishtime", "companycontact", "contackmobilephone", "contackphone", "contackaddrarea", "contackaddress", "companysynopsis", "remarks"};
			String[] zdmc = {"˾id", "˾", "˾ȫ", "˾", "˾", "", "ʱ", "˾ϵ", "ϵֻ", "ϵ绰", "ϵַ", "ϵַַ", "˾", "ע"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "˾Ϣ-"+dateTime);
			params.put("sheetName", "˾Ϣ");
			params.put("header", "˾Ϣ");	
			new ExportEngine().exportCommData(params, cells, expList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwarchivecompanyAction-exoprtExcel-error:" +e);
			
		}
	}
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywarchivecompany")
	public String imp_Ywarchivecompany(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("YwarchivecompanyAction-imp_Ywarchivecompany-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
