package cn.bsystem.ptuserrole.dao;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import org.springframework.stereotype.Repository;

import com.ibatis.sqlmap.client.SqlMapClient;

@SuppressWarnings({ "all" })
@Repository("ptcdjsDao")
public class PtcdjsDao extends SqlMapClientDaoSupport {
	@Autowired
	private SqlMapClient sqlMapClient;

	@PostConstruct
	public void initSqlMapClient() {
		super.setSqlMapClient(sqlMapClient);
	}

	/**
	 * Ӽ¼
	 * 
	 * @param map
	 */
	public void insert_Ptcdjs(Map map) throws SQLException {
		this.getSqlMapClientTemplate().insert("insert_Ptcdjs", map);
	}

	/**
	 * Ӽ¼
	 * 
	 * @param batch
	 */
	public void batch_insert_Ptcdjs(List batch) throws SQLException {
		this.getSqlMapClientTemplate().insert("batch_insert_Ptcdjs", batch);
	}

	/**
	 * ޸ļ¼
	 * 
	 * @param map
	 * @return Integer
	 */
	public Integer update_Ptcdjs(Map map) throws SQLException {
		return this.getSqlMapClientTemplate().update("update_Ptcdjs", map);
	}

	/**
	 * ɾ¼
	 * 
	 * @param map
	 * @return Integer
	 */
	public Integer delete_Ptcdjs(Map map) throws SQLException {
		return this.getSqlMapClientTemplate().delete("delete_Ptcdjs", map);
	}

	/**
	 * ɾ¼
	 * 
	 * @param map
	 * @return Integer
	 */
	public Integer batch_delete_Ptcdjs(Map map) throws SQLException {
		return this.getSqlMapClientTemplate()
				.delete("batch_delete_Ptcdjs", map);
	}

	/**
	 * ѯ
	 * 
	 * @param map
	 * @return Integer
	 */
	public Integer count_Ptcdjs(Map map) throws SQLException {
		return (Integer) this.getSqlMapClientTemplate().queryForObject(
				"count_Ptcdjs", map);
	}

	/**
	 * ѯб¼
	 * 
	 * @param map
	 * @return List
	 */
	public List<Map> query_Ptcdjs(Map map) throws SQLException {
		return this.getSqlMapClientTemplate().queryForList("query_Ptcdjs", map);
	}

	public Map get_Ptcdjs(Map map) throws SQLException {
		return (Map) this.getSqlMapClientTemplate().queryForObject(
				"query_Ptcdjs", map);
	}

	public List<Map> getPtcdjsMemuListByJSBH(Map map) throws SQLException {
		return (List<Map>) this.getSqlMapClientTemplate().queryForList(
				"query_getPtcdjsMemuListByJSBH", map);
	}

	public Integer deletePtcdjsMenuIdByJSBH(Map map) throws SQLException {
		return this.getSqlMapClientTemplate().delete(
				"delete_ptcdjsMenuIdByJSBH", map);
	}

	public void insert_ptcdjsMenuIdByJSBH(Map map) throws SQLException {
		this.getSqlMapClientTemplate().insert("insert_ptcdjsMenuIdByJSBH", map);
	}
}
