package cn.amq.safetyhat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

import cn.amq.basis.AmqBasisEvent;
import cn.amq.basis.AmqConst;
import cn.amq.business.AmqMainPoint;
import cn.amq.peas.SafetyHatAlarmHolder;
import cn.amq.peas.SafetyHatAlarmPeas;
import cn.base.bean.BeanHelper;

/**
 * Ͱȫñ澯Ϣamq
 * 
 * */
public class AmqSafetyHatAlarmService {

static Logger logger = Logger.getLogger(AmqSafetyHatAlarmService.class);
	
	/**
	 * Ͱȫñ澯Ϣ AMQ
	 * * return msg 0AMQʧܣ1AMQͳɹ
	 * */
	public String publishSafetyHatAlarmAction(SafetyHatAlarmHolder holder) {
		String msg = "1";
		try {
			AmqMainPoint.publishJob.publishGeneralEvent(holder, AmqConst.AMQ_SUBJECT_safetyHatAlarm);//ʹǽAMQϢ
			logger.info("******AMQϢ******ȫñ澯ϢAMQ澯Ϊ"+holder.getList().size());
		}catch(Exception e) {
			e.printStackTrace();
			msg = "0";
			logger.error("******AMQϢerror******ȫñ澯ϢAMQ쳣澯Ϊ"+holder.getList().size());
		}
		return msg;
	}
	
	/**
	 * ȡ ȫñ澯ϢAMQϢ<br>
	 * ȡϢյݼSafetyHatAlarmDateServiceС
	 * return msg 0дʧܣ1дɹ
	 * 
	 */
	public void doSafetyHatAlarmAction(AmqBasisEvent amqBasisMsg) {
		SafetyHatAlarmHolder entity = (SafetyHatAlarmHolder)amqBasisMsg;
		List<SafetyHatAlarmPeas> list = entity.getList();
		try {
			logger.info("******ȡAMQϢ******ȫñ澯ϢAMQո澯¼Ϊ"+list.size());
			List list_alarm = new ArrayList();
			SafetyHatAlarmPeas info = null;
			for (SafetyHatAlarmPeas peas : list) {
				info = new SafetyHatAlarmPeas();
				info.setGjxh(peas.getGjxh());
				info.setGjbh(peas.getGjbh());
				info.setBjxxid(peas.getBjxxid());
	 			info.setBjbh(peas.getBjbh());
	 			info.setBjzwmc(peas.getBjzwmc());
	 			info.setFxsbmc(peas.getFxsbmc());
	 			info.setFxsbbh(peas.getFxsbbh());
	 			info.setFxtdbh(peas.getFxtdbh());
	 			info.setFxsbip(peas.getFxsbip());
	 			info.setBjlx(peas.getBjlx());
	 			info.setBjdj(peas.getBjdj());
	 			info.setBjtplj(peas.getBjtplj());
	 			info.setFwdsdksbjsj(peas.getFwdsdksbjsj());
	 			info.setZt(peas.getZt());
				list_alarm.add(info);
			}
			// ȫñ澯Ϣ棨͸ǰˣ
			BeanHelper.getSafetyHatAlarmDateService().setSafetyHatAlarmDataList(list_alarm);
		}catch(Exception e) {
			e.printStackTrace();
		}
	}
	
}
