package cn.base.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Format {

	public static SimpleDateFormat sfDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

	public static SimpleDateFormat sfDate = new SimpleDateFormat("yyyy-MM-dd");

	/**
	 * ַ滻 source е oldString ȫ newString
	 * 
	 * @param source
	 *            Դַ
	 * @param oldString
	 *            ϵַ
	 * @param newString
	 *            µַ
	 * @return 滻ַ
	 * @deprecated jdk1.5ԺStringѾд˷
	 */
	public static String replace(String source, String oldString, String newString) {
		StringBuffer output = new StringBuffer();

		int lengthOfSource = source.length(); // Դַ
		int lengthOfOld = oldString.length(); // ַ

		int posStart = 0; // ʼλ
		int pos; // ַλ

		while ((pos = source.indexOf(oldString, posStart)) >= 0) {
			output.append(source.substring(posStart, pos));

			output.append(newString);
			posStart = pos + lengthOfOld;
		}

		if (posStart < lengthOfSource) {
			output.append(source.substring(posStart));
		}

		return output.toString();
	}

	/**
	 * ַʽ javascriptַ 
	 * 
	 * @param str
	 *            Ҫʽַ
	 * @return ʽַ
	 */
	public static String toJavascriptVar(String str) {
		if (str == null) {
			return null;
		}

		String html = replace(str, "\\", "\\\\");

		html = replace(html, "\r", "\\r");
		html = replace(html, "\n", "\\n");
		html = replace(html, "\'", "\\\'");
		html = replace(html, "\"", "\\\"");

		return html;
	}

	/**
	 * ַʽ HTML еıֵ
	 * 
	 * @param str
	 *            Ҫʽַ
	 * @return ʽַ
	 */
	public static String toHtmlInput(String str) {
		if (str == null) {
			return null;
		}

		String html = new String(str);

		html = replace(html, "&", "&amp;");
		html = replace(html, "\"", "&quot;");
		html = replace(html, "<", "&lt;");
		html = replace(html, ">", "&gt;");

		return html;
	}

	/**
	 * ַʽ HTML  ַͨ⣬ԿոƱͻнת Խݸʽ ʺ HTML еʾ
	 * 
	 * @param str
	 *            Ҫʽַ
	 * @return ʽַ
	 */
	public static String toHtml(String str) {
		if (str == null) {
			return null;
		}

		String html = new String(str);

		html = toHtmlInput(html);
		html = replace(html, "\r\n", "<br>");
		html = replace(html, "\r", "<br>");
		html = replace(html, "\n", "<br>");
		html = replace(html, "\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
		html = replace(html, " ", "&nbsp;");

		return html;
	}

	/**
	 * ַͨʽݿϿɵַʽ
	 * 
	 * @param str
	 *            Ҫʽַ
	 * @return Ϸݿַ
	 */
	public static String toSql(String str) {
		String sql = new String(str);
		return replace(sql, "'", "''");
	}

	/**
	 * ¼ַתΪݿַ
	 * 
	 * @param str
	 *            Ҫʽַ
	 * @return ݿַ
	 */
	public static String toDbString(String str) {
		return toCharset(str, "iso-8859-1");
	}

	/**
	 * Ĭַתĳַ
	 * 
	 * @param str
	 *            String
	 * @param charSet
	 *            String
	 * @return String
	 */
	public static String toCharset(String str, String charSet) {
		if (str == null) {
			return null;
		}
		String newStr;
		try {
			newStr = new String(str.getBytes(), charSet);
		} catch (Exception e) {
			e.printStackTrace();
			newStr = str;
		}
		return newStr;
	}

	/**
	 * ݿȡַתΪҳϿʾַ
	 * 
	 * @param str
	 *            Ҫʽַ
	 * @return ҳϿʾַ
	 */

	public static String toPageString(String str) {
		return fromCharset(str, "iso-8859-1");
	}

	/**
	 * ĳַתĬַ
	 * 
	 * @param str
	 *            String
	 * @param charSet
	 *            String
	 * @return String
	 */
	public static String fromCharset(String str, String charSet) {
		if (str == null) {
			return null;
		}
		String newStr;
		try {
			newStr = new String(str.getBytes(charSet));
		} catch (Exception e) {
			e.printStackTrace();
			newStr = str;
		}
		return newStr;
	}

	// public static String toDateTimeStr(Timestamp time)
	// {
	// if (time != null)
	// {
	// return sfDateTime.format(time);
	// }
	// return null;
	// }

	// public static String toDateStr(Timestamp date)
	// {
	// if (date != null)
	// {
	// return sfDate.format(date);
	// }
	// return null;
	// }

	public static Timestamp toDateTime(String date) throws ParseException {
		if (date != null && date.length() > 0) {
			return new Timestamp(sfDateTime.parse(date).getTime());
		}
		return null;
	}

	public static Timestamp toDate(String time) throws ParseException {
		if (time != null && time.length() > 0) {
			return new Timestamp(sfDate.parse(time).getTime());
		}
		return null;
	}

	public static String escape(String src) {
		int i;
		char j;
		StringBuffer tmp = new StringBuffer();
		tmp.ensureCapacity(src.length() * 6);
		for (i = 0; i < src.length(); i++) {
			j = src.charAt(i);
			if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j))
				tmp.append(j);
			else if (j < 256) {
				tmp.append("%");
				if (j < 16)
					tmp.append("0");
				tmp.append(Integer.toString(j, 16));
			} else {
				tmp.append("%u");
				tmp.append(Integer.toString(j, 16));
			}
		}
		return tmp.toString();
	}

	public static String toDateTimeStr(Date time) {
		if (time != null) {
			return sfDateTime.format(time);
		}
		return null;
	}

	public static String toDateStr(Date date) {
		if (date != null) {
			return sfDate.format(date);
		}
		return null;
	}
	
	public static String getDateToString(Date paramDate, String format) {
		SimpleDateFormat f = new SimpleDateFormat(format);
		String time = f.format(paramDate);
		return time;
	}
}
