package cn.base.dao;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

import com.ibatis.sqlmap.client.SqlMapClient;

/**
 * BASEDAO
 * @author linhg
 * @since 2015-08-20
 */
public class BaseSqlMapDAO extends SqlMapClientDaoSupport {
	
	protected Log log = LogFactory.getLog(this.getClass());
	
	@Autowired 
    private SqlMapClient sqlMapClient;  
      
	@PostConstruct          
    public  void initSqlMapClient(){  
		super.setSqlMapClient(sqlMapClient);      
    }
	
	/*
	protected static final int PAGE_SIZE = 4;
	private static Date lastAccessDbTime = new Date();
	private SqlMapClientTemplate smcTemplate;

	public BaseSqlMapDAO() {
		smcTemplate = getSqlMapClientTemplate();
	}

	public SqlMapClientTemplate getSmcTemplate() {
		if (smcTemplate != null)
			return smcTemplate;
		Date currentDate = new Date();
		long eclapse = (currentDate.getTime() - lastAccessDbTime.getTime()) / 1000;
		if (eclapse < 10)
			return smcTemplate;
		lastAccessDbTime = currentDate;
		smcTemplate = getSqlMapClientTemplate();
		return smcTemplate;
	}
	*/

	/**
	 * ֲ-Ѵoracle/mysql
	 * @param beanId
	 * @param dto
	 * @return
	 */
	public List queryForPage(String beanId, Map m)  throws SQLException{
		int start = 0;
		int limit = 20;
		if(isNotEmpty(m.get("start"))){
			start = Integer.parseInt(m.get("start").toString());
		}
		if(isNotEmpty(m.get("limit"))){
			limit = Integer.parseInt(m.get("limit").toString());
		}
		if(isNotEmpty(m.get("sort"))){
			String order = " order by "+ m.get("sort").toString()+" "+m.get("dir").toString();
			m.put("order", order);
		}
		List list = this.sqlMapClient.queryForList(beanId, m,start,start+limit);
		return list;
	}
	/**
	 * ж϶ǷΪNotEmpty(!nullԪ>0)<br>
	 * ʵڶ¶ж:String Collection Map
	 * @param pObj 
	 * @return boolean صĲֵ
	 */
	public static boolean isNotEmpty(Object pObj) {
		if (pObj == null)
			return false;
		if (pObj == "")
			return false;
		if (pObj instanceof String) {
			if (((String) pObj).length() == 0) {
				return false;
			}
		} else if (pObj instanceof Collection) {
			if (((Collection) pObj).size() == 0) {
				return false;
			}
		} else if (pObj instanceof Map) {
			if (((Map) pObj).size() == 0) {
				return false;
			}
		}
		return true;
	}

	/**
	 * 
	 * @param beanId
	 * @param obj
	 */
	public void insert(String beanId, Object obj)  throws SQLException{
		this.getSqlMapClient().insert(beanId, obj);
	}
	
	/**
	 * ޸
	 * @param beanId
	 * @param obj
	 */
	public Integer update(String beanId, Object obj)  throws SQLException{
		return this.getSqlMapClient().update(beanId, obj);
	}
	
	/**
	 * ɾ
	 * @param beanId
	 * @param obj
	 */
	public Integer delete(String beanId, Object obj)  throws SQLException{
		return this.getSqlMapClient().delete(beanId, obj);
	}
	
	/**
	 * ѯض
	 * @param beanId
	 * @param obj
	 */
	public Object queryForObject(String beanId, Object obj) throws SQLException {
		return (Object)this.getSqlMapClient().queryForObject(beanId, obj);
	}
	
	/**
	 * ѯ
	 * @param beanId
	 * @param obj
	 */
	public List queryForList(String beanId, Object obj) throws SQLException {
		Map m = new HashMap();
		if(isNotEmpty(obj)){
			m = (Map)obj;
			if(isNotEmpty(m.get("sort"))){
				String order = " order by "+ m.get("sort")+" "+m.get("dir");
				m.put("order", order);
			}
		}
		return (List)this.getSqlMapClient().queryForList(beanId, m);
	}
	
}
