function BlockUtil(option) {
	$.extend(this, options);
}
BlockUtil.currentblock =null;
BlockUtil.getNextIdleBlock = function(index) {
	for (var i = (1 * index || 0); i < BlockCacher.blockCache.length; i++) {
		var o = BlockCacher.blockCache[i];
		if (!o.isRunning) {
				BlockUtil.currentblock = o ;
				return o;
		}
	}
	var firstblock = BlockCacher.blockCache[0];
	BlockUtil.currentblock = firstblock;
	return firstblock;
}

BlockUtil.getBlockByUuid = function(uuid) {
	for (var i = 0; i < BlockCacher.blockCache.length; i++) {
		var o = BlockCacher.blockCache[i];
		if (o.uuid == uuid){
			BlockUtil.currentblock = o ;
			return o;
		}
			
	} 
	return null;
}

BlockUtil.getBlockByIndex = function(idx) {	
	for (var i = 0; i < BlockCacher.blockCache.length; i++) {
		var o = BlockCacher.blockCache[i];
		if (o.index == idx){
			BlockUtil.currentblock = o ;
			return o;
		}
	}
	return null;
}

BlockUtil.getBlockByMonId = function(monid) {
	for (var i = 0; i < BlockCacher.blockCache.length; i++) {
		var o = BlockCacher.blockCache[i];
		if (o.monid == monid){
			BlockUtil.currentblock = o ;
			return o;
		}
	}
	return null;
}

BlockUtil.getBlockByPeerConnection = function(peerConnection) {
	for (var i = 0; i < BlockCacher.blockCache.length; i++) {
		var o = BlockCacher.blockCache[i];
		if (o.peerConnection == peerConnection){
			BlockUtil.currentblock = o ;
			return o;
		}
	}
	return null;
}



BlockUtil.addBlock = function(number) {
	var x = BlockCacher.blockCache.length;
	while (x < number) {
		var uuid = $.uniqueId();
		BlockCacher.addBlock($.videoBlock({
			uuid : uuid,
			title : "",
			cssClass : 'num-' + number,
			$baseContainer : baseContainer,
			serverConnection : serverConnection,
			index : x++,
			monid : null,
			isRunning : false,
			onRightClick : $.noop()
		}).init());
	}
}

BlockUtil.changeBlockStatus = function(index) {
	var block = this.getBlockByIndex(index);
	block.setTitle(block.getHideTitle());
	block.setRunning(true);
	// console.log(block.getContent().html());
	block.$baseContainer.find(".con-head").removeClass("current");
	block.getContent().children(".con-head").eq(0).addClass("current");
}

BlockUtil.changeDirection = function(index, direct, dom) {
	var block = this.getBlockByIndex(index);
	!!direct && block && block.changeDirection({
		"up" : 11,
		"down" : 12,
		"left" : 13,
		"right" : 14
	}[String(direct)] || "");
}

BlockUtil.stopChangeDirection = function(index, direct, dom) {
	var block = this.getBlockByIndex(index);
	block && block.stopChangeDirection();
}

BlockUtil.stopMonitor = function(index) {
	var block = this.getBlockByIndex(index);
	if (block) {
		block.stopMonitor().setRunning(false).setHideTitle("").setTitle("")
				.setFdId("").setChannelId("").setMonId(null);
		block.setPeerConnection(null);
		block.getVideoComp().src = "";
	}
	return block;
}

BlockUtil.fullScreen = function(index) {
	var block = this.getBlockByIndex(index);
	if (block) {
		var status = (document.fullscreenElement||document.webkitFullscreenElement);
		if(!status) block.getVideoComp().webkitRequestFullScreen();
		else {
			document.webkitCancelFullScreen();
		}
	}
	return block;
}

BlockUtil.changeLayout = function(number) {
	$("#screen" + BlockCacher.blockCache.length).removeClass("block-"+ BlockCacher.blockCache.length +"-selected");
	$("#screen" + number).addClass("block-"+ number +"-selected");
	
	if (BlockCacher.blockCache.length > number) {

		for (var i = number; i < BlockCacher.blockCache.length; i++) {
			baseContainer.children("div[index=" + i + "]").remove();
		}

		BlockCacher.blockCache = BlockCacher.blockCache.splice(0, number);

	} else if (BlockCacher.blockCache.length < number) {
		BlockUtil.addBlock(number);
	}
	baseContainer.children("div").removeAttr("class").attr('class',
			"num-" + number);

	return this;
}
BlockUtil.showChannelIcon = function(rs) {
	if (rs != null) {
		var tdzt = rs.tdzt;
		var recordState = rs.lxzt;
		var ldzt = rs.tdlx;
		var icon = "../../frame/assets/images/device/ballCameraColor.png";
		if (tdzt == "1" && (ldzt == "1" || ldzt == "2" || ldzt == "3" ||

		ldzt == "4")) {
			if ("1" == recordState) {
				icon = "../../frame/assets/images/device/ballCameraVCR.png";
			} else {
				icon = "../../frame/assets/images/device/ballCameraColor.png";
			}
			rs.icon = icon;
		}
		if (tdzt == "0" && (ldzt == "1" || ldzt == "2" || ldzt == "3" ||

		ldzt == "4")) {
			icon = "../../frame/assets/images/device/ballCameraGray.png";
			rs.icon = icon;
		}
		if (tdzt == "1" && (ldzt == "5" || ldzt == "6" || ldzt == "7" ||

		ldzt == "8" || ldzt == "15" || ldzt == "20")) {
			if ("1" == recordState) {
				icon = "../../frame/assets/images/device/gunCameraVCR.png";
			} else {
				icon = "../../frame/assets/images/device/gunCameraColor.png";
			}
			rs.icon = icon;
		}
		if (tdzt == "0" && (ldzt == "5" || ldzt == "6" || ldzt == "7" ||

		ldzt == "8" || ldzt == "15" || ldzt == "20")) {
			icon = "../../frame/assets/images/device/gunCameraGray.png";
			rs.icon = icon;
		}
		// GPS
		if (tdzt == "1" && (ldzt == "9" || ldzt == "10")) {
			if ("1" == recordState) {
				icon = "../../frame/assets/images/device/gpsCarVCR.png";
			} else {
				icon = "../../frame/assets/images/device/gpsCarColor.png";
			}
			rs.icon = icon;
		}
		if (tdzt == "0" && (ldzt == "9" || ldzt == "10")) {
			icon = "../../frame/assets/images/device/gpsCarGray.png";
			rs.icon = icon;
		}
		// Ա
		if (tdzt == "1" && (ldzt == "11")) {
			rs.icon = "../../frame/assets/images/device/map_policeColor.png";
			rs.mapIcon = "../../frame/assets/images/iconMap/map_police"
					+ rs.ssParam1 + ".png";
		}
		if (tdzt == "0" && (ldzt == "11")) {
			rs.icon = "../../frame/assets/images/device/map_policeGray.png";
			rs.mapIcon = "../../frame/assets/images/iconMap/map_police"
					+ rs.ssParam1 + ".png";
		}
	}
	return rs;
}

BlockUtil.showChannelIcon_xztree = function(rs) {

	// console.log(rs);
	if (rs != null) {
		var tdzt = rs.tdzt;
		var recordState = rs.lxzt;
		var tdlx = rs.tdlx;
		var icon = "icon-node-ballCameraColor";
		if (tdzt == "1" && (tdlx == "1" || tdlx == "2" || tdlx == "3" ||

		tdlx == "4")) {
			if ("1" == recordState) {
				icon = "icon-node-ballCameraVCR";
			} else {
				icon = "icon-node-ballCameraColor";
			}
			rs.icon = icon;
		}
		if (tdzt == "0" && (tdlx == "1" || tdlx == "2" || tdlx == "3" ||

		tdlx == "4")) {
			icon = "icon-node-ballCameraGray";
			rs.icon = icon;
		}
		if (tdzt == "1" && (tdlx == "5" || tdlx == "6" || tdlx == "7" ||

		tdlx == "8" || tdlx == "15" || tdlx == "20")) {
			if ("1" == recordState) {
				icon = "icon-node-gunCameraVCR";
			} else {
				icon = "icon-node-gunCameraColor";
			}
			rs.icon = icon;
		}
		if (tdzt == "0" && (tdlx == "5" || tdlx == "6" || tdlx == "7" ||

		tdlx == "8" || tdlx == "15" || tdlx == "20")) {
			icon = "icon-node-gunCameraGray";
			rs.icon = icon;
		}
		// GPS
		if (tdzt == "1" && (tdlx == "9" || tdlx == "10")) {
			if ("1" == recordState) {
				icon = "icon-node-gpsCarVCR";
			} else {
				icon = "icon-node-gpsCarColor";
			}
			rs.icon = icon;
		}
		if (tdzt == "0" && (tdlx == "9" || tdlx == "10")) {
			icon = "icon-node-gpsCarGray";
			rs.icon = icon;
		}
		// Ա
		if (tdzt == "1" && (tdlx == "11" || tdlx == "12")) {
			// rs.icon = "images/device/map_policeColor.png";
			// rs.mapIcon = "images/iconMap/map_police"+rs.ssParam1+".png";
			if ("1" == recordState) {
				icon = "icon-node-PoliceColorWork";
			} else {
				icon = "icon-node-PoliceColor";
			}
			rs.icon = icon;
		}
		if (tdzt == "0" && (tdlx == "11" || tdlx == "12")) {
			// rs.icon = "images/device/map_policeGray.png";
			// rs.mapIcon = "images/iconMap/map_police"+rs.ssParam1+".png";
			icon = "icon-node-PoliceGray";
			rs.icon = icon;
		}
	}
	return rs;

}
BlockUtil.historyGridCache = function(sbbh, tdbh, tdmc, tdzt,tdlx,lxzt) {
	var obj = {
			sbbh : sbbh,
			tdbh : tdbh,
			tdmc : tdmc,
			tdzt : tdzt,
			tdlx : tdlx,
			lxzt : lxzt,
			sbtdbh:String(sbbh +"-"+tdbh)
	};
	
	var rows = historyGrid.datagrid("getData").rows;
	
	if(rows && rows.length != 0){
		for(var i = 0;i<rows.length;i++){
			if(rows[i].sbtdbh == String(obj.sbbh +"-"+obj.tdbh) ){
				return;
			}
		}
	}
	
	historyGrid.datagrid('insertRow', {
		index : 0,
		row   : obj
	});
	
}