package cn.yw.repairmanage.action;


import java.io.File;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
//import cn.base.excel.ExcelReader;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.alarm.service.YwalarmeventinfoService;
import cn.yw.machinemanage.service.YwmachinecurrentstateService;
import cn.yw.repairmanage.service.YwrepairjobinfoService;
import cn.yw.repairmanage.service.YwrepairjoboplogService;
import cn.yw.video.videostate.service.YwvideocurrentstateService;

@SuppressWarnings({"all"})
@Component("ywrepairjobinfoAction")
public class YwrepairjobinfoAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwrepairjobinfoAction.class);
	
	@Autowired
	private YwrepairjobinfoService service;
	@Autowired
	private YwrepairjoboplogService ywrepairjoboplogService;
	@Autowired
	private YwvideocurrentstateService ywvideocurrentstateService;
	@Autowired
	private YwmachinecurrentstateService ywmachinecurrentstateService;
	@Autowired
	private YwalarmeventinfoService ywalarmeventinfoService;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwrepairjobinfoByPage")
	public void listYwrepairjobinfoByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String yhbh = ptyh.getYhbh();
			String bmbh = ptyh.getBmbh();
			String yhzh = ptyh.getYhzh();
			Integer sfgly = ptyh.getSfgly();
			String flag = map.get("flag")+"";
			if("null".equals(flag)||StringUtils.isEmpty(flag)||"my".equals(flag)){  //칤--ҵĹ
				//map.put("jobreportcompany", bmbh);
				map.put("jobreportpeople",yhzh );
				map.put("jobprocessstate", 901);
			}else if("accept".equals(flag)){  //칤--
				if(sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
					//map.put("jobacceptcompany", bmbh);
					map.put("jobacceptpeople", yhzh);
				}
				map.put("jobprocessstates", " jobprocessstate in ('901','904')");
			}else if("feedback".equals(flag)){	//칤--
				if(sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
					//map.put("feedbackcompany", bmbh);
					map.put("feedbackpeople", yhzh);
				}
				map.put("jobprocessstates", " jobprocessstate in ('902','913')"); // TODO jobprocessstates
			}else if("confirm".equals(flag)){	//칤--ȷϹ
				if(sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
					//map.put("confirmcompany", bmbh);
					map.put("confirmpeople", yhzh);
				}
				map.put("jobprocessstate", 906);
			}else if("delay".equals(flag)){		//칤--ڴ
				if(sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
					//map.put("delayforcompany", bmbh);
					map.put("delayforpeople", yhzh);
				}
				map.put("jobprocessstate", 908);
			}else if("todo".equals(flag)){ //ҳʾ
				if(sfgly == 1) { //Աѯд칤
					//901ϱ-902ά--904906ѷȷϣ908ˣ913άȷϲͨ
					String comprehensive = " jobprocessstate in ('901','902','904','906','908','913')";
					map.put("comprehensive", comprehensive);
				}else { //ѯǰûĴ칤
					String comprehensive = " (extend1='"+yhzh+"') "
							+ " and jobprocessstate in ('901','902','904','906','908','913')";
					map.put("comprehensive", comprehensive);
				}
				/*
				String comprehensive = " ((jobreportcompany='"+bmbh+"' and jobreportpeople='"+yhzh+"') "
						+" or (jobacceptcompany='"+bmbh+"' and jobacceptpeople='"+yhzh+"') "
						+" or (feedbackcompany='"+bmbh+"' and feedbackpeople='"+yhzh+"') "
						+" or (delayforcompany='"+bmbh+"' and delayforpeople='"+yhzh+"') "
						+" or (confirmcompany='"+bmbh+"' and confirmpeople='"+yhzh+"') ) "
						+ " and jobprocessstate in ('901','902','904','906',908)";
				*/
				
			}else{//ۺϲѯ
				String comprehensive = " ((jobreportcompany='"+bmbh+"' and jobreportpeople='"+yhzh+"') "
						+" or (jobacceptcompany='"+bmbh+"' and jobacceptpeople='"+yhzh+"') "
						+" or (feedbackcompany='"+bmbh+"' and feedbackpeople='"+yhzh+"') "
						+" or (delayforcompany='"+bmbh+"' and delayforpeople='"+yhzh+"') "
						+" or (confirmcompany='"+bmbh+"' and confirmpeople='"+yhzh+"') )";
				map.put("comprehensive", comprehensive);
			}	
			
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwrepairjobinfoByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrepairjobinfoAction-listYwrepairjobinfoByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywrepairjobinfo")
	public void count_Ywrepairjobinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywrepairjobinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrepairjobinfoAction-count_Ywrepairjobinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Ywrepairjobinfo
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywrepairjobinfo")
	public void query_Ywrepairjobinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywrepairjobinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrepairjobinfoAction-query_Ywrepairjobinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һYwrepairjobinfo
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywrepairjobinfo")
	public void get_Ywrepairjobinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			// ȡû
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			map.put("yhbh", ptyh.getYhbh());
			Map ywrepairjobinfoMap = this.service.get_Ywrepairjobinfo(map);
			if (ywrepairjobinfoMap != null) {
				ywrepairjobinfoMap.put("yhbh", ptyh.getYhbh());
				ywrepairjobinfoMap.put("yhzh", ptyh.getYhzh());
			}
			Struts2Utils.renderJson(ywrepairjobinfoMap);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrepairjobinfoActionquery_Ywrepairjobinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwrepairjobinfo")
	public void delete_Ywrepairjobinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywrepairjobinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrepairjobinfoAction-delete_Ywrepairjobinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywrepairjobinfo")
	public void insert_Ywrepairjobinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String username = ptyh.getYhzh();
			map.put("createaccount", username);
			map.put("modifyaccount", username);
			map.put("createtime", DateUtil.currentDateTime());
			map.put("modifytime", DateUtil.currentDateTime());
			String jobid = (String) map.get("jobid");
			if(StringUtil.checkEmpty(jobid)){
				jobid = StringUtil.getUUID();
				map.put("jobid",jobid);
			}			
			service.insert_Ywrepairjobinfo(map);
			//  ־Ӽ¼  ywrepairjoboplog
			String faultdescription = (String) map.get("faultdescription");
			insert_repairjoboplog(jobid, "901", faultdescription, ptyh);
			/*Map logMap = new HashMap();
			logMap.put("logId", StringUtil.getUUID());
			logMap.put("jobid", jobid);
			logMap.put("processstate", "901");
			logMap.put("processtime", DateUtil.currentDateTime());
			logMap.put("processcompany", ptyh.getBmbh());
			logMap.put("processpeople", username);
			logMap.put("processphone", ptyh.getSjhm());
			logMap.put("processdescription", map.get("faultdescription"));
			logMap.put("createaccount", username);
			logMap.put("modifyaccount", username);
			logMap.put("createtime", DateUtil.currentDateTime());
			logMap.put("modifytime", DateUtil.currentDateTime());
			ywrepairjoboplogService.insert_Ywrepairjoboplog(logMap);*/
			
			//  ywvideocurrentstate      ywmachinecurrentstate + ywalarmeventinfo 
			String alarmdevicetype = (String) map.get("faultdevicetype");
			String alarmdeviceid = (String) map.get("faultdeviceid");
			String channelnum = (String) map.get("channelnum");
			String repairstate = "901";
			String alarmeventid = (String) map.get("alarmeventid");
			updateState(alarmdevicetype, repairstate, alarmdeviceid, channelnum, alarmeventid);
			
			Struts2Utils.renderJson(Constants.SUCCESS);	
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrepairjobinfoAction-insert_Ywrepairjobinfo()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywrepairjobinfo")
	public void update_Ywrepairjobinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywrepairjobinfo(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywrepairjobinfo(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywrepairjobinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrepairjobinfoAction-update_Ywrepairjobinfo-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywrepairjobinfo")
	public void batch_delete_Ywrepairjobinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Ywrepairjobinfo(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrepairjobinfoAction-batch_delete_Ywrepairjobinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	// ѯûϢ
	public void getUserInfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			PtyhBean userInfo = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String yhbh = userInfo.getYhbh();
			map.put("yhbh", yhbh);
			Map user = service.getUserInfo(map);
			Struts2Utils.renderJson(user);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrepairjobinfoAction-getUserInfo-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// ȨڵĲ
	public void getReportBm(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			List list = service.getReportBm(map);			
			Struts2Utils.renderJson(list);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrepairjobinfoAction-getUserInfo-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// Ȩ
	public void getReportUser(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			List list = service.getReportUser(map);			
			Struts2Utils.renderJson(list);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrepairjobinfoAction-getReportUser-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**  
	 * ״̬     豸  豸 + ywalarmeventinfo ״̬
	 * @param alarmdevicetype     豸  1    2
	 * @param jobacceptstate	      ״̬
	 * @param deviceId			      豸
	 * @param channelnum		      ͨ
	 * @param eventId			      澯¼id
	 * @throws SQLException
	 */
	private void updateState(String alarmdevicetype, String jobacceptstate, String deviceId, 
			String channelnum, String eventId) throws SQLException{		
		
		PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");		
		if("1".equals(alarmdevicetype)) {				// 豸
			Map videoMap = new HashMap();
			videoMap.put("XGTJvideonum", deviceId);
			videoMap.put("XGTJchannelnum", channelnum);
			videoMap.put("repairstate", jobacceptstate);
			videoMap.put("modifyaccount", ptyh.getYhzh());
			videoMap.put("modifytime", DateUtil.currentDateTime());
			ywvideocurrentstateService.update_Ywvideocurrentstate(videoMap);
		}else if("2".equals(alarmdevicetype)) {			// 豸
			Map machineMap = new HashMap();
			machineMap.put("XGTJmachineid", deviceId);
			machineMap.put("repairstate", jobacceptstate);
			machineMap.put("modifyaccount", ptyh.getYhzh());
			machineMap.put("modifytime", DateUtil.currentDateTime());
			ywmachinecurrentstateService.update_Ywmachinecurrentstate(machineMap);
		}
		//  ywalarmeventinfo ״̬
		Map eventMap = new HashMap();
		eventMap.put("XGTJalarmeventid", eventId);
		eventMap.put("processstatus", jobacceptstate);	
		eventMap.put("modifyaccount", ptyh.getYhzh());
		eventMap.put("modifytime", DateUtil.currentDateTime());
		ywalarmeventinfoService.update_Ywalarmeventinfo(eventMap);
		
	}
	
	 
	/**  ݵ ־   ywrepairjoboplog
	 * @param jobid								id
	 * @param processstate						״̬
	 * @param processdescription				
	 * @param ptyh								ȡûϢ
	 * @throws SQLException
	 */
	private void insert_repairjoboplog(String jobid,String processstate, 
			String processdescription,PtyhBean ptyh) throws SQLException{	
		Map logMap = new HashMap();
		logMap.put("logId", StringUtil.getUUID());
		logMap.put("jobid", jobid);
		logMap.put("processstate", processstate);
		logMap.put("processtime", DateUtil.currentDateTime());
		logMap.put("processcompany", ptyh.getBmbh());
		logMap.put("processpeople", ptyh.getYhzh());
		logMap.put("processphone", ptyh.getSjhm());
		logMap.put("processdescription", processdescription);
		logMap.put("createaccount", ptyh.getYhzh());
		logMap.put("modifyaccount", ptyh.getYhzh());
		logMap.put("createtime", DateUtil.currentDateTime());
		logMap.put("modifytime", DateUtil.currentDateTime());
		ywrepairjoboplogService.insert_Ywrepairjoboplog(logMap);
	}

	/**
	 * -
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="updateWorkOrderInfo")
	public void updateWorkOrderInfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			PtyhBean userInfo = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String userName = userInfo.getYhzh();
			String bmbh = userInfo.getBmbh();
			String now = DateUtil.currentDateTime();
			//ǰ
			String deviceType = map.get("faultdevicetype")+"";
			System.out.println("deviceType------------"+deviceType);
			if(!("null".equals(deviceType)||StringUtils.isEmpty(deviceType))){
				/*if("1".equals(deviceType)){//
					ywvideocurrentstateService.update_Ywvideocurrentstate_WorkOrder(map);
				}else if("2".equals(deviceType)){//
					ywmachinecurrentstateService.update_Ywmachinecurrentstate_WorkOrder(map);
				}*/
				updateState(deviceType,StringUtil.transEmpty(map.get("processstatus")+""),
						StringUtil.transEmpty(map.get("XGTJfaultdeviceid")+""),
						StringUtil.transEmpty(map.get("XGTJchannelnum")+""),
						StringUtil.transEmpty(map.get("XGTJalarmeventid")+""));
			}
//			//澯
//			ywalarmeventinfoService.update_Ywalarmeventinfo(map);
			//άά޹Ϣ
			String jobprocessstate = map.get("jobprocessstate")+"";
			if(!("null".equals(jobprocessstate)||StringUtils.isEmpty(jobprocessstate))){
				if("911".equals(jobprocessstate)){
					map.put("actualfinishtime",now);
					String jobreporttime = map.get("jobreporttime")+"";
					if(!("null".equals(jobreporttime)||StringUtils.isEmpty(jobreporttime))){
						map.put("repairdays", DateUtil.subtractDay(jobreporttime, now));
					}
				} else if("904".equals(jobprocessstate)) {
					// 
					// =ǰû
					map.put("hanguppeople", userInfo.getYhbh());
					// ʱ=ǰʱ
//					map.put("hanguptime", now);
					// ˵λ=ǰûλ
					map.put("hangupcompany", userInfo.getBmbh());
				} else if("905".equals(jobprocessstate)) {
					// ȡ
					// ȡ=ǰû
					map.put("unhanguppeople", userInfo.getYhbh());
					// ȡʱ=ǰʱ
//					map.put("unhanguptime", now);
					// ȡ˵λ=ǰûλ
					map.put("unhangupcompany", userInfo.getBmbh());
				}
			}
			map.put("modifyaccount", userName);
			map.put("modifytime", now);
			map.put("XGTJchannelnum", StringUtil.transEmpty(map.get("XGTJchannelnum")+""));
			service.update_Ywrepairjobinfo(map);
			//־
			Map<String,Object> insertLog = new HashMap<String,Object>();
			insertLog.put("logId", StringUtil.getUUID());
			insertLog.put("jobid", map.get("XGTJjobid"));
			insertLog.put("processstate", map.get("processstatus"));
			insertLog.put("processtime", now);
			insertLog.put("createaccount", userName);
			insertLog.put("createtime", now);
			insertLog.put("processcompany", bmbh);
			insertLog.put("processpeople",userName);
			insertLog.put("processdescription",map.get("processdescription"));
			ywrepairjoboplogService.insert_Ywrepairjoboplog(insertLog);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrepairjobinfoAction-updateWorkOrderInfo-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="edit_confirmOrder")
	public void edit_confirmOrder(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			
			//  Ywrepairjobinfo 
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			map.put("modifyaccount", ptyh.getYhzh());
			map.put("modifytime", DateUtil.currentDateTime());
			int result = service.update_Ywrepairjobinfo(map);
			
			String repairstate = null;
			String processdescription = null;
			String flag = (String) map.get("flag");
			if("feedback".equals(flag)) {
				repairstate = (String) map.get("jobprocessstate");
				processdescription = (String) map.get("delaycause"); 
			}else if("delay".equals(flag)) {
				repairstate = (String) map.get("delayforstate");
				processdescription = (String) map.get("delayfordescription");
			}
			// µǰ״̬
			String alarmdevicetype = (String) map.get("faultdevicetype");
			String alarmdeviceid = (String) map.get("faultdeviceid");
			String channelnum = (String) map.get("channelnum");
			String alarmeventid = (String) map.get("alarmeventid");
			updateState(alarmdevicetype, repairstate, alarmdeviceid, channelnum, alarmeventid);

			// ־Ӽ¼
//			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String jobid = (String) map.get("XGTJjobid"); 
			insert_repairjoboplog(jobid, repairstate, processdescription, ptyh);
			
			Struts2Utils.renderJson(Constants.SUCCESS);

		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrepairjobinfoAction-edit_confirmOrder-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * Excel
	 */	
	@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywrepairjobinfo")
	public void exp_Ywrepairjobinfo(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			
			PtyhBean ptyh = (PtyhBean)Struts2Utils.getSession().getAttribute("userInfo");
			String yhbh = ptyh.getYhbh();
			String bmbh = ptyh.getBmbh();
			String yhzh = ptyh.getYhzh();
			Integer sfgly = ptyh.getSfgly();
			String flag = map.get("flag")+"";
			if("null".equals(flag)||StringUtils.isEmpty(flag)||"my".equals(flag)){  //칤--ҵĹ
				//map.put("jobreportcompany", bmbh);
				map.put("jobreportpeople",yhzh ); 
				map.put("jobprocessstate", 901);
			}else if("accept".equals(flag)){  //칤--
				if(sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
					//map.put("jobacceptcompany", bmbh);
					map.put("jobacceptpeople", yhzh);
				}
				map.put("jobprocessstates", " jobprocessstate in ('901','904')");
			}else if("feedback".equals(flag)){	//칤--
				if(sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
					//map.put("feedbackcompany", bmbh);
					map.put("feedbackpeople", yhzh);
				}
				map.put("jobprocessstates", " jobprocessstate in ('902','913')"); // TODO jobprocessstates
			}else if("confirm".equals(flag)){	//칤--ȷϹ
				if(sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
					//map.put("confirmcompany", bmbh);
					map.put("confirmpeople", yhzh);
				}
				map.put("jobprocessstate", 906);
			}else if("delay".equals(flag)){		//칤--ڴ
				if(sfgly != 1) { //Աѯд칤ǹԱ鿴˵Ĺ
					//map.put("delayforcompany", bmbh);
					map.put("delayforpeople", yhzh);
				}
				map.put("jobprocessstate", 908);
			}else if("todo".equals(flag)){ //ҳʾ
				if(sfgly == 1) { //Աѯд칤
					//901ϱ-902ά--904906ѷȷϣ908ˣ913άȷϲͨ
					String comprehensive = " jobprocessstate in ('901','902','904','906','908','913')";
					map.put("comprehensive", comprehensive);
				}else { //ѯǰûĴ칤
					String comprehensive = " (extend1='"+yhzh+"') "
							+ " and jobprocessstate in ('901','902','904','906','908','913')";
					map.put("comprehensive", comprehensive);
				}
			
			}else{//ۺϲѯ
				String comprehensive = " ((jobreportcompany='"+bmbh+"' and jobreportpeople='"+yhzh+"') "
						+" or (jobacceptcompany='"+bmbh+"' and jobacceptpeople='"+yhzh+"') "
						+" or (feedbackcompany='"+bmbh+"' and feedbackpeople='"+yhzh+"') "
						+" or (delayforcompany='"+bmbh+"' and delayforpeople='"+yhzh+"') "
						+" or (confirmcompany='"+bmbh+"' and confirmpeople='"+yhzh+"') )";
				map.put("comprehensive", comprehensive);
			}	
			
			map.put("start",0 );
			map.put("limit",5000);
			
			Map resMap = service.listYwrepairjobinfoByPage(map);
	
			List<Map> sList = (List<Map>) resMap.get("rows");
			
			String[] zdbm = {"jobnum", "jobprocessstatename","faultdevicetypename","faultdevicename","faultdeviceid","channelnum","faulttypename","faultdescription","jobreporttime"};                          
			String[] zdmc = {"", "״̬","豸","豸","豸","ͨ","","","ϱʱ"};
			int excelNum = zdbm.length;
			ExcelCol[] cells = new ExcelCol[excelNum];
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}			
			new ExportEngine().exportData("ѯ", cells, sList, Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwrepairjoboplogAction-exoprtExcel-error:" +e);
			
		}
	}
	
}
