package cn.bsystem.ptlog.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptlog.service.PtyhczrzService;

@SuppressWarnings({"all"})
@Component("ptyhczrzAction")
public class PtyhczrzAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(PtyhczrzAction.class);
	@Autowired
	private PtyhczrzService service;
	/**
	 * ҳ
	 */
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="listPtyhczrzByPage")
	public void listPtyhczrzByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			int limit =  start+rows ;
			map.put("start",start );
			map.put("limit",limit );
			Struts2Utils.renderJson(this.service.listPtyhczrzByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhczrzAction - listPtyhczrzByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ptyhczrz")
	public void count_Ptyhczrz(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ptyhczrz(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhczrzAction - count_Ptyhczrz() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Ptyhczrz
	 */
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Ptyhczrz")
	public void query_Ptyhczrz(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ptyhczrz(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhczrzAction - query_Ptyhczrz() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һPtyhczrz
	 */
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="get_Ptyhczrz")
	public void get_Ptyhczrz(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ptyhczrz(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhczrzAction - query_Ptyhczrz() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	//@OperateType(value = LogConstants.LOG_DELETE ,info ="deletePtyhczrz")
	public void delete_Ptyhczrz(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ptyhczrz(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhczrzAction - delete_Ptyhczrz() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	//@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ptyhczrz")
	public void insert_Ptyhczrz(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			service.insert_Ptyhczrz(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhczrzAction - listPtyhczrzByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	//@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ptyhczrz")
	public void update_Ptyhczrz(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Ptyhczrz(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhczrzAction - update_Ptyhczrz() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	//@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ptyhczrz")
	public void batch_delete_Ptyhczrz(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Ptyhczrz(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhczrzAction - batch_delete_Ptyhczrz() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * Excel
	 */
	//@OperateType(value = LogConstants.LOG_QUERY ,info ="exoprtExcel")
	public void exoprtExcel(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			map = service.exportPtyhczrz(map);
			ExcelCol[] cells = new ExcelCol[2];
			cells[0] = new ExcelCol();
			cells[0].setColKey("ֶ");
			cells[0].setColName("ֶ");
			cells[1] = new ExcelCol();
			cells[1].setColKey("ֶ");
			cells[1].setColName("ֶ");
			Map params = new HashMap();
			params.put("fileName", "");
			params.put("sheetName", "");
			params.put("header", "");	
			new ExportEngine().exportCommData(params, cells, (List<Map>)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			iLog.error("PtyhczrzAction - exoprtExcel() : error === " +e);
			e.printStackTrace();
		}
	}
}
