package cn.bsystem.ptmenu.service;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.bsystem.ptmenu.dao.MenuRoleDao;
import cn.bsystem.ptmenu.model.MenuNode;
import cn.bsystem.ptmenu.util.MenuXml;

@SuppressWarnings({"all"})
@Service("menuRoleService")
public class MenuRoleService extends BaseService {
	
	private static Log log = LogFactory.getLog(MenuRoleService.class);
	
	@Autowired
	private MenuRoleDao menuRoleDao;
	
	public List<Map> query_ptyhmenu(Map map) throws SQLException{
		return menuRoleDao.query_ptyhmenu(map);
	}
	
	public List query_allMenuFromXML(Map mp)throws Exception {
		return getAllCommonMenu();
	}
	
	/**
	 * ѯб¼SELECT
	 * 
	 * @param
	 * @return
	 */
//	public List<Map> getVpmenuroleList(Map m) throws SQLException{
//		return this.getVpmenuroleDao().getVpmenuroleList(m);
//	}
	
	public List<Map> query_PtcdjsqxByYhbh(Map m) throws SQLException{
		return menuRoleDao.query_PtcdjsqxByYhbh(m);
	}	
	
	public List<MenuNode> getAllCommonMenu() throws Exception {
		List<MenuNode> list = new ArrayList<MenuNode>();
		List <MenuNode> listFrist= MenuXml.getInstance().getFirstMenuNode();
		for(MenuNode menuItem :listFrist){
			MenuNode MenuNode = new MenuNode();
			MenuNode.setDisplay(menuItem.getDisplay());
			MenuNode.setIconCls(menuItem.getIconCls());
			MenuNode.setMenuId(menuItem.getMenuId());
			MenuNode.setRightName(menuItem.getRightName());
			MenuNode.setMenuName(menuItem.getMenuName());
			MenuNode.setParentId("-1");
			list.add(MenuNode);
			List<MenuNode> firstMenuList  = MenuXml.getInstance().geSecondMenuNodeByFirstId(menuItem.getMenuId());
			if(firstMenuList!=null && firstMenuList.size()>0){
				MenuNode.setState("closed");
			}
			for(MenuNode firstMenu :firstMenuList) {
				MenuNode firstMenuNode = new MenuNode();			
				firstMenuNode.setDisplay(firstMenu.getDisplay());
				firstMenuNode.setIconCls(firstMenu.getIconCls());
				firstMenuNode.setMenuId(firstMenu.getMenuId());
				firstMenuNode.setMenuName(firstMenu.getMenuName());
				firstMenuNode.setRightName(firstMenu.getRightName());
				firstMenuNode.setParentId(menuItem.getMenuId());
				list.add(firstMenuNode);
				List<MenuNode> secondMenuList  = MenuXml.getInstance().geThirdMenuNodeBySecond(firstMenu.getMenuId());
				if(secondMenuList!=null && secondMenuList.size()>0){
					firstMenuNode.setState("closed");
				}
				for(MenuNode secondMenu :secondMenuList){
					MenuNode secondMenuNode = new MenuNode();			
					secondMenuNode.setDisplay(secondMenu.getDisplay());
					secondMenuNode.setMenuId(secondMenu.getMenuId());
					secondMenuNode.setMenuName(secondMenu.getMenuName());
					secondMenuNode.setRightName(secondMenu.getRightName());
					if(secondMenu.getRightName()!=null && secondMenu.getRightName().length()>0){
						secondMenuNode.setIconCls("icon-lock");
					}
					else{
						secondMenuNode.setIconCls(secondMenu.getIconCls());
					}
					secondMenuNode.setParentId(firstMenu.getMenuId());
					list.add(secondMenuNode);
				}
			}
		}		
		return list;
	}
	
	
	
	
//	
//	/**
//	 * ¼
//	 * 
//	 * @param
//	 * @return
//	 */
//	public void insert_Ptyhcdjs(Map map) throws SQLException{
//		CommUtils.addParams(map, false);
//		ptyhcdjsDao.insert_Ptyhcdjs(map);
//	}
//
//	
//	/**
//	 * ޸ļ¼
//	 * 
//	 * @param
//	 * @return
//	 */
//	public Integer update_Ptyhcdjs(Map map) throws SQLException{
//		CommUtils.validateUpdateParams(map);
//		CommUtils.addParams(map, true);
//		return ptyhcdjsDao.update_Ptyhcdjs(map);
//	}
//	
//	/**
//	 * ɾ¼
//	 * 
//	 * @param
//	 * @return
//	 */
//	public Integer delete_Ptyhcdjs(Map map) throws SQLException{
//		CommUtils.validateDeleteParams(map);
//		return ptyhcdjsDao.delete_Ptyhcdjs(map);
//	}
//	
//	/**
//	 * ɾ¼
//	 * 
//	 * @param
//	 */
//	public Integer batch_delete_Ptyhcdjs(Map map) throws SQLException{
//		return ptyhcdjsDao.batch_delete_Ptyhcdjs(map);
//	}
//
//	
//	/**
//	 * ѯ
//	 * 
//	 * @param
//	 * @return
//	 */
//	public Integer count_Ptyhcdjs(Map map) throws SQLException{
//		return ptyhcdjsDao.count_Ptyhcdjs(map);
//	}
//	
//	/**
//	 * ѯб¼SELECT
//	 * 
//	 * @param
//	 * @return
//	 */
//	public List<Map> query_Ptyhcdjs(Map map) throws SQLException{
//		return ptyhcdjsDao.query_Ptyhcdjs(map);
//	}
//	
//	/**
//	 * ѯһ
//	 * 
//	 * @param
//	 * @return
//	 */
//	public Map get_Ptyhcdjs(Map map) throws SQLException{
//		return ptyhcdjsDao.get_Ptyhcdjs(map);
//	}
//	
//	/**
//	 * EXCEL
//	 * 
//	 * @param
//	 * @return
//	 */
//	public Map exportPtyhcdjs(Map map) throws SQLException{
//		return this.listPtyhcdjsByPage(map);
//	}
//	
//	/**
//	 * Ptyhcdjs ҳ
//	 * @param map
//	 * @return
//	 * @throws SQLException
//	 */
//	public Map listPtyhcdjsByPage(Map map) throws SQLException {
//		List<Map> list = ptyhcdjsDao.query_Ptyhcdjs(map);
//		Integer totalCount = ptyhcdjsDao.count_Ptyhcdjs(map);
//		map.clear();
//		map.put("total", totalCount);
//		map.put("rows", list);
//		return map;
//	}
}
