package cn.amq.peas;

import java.util.LinkedList;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import cn.amq.basis.AmqBasisEvent;
import cn.amq.basis.AmqConst;
//[Ԥõ㶨֪ͨ_holder]
public class XdPtzDefinedHolder extends AmqBasisEvent {
	private String fsmkmc;
	private List<XdPtzDefinedPeas> list = new LinkedList<XdPtzDefinedPeas>();
	public XdPtzDefinedHolder() {
		msgType = AmqConst.AMQ_MSG_xdPtzDefined;
		fsmkmc = "";
	}
	public String getFsmkmc() {
		return fsmkmc;
	}
	public void setFsmkmc(String fsmkmc) {
		this.fsmkmc = fsmkmc;
	}
	public List<XdPtzDefinedPeas> getList() {
		return list;
	}
	public void setList(List<XdPtzDefinedPeas> list) {
		this.list = list;
	}
	public void writeObjToXml() {
		super.writeObjToXml();
		Element fdListElement = outMsgTypeElement.addElement("liebiao");
		for (int i = 0; i < list.size(); i++) {
			XdPtzDefinedPeas info = list.get(i);
			Element element = fdListElement.addElement("jiedian");
 			this.addTextToElement(element, "gjxh", info.getGjxh());//[澯]
 			this.addTextToElement(element, "gjbh", info.getGjbh());//[澯]
 			this.addTextToElement(element, "gjsj", info.getGjsj());//[澯ʱ]
 			this.addTextToElement(element, "sbbh", info.getSbbh());//[豸]
 			this.addTextToElement(element, "tdbh", info.getTdbh());//[ͨ]
 			this.addTextToElement(element, "yzdbh", info.getYzdbh());//[Ԥõ]
 			this.addTextToElement(element, "zt", info.getZt());//[״̬10ӣ11޸ģ12ɾ]
 		}
	}
	public void readTextToObject(String text) throws Exception {
		super.readTextToObject(text);
		Node node = this.inDocument.selectSingleNode("/amq/fsmkmc");
		fsmkmc = this.readStringByFullPath("/amq/fsmkmc");
		List nodeList = this.inDocument.selectNodes("/amq/liebiao/jiedian");
		for (int i = 0; i < nodeList.size(); i++) {
 			XdPtzDefinedPeas info = new XdPtzDefinedPeas();
 			Element element = (Element) nodeList.get(i);
 			info.setGjxh(this.readStringFromElement(element, "gjxh"));//[澯]
 			info.setGjbh(this.readIntFromElement(element, "gjbh"));//[澯]
 			info.setGjsj(this.readStringFromElement(element, "gjsj"));//[澯ʱ]
 			info.setSbbh(this.readStringFromElement(element, "sbbh"));//[豸]
 			info.setTdbh(this.readIntFromElement(element, "tdbh"));//[ͨ]
 			info.setYzdbh(this.readIntFromElement(element, "yzdbh"));//[Ԥõ]
 			info.setZt(this.readIntFromElement(element, "zt"));//[״̬10ӣ11޸ģ12ɾ]
 			list.add(info);
 		}
	}
}
