package cn.bsystem.ptuserrole.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.service.SbtdtpqxService;

@SuppressWarnings({"all"})
@Component("sbtdtpqxAction")
public class SbtdtpqxAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(SbtdtpqxAction.class);
	
	@Autowired
	private SbtdtpqxService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listSbtdtpqxByPage")
	public void listSbtdtpqxByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ((page == 0 ? 1 : page) - 1) * rows;
			map.put("start", start);
			map.put("limit", rows);
			Struts2Utils.renderJson(this.service.listSbtdtpqxByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdtpqxAction - listSbtdtpqxByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Sbtdtpqx")
	public void count_Sbtdtpqx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Sbtdtpqx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdtpqxAction - count_Sbtdtpqx() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Sbtdtpqx
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Sbtdtpqx")
	public void query_Sbtdtpqx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Sbtdtpqx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdtpqxAction - query_Sbtdtpqx() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һSbtdtpqx
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="get_Sbtdtpqx")
	public void get_Sbtdtpqx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Sbtdtpqx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdtpqxAction - query_Sbtdtpqx() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteSbtdtpqx")
	public void delete_Sbtdtpqx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Sbtdtpqx(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdtpqxAction - delete_Sbtdtpqx() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Sbtdtpqx")
	public void insert_Sbtdtpqx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			map.put("xh", StringUtil.getUUID());
			service.insert_Sbtdtpqx(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdtpqxAction - insert_Sbtdtpqx() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Sbtdtpqx")
	public void update_Sbtdtpqx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Sbtdtpqx(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdtpqxAction - update_Sbtdtpqx() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Sbtdtpqx")
	public void batch_delete_Sbtdtpqx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Sbtdtpqx(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("SbtdtpqxAction - batch_delete_Sbtdtpqx() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="exoprtExcel")
	public void exoprtExcel(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			map = service.exportSbtdtpqx(map);
			ExcelCol[] cells = new ExcelCol[2];
			cells[0] = new ExcelCol();
			cells[0].setColKey("ֶ");
			cells[0].setColName("ֶ");
			cells[1] = new ExcelCol();
			cells[1].setColKey("ֶ");
			cells[1].setColName("ֶ");
			Map params = new HashMap();
			params.put("fileName", "");
			params.put("sheetName", "");
			params.put("header", "");	
			new ExportEngine().exportCommData(params, cells,(List<Map>)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			iLog.error("SbtdtpqxAction - exoprtExcel() : error === " +e);
			e.printStackTrace();
		}
	}
}
