package cn.base.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTP;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;


import sun.misc.BASE64Decoder;

@SuppressWarnings("all")
public class FTPUtil {
	public static Log logger = LogFactory.getLog(FTPUtil.class);

	private static FTPUtil ftpUtil = new FTPUtil();

	public static FTPUtil getInstance() {
		return ftpUtil;
	}

	public static void downLoadFile(String path, OutputStream toClient) {
		BufferedInputStream bis = null;
		InputStream is = null;
		try {
			if (path.toUpperCase().indexOf("FTP") != -1) {
				String tempUrl = path;
				tempUrl = tempUrl.replaceAll("\\\\", "/");
				URL url = new URL(tempUrl);
				is = url.openStream();
				bis = new BufferedInputStream(is);
				IOUtils.copy(bis, toClient);
				return;
			}
		} catch (Exception e) {
			logger.error("FTPͼƬ", e);
		} finally {
			try {
				if (toClient != null) {
					toClient.flush();
					toClient.close();
				}
				if (is != null) {
					is.close();
				}
				if (bis != null) {
					bis.close();
				}
			} catch (IOException e) {
				logger.error("رFTPͨ", e);
			}
		}
	}
	/**
	 * ȡftpͼƬ
	 * @param path
	 * @return
	 */
	public static InputStream getFTPPictureIS(String path) {
		InputStream is = null;
		try {
			if (path.toUpperCase().indexOf("FTP") != -1) {
				String tempUrl = path;
				tempUrl = tempUrl.replaceAll("\\\\", "/");
				URL url = new URL(tempUrl);
				is = url.openStream();
				return is;
			}
		} catch (Exception e) {
			logger.error("FTPȡͼƬ", e);
		} finally {
			try {
				if (is != null) {
					is.close();
				}
			} catch (IOException e) {
				logger.error("رFTPͨ", e);
			}
		}
		return is;
	}
	public static byte[] getFTPPictureBytes(String path) {
		byte[] bytes ;
		InputStream is = null;
		try {
			if (path.toUpperCase().indexOf("FTP") != -1) {
				String tempUrl = path;
				tempUrl = tempUrl.replaceAll("\\\\", "/");
				URL url = new URL(tempUrl);
				is = url.openStream();
				return StreamUtil.stream2Byte(is);
			}
		} catch (Exception e) {
			logger.error("FTPȡͼƬ", e);
		} finally {
			try {
				if (is != null) {
					is.close();
				}
			} catch (IOException e) {
				logger.error("رFTPͨ", e);
			}
		}
		bytes = new byte[0];
		return bytes;
	}

	//ftpͼƬϴͼƬΪbase64װString
	public static boolean uploadFile(FTPUrl ftpUrl, String path, String filename, String inputImg) throws Exception {
		boolean flag = true;
		FTPClient ftpClient = null;
		ByteArrayInputStream input = null;
		try {
			if(inputImg==null) return false;
			//base64
			BASE64Decoder decoder = new BASE64Decoder();
			byte[] b_img = decoder.decodeBuffer(inputImg);
			/*
			//ͼƬ浽--start*******************
			OutputStream out = new FileOutputStream("D:\\Program Files\\22.jpg");
			out.write(b_img);
			out.flush();
			out.close();
			//ͼƬ浽--end*******************
			*/
			input = new ByteArrayInputStream(b_img);
			ftpClient = connectServer(ftpUrl);
			//new ByteArrayInputStream
			if (ftpClient.isConnected()) {
				changeWorkingDirectory(ftpClient, path);
				flag = ftpClient.storeFile(filename, input);
				if (flag) {
					logger.info("FTPϴļɹ");
				} else {
					flag = false;
					logger.info("FTPϴļʧܣ");
				}
			}
		} catch (Exception e) {
			 flag = false;
			logger.error("FTPļϴʧܣ", e);
			throw e;
		} finally {
			input.close();
			closeConnect(ftpClient);
		}
		return flag;
	}
	/**
	 * ϴļftp
	 * @param ftpUrl
	 * @param path
	 * @param filename
	 * @param input
	 * @return
	 * @throws Exception
	 */
	public static boolean uploadFile(FTPUrl ftpUrl, String path, String filename, InputStream input) throws Exception {
		boolean flag = true;
		FTPClient ftpClient = null;
		try {
			ftpClient = connectServer(ftpUrl);
			if (ftpClient.isConnected()) {
				changeWorkingDirectory(ftpClient, path);
				flag = ftpClient.storeFile(filename, input);
				if (flag) {
					logger.info("FTPϴļɹ");
				} else {
					logger.info("FTPϴļʧܣ");
				}
			}
			input.close();
		} catch (IOException e) {
			logger.error("FTPļϴʧܣ", e);
			throw e;
		} catch (Exception e) {
			logger.error("FTPļϴʧܣ", e);
			throw e;
		} finally {
			input.close();
			closeConnect(ftpClient);
		}
		return flag;
	}

	/*
	 * õļеFTPַ
	 */
	public static String getFtpUrl(FTPUrl ftpUrl) {
		StringBuffer buffer = new StringBuffer();
		buffer.append("ftp://");
		if (ftpUrl.getFtpUser() != null && ftpUrl.getFtpUser().trim().length() > 0) {
			buffer.append(ftpUrl.getFtpUser());
			buffer.append(":");
			buffer.append(ftpUrl.getFtpUserPassword());
			buffer.append("@");
		}
		buffer.append(ftpUrl.getFtpIp());
		if (ftpUrl.getFtpPort() != null) {
			buffer.append(":");
			buffer.append(ftpUrl.getFtpPort());
		}
		buffer.append("/");
		return buffer.toString();
	}

	/**
	 * @description ɾftpϵļ
	 * @author sunw
	 * @param ftpUrl
	 * @return
	 * @throws Exception
	 */
	public static boolean deleteFileFromFtpUrl(String ftpUrl) throws Exception {
		boolean flag = false;
		if (null == ftpUrl || ftpUrl.trim().equals("")) {
			throw new Exception("ftpUrlΪ");
		}
		Map<String, String> result = getFtpInfoMapByFullPath(ftpUrl);
		String ftpUser = result.get("ftpUser");
		String ftpPassword = result.get("ftpPassword");
		String ftpIp = result.get("ftpIp");
		String ftpPort = result.get("ftpPort");
		String fileName = result.get("fileName");
		String path = result.get("path");
		FTPUrl ftp = FTPUtil.getFtpUrlObj(ftpIp, ftpPort, ftpUser, ftpPassword);
		FTPClient ftpClient = connectServer(ftp);
		if (null == ftpClient) {
			throw new Exception("ftp¼ʧ ");
		} else {
			String fullPath = (null == path || "".equals(path.trim())) ? fileName : (path + "/" + fileName);
			try {
				flag = ftpClient.deleteFile(fullPath);
			} catch (Exception e) {
				e.printStackTrace();
			}

		}
		return flag;

	}

	/**
	 * @author sunw ͨͼƬ·
	 *         ftpuser,ftppassword,ftpip,ftpport,fptϵļ·,ļrealname
	 * @param ftpUrlStr
	 * @return
	 * @throws Exception
	 */
	private static Map<String, String> getFtpInfoMapByFullPath(String ftpUrlStr) throws Exception {
		if (null == ftpUrlStr || "".equals(ftpUrlStr.trim())) {
			throw new Exception("ftpstrΪ");
		}
		ftpUrlStr = ftpUrlStr.replaceAll("\\\\", "/");
		ftpUrlStr = changeUrlCharater(ftpUrlStr);
		String array[] = ftpUrlStr.split("/");
		String[] ftpUserPasswordAndIpPort = array[2].split("@");
		String[] ftpUserAndPassword = ftpUserPasswordAndIpPort[0].split(":");
		String[] ftpIpAndPort = ftpUserPasswordAndIpPort[1].split(":");
		String ftpUser = ftpUserAndPassword[0];
		String ftpPassword = ftpUserAndPassword[1];
		String ftpIp = ftpIpAndPort[0];
		String ftpPort = ftpIpAndPort.length > 1 ? ftpIpAndPort[1] : "";
		String fileName = array[array.length - 1];// ļ
		Map<String, String> resultMap = new HashMap<String, String>();
		resultMap.put("ftpUser", ftpUser);
		resultMap.put("ftpPassword", ftpPassword);
		resultMap.put("ftpIp", ftpIp);
		resultMap.put("ftpPort", ftpPort);
		resultMap.put("fileName", fileName);
		String path = "";
		for (int i = 3; i < array.length - 1; i++) {
			if (i != array.length - 2) {
				path += array[i] + "/";
			} else {
				path += array[i];
			}
		}
		resultMap.put("path", path);
		return resultMap;
	}

	public static void main(String[] args) {
		String temp = "ftp://xingwang:xingwang@172.16.62.131:21/20130829/755001.jpg";
		try {
//			boolean flag = deleteFileFromFtpUrl(temp);
//			System.out.println(flag);
		} catch (Exception e) {
			System.out.println("ɾļʧ");
		}
		// String [] strSplit = temp.split("/");
		// for(int i = 0 ; i < strSplit.length ; i++) {
		// System.out.println(i+" = " + strSplit[i]);
		// }
	}

	public static String changeUrlCharater(String tempUrl) {
		tempUrl = tempUrl.replaceAll("%", "%25").replaceAll("#", "%23").replaceAll("\\+", "%2B").replaceAll("&", "%26");
		tempUrl = tempUrl.replaceAll("=", "%3D").replaceAll("\\?", "%3F");
		return tempUrl;
	}

	/**
	 * ӵ
	 * 
	 * 
	 */
	private static FTPClient connectServer(FTPUrl ftpUrl) {
		FTPClient ftpClient = null;
		try {
			ftpClient = new FTPClient();
			ftpClient.setControlEncoding("GBK");
			if (ftpUrl.getFtpPort() != null) {
				ftpClient.setDefaultPort(ftpUrl.getFtpPort());
			}
			ftpClient.connect(ftpUrl.getFtpIp());
			ftpClient.login(ftpUrl.getFtpUser(), ftpUrl.getFtpUserPassword());
			ftpClient.setFileType(FTP.BINARY_FILE_TYPE);
			ftpClient.enterLocalPassiveMode();
			ftpClient.setFileTransferMode(FTP.STREAM_TRANSFER_MODE);
			ftpClient.setBufferSize(10240);
			int reply = ftpClient.getReplyCode();
			if (!FTPReply.isPositiveCompletion(reply)) {
				ftpClient.disconnect();
				System.err.println("FTP server refused connection.");
				logger.info("FTP ܾӣ");
			}
		} catch (SocketException e) {
			logger.error("¼ftp " + ftpUrl.getFtpIp() + " ʧ,ӳʱ", e);
		} catch (IOException e) {
			logger.error("¼ftp " + ftpUrl.getFtpIp() + " ʧܣFTP޷򿪣", e);
		}
		return ftpClient;
	}

	/**
	 * ر
	 */
	private static void closeConnect(FTPClient ftpClient) {
		try {
			if (ftpClient != null) {
				if (ftpClient.isConnected() == true) {
					ftpClient.logout();
				}
				ftpClient.disconnect();
			}
		} catch (Exception e) {
			logger.error("رftpʧ", e);
		}
	}

	/**
	 * 뵽ĳĿ¼
	 * 
	 * @param directory
	 */
	private static void changeWorkingDirectory(FTPClient ftpClient, String directory) throws Exception {
		try {
			ftpClient.changeWorkingDirectory("/");
			String[] subPathArray = directory.split("/");
			for (String subPath : subPathArray) {
				ftpClient.makeDirectory(subPath);
				ftpClient.changeWorkingDirectory(subPath);
			}
		} catch (IOException ioe) {
			logger.error("ıftp·ʧ", ioe);
		}
	}

	/**
	 * ת[ISO-8859-1 -> GBK] ͬƽ̨Ҫͬת
	 * 
	 * @param obj
	 * @return ""
	 */
	private static String iso8859togbk(Object obj) {
		try {
			if (obj == null)
				return "";
			else
				return new String(obj.toString().getBytes("iso-8859-1"), "GBK");
		} catch (Exception e) {
			return "";
		}
	}

	public static FTPUrl getFtpUrlObj(String ftpIp, String ftpPort, String ftpUser, String ftpPassword) {
		FTPUrl ftpUrl = new FTPUrl();
		ftpUrl.setFtpIp(ftpIp);
		if (ftpPort != null) {
			ftpUrl.setFtpPort(Integer.parseInt(ftpPort));
		}
		ftpUrl.setFtpUser(ftpUser);
		ftpUrl.setFtpUserPassword(ftpPassword);
		return ftpUrl;
	}

}
