package cn.autocode;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AutoModelJAVA {
	static String rl="\r\n";
	static String baseDir=System.getProperty("user.dir")+File.separator+"";
	static String nbaseDir=System.getProperty("user.dir")+File.separator+"";
	static String srcDir=System.getProperty("user.dir")+File.separator+"/src/";
	static String nsrcDir=System.getProperty("user.dir")+File.separator+"/src/";
	static String webDir=System.getProperty("user.dir")+File.separator+"/"+AutoCreateBeanXML_M_BASE.WEBCONFIG+"/";
	static String sourceDir=System.getProperty("user.dir")+File.separator+"/source/";
	static String nwebDir=System.getProperty("user.dir")+File.separator+"/"+AutoCreateBeanXML_M_BASE.WEBCONFIG+"/";
	static String PROJECT = "";
	static String O_PROJECT = "";
	public static void initMode(String basePackage,String secondPackage,String model,String project,String localPROJECT) throws IOException {
		String basemodepack=basePackage+"."+secondPackage;
        String[] wordArray = basemodepack.split("\\.");
		O_PROJECT = localPROJECT;
		PROJECT = project;
		nbaseDir = nbaseDir.replaceAll(localPROJECT, project);
		nsrcDir = nsrcDir.replaceAll(localPROJECT, project);
		nwebDir = nwebDir.replaceAll(localPROJECT, project);
		String subDir=nsrcDir;
		for(int i=0;i<wordArray.length;i++){
			subDir=subDir+File.separator+wordArray[i];
			makeDirs(subDir);
		}
		String fullFileName = subDir+File.separator+getFirstUppCaseName(secondPackage)+"."+"java";
		String content = "";
		content += "package " + basemodepack+";"+rl;
		content+="public class "+getFirstUppCaseName(secondPackage)+"{"+rl;
		content+= "}"+rl;
		//createFileUTF8(fullFileName,content);	
	}	
	
	public void createClassJavaBean(String basePackage,String secondPackage,String model,String tablename,List fieldlist,List typelist,List fieldSizeList,List fieldChineseList,String chinaName){
		String fullPackage= basePackage+"."+secondPackage+"."+model.toLowerCase()+".model";
        String[] wordArray = fullPackage.split("\\.");
		String subDir=nsrcDir;
		for(int i=0;i<wordArray.length;i++){
			subDir=subDir+File.separator+wordArray[i];
			makeDirs(subDir);
		}
		String fullFileName=subDir+File.separator+getFirstUppCaseName(tablename)+"Beanjava";
		String content="package " + fullPackage+";"+rl+rl;
		String getSetContent = "";
		content+="import cn.base.bean.BaseBean;"+rl;
		//content+="import "+basePackage+"."+secondPackage+"."+getFirstUppCaseName(secondPackage)+";"+rl;
		content+="//["+chinaName+"]"+rl+rl;
		content+="public class "+getFirstUppCaseName(tablename)+"Bean extends BaseBean implements java.io.Serializable {"+rl;
		for(int i=0;i<fieldlist.size();i++){
			//System.out.println(fieldlist.get(i)+"------------");
			String field = ((String) fieldlist.get(i));
			String fieldtype = (String)typelist.get(i);
			String fieldSize = (String)fieldSizeList.get(i);
			String fieldChinese = (String)fieldChineseList.get(i);
			int fieldSizeI = Integer.parseInt(fieldSize);
			if(fieldtype.toLowerCase().indexOf("bigint")!=-1||((fieldtype.toLowerCase().indexOf("decimal")!=-1||fieldtype.toLowerCase().indexOf("number")!=-1)&&fieldSizeI>13)){
				fieldtype = "long";
			}else if(fieldtype.toLowerCase().indexOf("decimal")!=-1||fieldtype.toLowerCase().indexOf("number")!=-1||fieldtype.toLowerCase().indexOf("int")!=-1||fieldtype.toLowerCase().indexOf("Integer")!=-1){
				fieldtype = "int";
			}else if(fieldtype.toLowerCase().indexOf("longblob")!=-1||fieldtype.toLowerCase().indexOf("blob")!=-1||fieldtype.toLowerCase().indexOf("clob")!=-1){
				fieldtype = "byte[]";
			}else{
				fieldtype = "String";
			}
			content+="	private "+fieldtype+" "+field+";//["+fieldChinese+"]"+rl;
			getSetContent+="	public void set"+getFirstUppCaseName(field)+"("+fieldtype+" "+ field+"){"+rl+
					"		this."+field+" = "+ field+";"+rl+
					"	}"+rl+
					"	public "+fieldtype+" get"+getFirstUppCaseName(field)+"(){"+rl+
					"		return "+field+";"+rl+
					"	}"+rl;	
		}
		content+=getSetContent+"}";
		createFileGBK(fullFileName,content);	
	}
	
	public void createDAOJava(String basePackage,String secondPackage,String model,String tablename,List fieldlist,List typelist)throws IOException {
		//tablename = tablename.toLowerCase();
		String tablenameL = tablename.toLowerCase();
		String tablenameS = getFirstLowerCaseName(tablename);
		String tablenameF = getFirstUppCaseName(tablename);
		String fullPackage= basePackage+"."+secondPackage+"."+model.toLowerCase()+".dao";
        String[] wordArray = fullPackage.split("\\.");
		String subDir=nsrcDir;
		for(int i=0;i<wordArray.length;i++){
			subDir=subDir+File.separator+wordArray[i];
			makeDirs(subDir);
		}
		String fullFileName=subDir+File.separator+getFirstUppCaseName(tablename)+"Daojava";
		String content=""+rl;
		String demopath = nsrcDir+"/cn/autocode/";
		String demofile = "DemoDaojava";
		FileInputStream fis = new FileInputStream(demopath + demofile); //ļ
		InputStreamReader isr = new InputStreamReader(fis,"GBK"); //ָȡΪUTF-8ʽ
		BufferedReader br = new BufferedReader(isr);
		StringBuffer sb = new StringBuffer();
		String line = br.readLine();
		while (line != null) {
			if (line != null) {
				if (line.indexOf("package") != -1) {
					//line = line.replace("auto", secondPackage);
					//line = line.replace("demo", model.toLowerCase());
					line = "package cn.im."+model.toLowerCase()+".dao;"+"\r\n";
					line += "import cn.base.dao.BaseSqlMapDAO;";
				}
				if (line.indexOf("smallDEMO") != -1) {
					line = line.replace("smallDEMO", (tablename).toLowerCase());
				}
				if (line.indexOf("DemoDao") != -1&&line.indexOf("class")!=-1) {
					line = line.replace("Demo", getFirstUppCaseName(tablename));
				}
				if (line.indexOf("Demo") != -1) {
					line = line.replace("Demo", tablenameF);
				}
				line = line.replace("demo", tablenameF);
			}
			sb.append(line + "\r\n");
			line = br.readLine();
		}
		br.close();
		isr.close();
		fis.close();
		File file=new File(fullFileName);    
		if(!file.exists()){    
			createFileGBK(fullFileName,sb.toString());	
		}
	}
	
	public void createServiceJava(String basePackage,String secondPackage,String model,String tablename,List fieldlist,List typelist,List pkilist,String chineaseName)	throws IOException {
		String RH_DEMO_PKI = "";
		String PKI_S = "";
		if(pkilist.size()<2&&pkilist.size()>0){
			RH_DEMO_PKI = (String)pkilist.get(0);
			if(RH_DEMO_PKI.equals("autoincreaseid")||RH_DEMO_PKI.equals("zzxh")){
				PKI_S = "";
			}else{
				PKI_S +="			if(StringUtil.isEmpty(obj.get"+getFirstUppCaseName(RH_DEMO_PKI)+"())){"+rl;
				PKI_S += "				obj.set"+getFirstUppCaseName(RH_DEMO_PKI)+"(StringUtil.getUUID());"+rl;
				PKI_S += "			}";
			}
		}
		
		boolean IcreateAccount = false;
		boolean IcreateTime = false;
		boolean ImodifyAccount = false;
		boolean ImodifyTime = false;
		for(int i=0;i<fieldlist.size();i++){
			String field = (String)fieldlist.get(i);
			if(field.equals("createAccount")){
				IcreateAccount = true;
			}
			if(field.equals("createTime")){
				IcreateTime = true;
			}
			if(field.equals("modifyAccount")){
				ImodifyAccount = true;
			}
			if(field.equals("modifyTime")){
				ImodifyTime = true;
			}
		}
		String modelL = model.toLowerCase();
		String modelS = getFirstLowerCaseName(model);
		String modelF = getFirstUppCaseName(model);
		String tablenameL = tablename.toLowerCase();
		String tablenameS = getFirstLowerCaseName(tablename);
		String tablenameF = getFirstUppCaseName(tablename);
		String fullPackage= basePackage+"."+secondPackage+"."+model.toLowerCase()+".service";
        String[] wordArray = fullPackage.split("\\.");
		String subDir=nsrcDir;
		for(int i=0;i<wordArray.length;i++){
			subDir=subDir+File.separator+wordArray[i];
			makeDirs(subDir);
		}
		String fullFileName=subDir+File.separator+tablenameF+"Servicejava";
		String content=""+rl;
		//String demopath = sourceDir+"/base/";
		String demopath = nsrcDir+"/cn/autocode/";
		String demofile = "DemoServicejava";
		FileInputStream fis = new FileInputStream(demopath + demofile); //ļ
		InputStreamReader isr = new InputStreamReader(fis,"GBK"); //ָȡΪUTF-8ʽ
		BufferedReader br = new BufferedReader(isr);
		StringBuffer sb = new StringBuffer();
		String line = br.readLine();
		while (line != null) {
			if (line != null) {
				if (line.indexOf("package") != -1) {
					line = "package cn.im."+model.toLowerCase()+".service;"+rl+rl;
					line += " import cn.im."+model.toLowerCase()+".dao."+tablenameF+"Dao;";
					//line = line.replace("auto", secondPackage);
					//line = line.replace("demo", model.toLowerCase());
					//line = line +rl+rl+ "import "+basePackage+"."+secondPackage+"."+getFirstUppCaseName(secondPackage)+"Service;";

				}
				if(line.indexOf("extend")!=-1&&line.indexOf("BaseDemoService")!=-1){
					line = line.replace("BaseDemoService", getFirstUppCaseName(secondPackage)+"Service");
					line = line.replace("DemoService", tablenameF+"Service");
				}
				if (line.indexOf("//obj.setCreateAccount(model.getUserName())") != -1&&IcreateAccount) {
					line = "			obj.setCreateAccount(model.getUserName());";
				}
				if (line.indexOf("//obj.setCreateTime(nowtime)") != -1&&IcreateTime) {
					line = "			obj.setCreateTime(nowtime);";
				}
				if (line.indexOf("//obj.setModifyAccount(model.getUserName())") != -1&&ImodifyAccount) {
					line = "			obj.setModifyAccount(model.getUserName());";
				}
				if (line.indexOf("//obj.setModifyTime(nowtime)") != -1&&ImodifyTime) {
					line = "			obj.setModifyTime(nowtime);";
				}
				if (line.indexOf("//PKI") != -1) {
					line = PKI_S;
				}
				if (line.indexOf("") != -1) {
					line = line.replace("", chineaseName);
				}				
				if (line.indexOf("smallDEMO") != -1) {
					line = line.replace("smallDEMO", tablenameF.toLowerCase());
				}
				if (line.indexOf("Demo") != -1) {
					line = line.replace("Demo", tablenameF);
				}
				line = line.replace("demo", tablenameF);
			}
			sb.append(line + "\r\n");
			line = br.readLine();
		}
		br.close();
		isr.close();
		fis.close();
		File file=new File(fullFileName);    
		if(!file.exists()){    
			createFileGBK(fullFileName,sb.toString());	
		}
	}
	
	
	public void createActionJava(String basePackage,String secondPackage,String model,String tablename,List fieldlist,List typelist,List pkilist,String chineaseName)	throws IOException {
		String RH_DEMO_PKI = "";
		String PKI_S = "";
		if(pkilist.size()<2&&pkilist.size()>0){
			RH_DEMO_PKI = (String)pkilist.get(0);
			if(RH_DEMO_PKI.equals("autoincreaseid")||RH_DEMO_PKI.equals("zzxh")){
				PKI_S = "";
			}else{
				PKI_S +="			if(StringUtil.checkEmpty(map.get(\""+(RH_DEMO_PKI)+"\"))){"+rl;
				PKI_S += "				map.put(\""+(RH_DEMO_PKI)+"\",StringUtil.getUUID());"+rl;
				PKI_S += "			}";
			}
		}
		
		boolean IcreateAccount = false;
		boolean IcreateTime = false;
		boolean ImodifyAccount = false;
		boolean ImodifyTime = false;
		for(int i=0;i<fieldlist.size();i++){
			String field = (String)fieldlist.get(i);
			if(field.equals("createAccount")){
				IcreateAccount = true;
			}
			if(field.equals("createTime")){
				IcreateTime = true;
			}
			if(field.equals("modifyAccount")){
				ImodifyAccount = true;
			}
			if(field.equals("modifyTime")){
				ImodifyTime = true;
			}
		}
		String modelL = model.toLowerCase();
		String modelS = getFirstLowerCaseName(model);
		String modelF = getFirstUppCaseName(model);
		String tablenameL = tablename.toLowerCase();
		String tablenameS = getFirstLowerCaseName(tablename);
		String tablenameF = getFirstUppCaseName(tablename);
		String fullPackage= basePackage+"."+secondPackage+"."+model.toLowerCase()+".action";
        String[] wordArray = fullPackage.split("\\.");
		String subDir=nsrcDir;
		for(int i=0;i<wordArray.length;i++){
			subDir=subDir+File.separator+wordArray[i];
			makeDirs(subDir);
		}
		String fullFileName=subDir+File.separator+tablenameF+"Actionjava";
		String content=""+rl;
		//String demopath = sourceDir+"/base/";
		String demopath = nsrcDir+"/cn/autocode/";
		String demofile = "DemoActionjava";
		FileInputStream fis = new FileInputStream(demopath + demofile); //ļ
		InputStreamReader isr = new InputStreamReader(fis,"GBK"); //ָȡΪUTF-8ʽ
		BufferedReader br = new BufferedReader(isr);
		StringBuffer sb = new StringBuffer();
		String line = br.readLine();
		while (line != null) {
			if (line != null) {
				if (line.indexOf("package") != -1) {
					line = "package cn.im."+model.toLowerCase()+".action;"+rl+rl;
					line += " import cn.im."+model.toLowerCase()+".service."+tablenameF+"Service;";
					//line = line.replace("auto", secondPackage);
					//line = line.replace("demo", model.toLowerCase());
					//line = line +rl+rl+ "import "+basePackage+"."+secondPackage+"."+getFirstUppCaseName(secondPackage)+"Service;";

				}
				if(line.indexOf("extend")!=-1&&line.indexOf("BaseDemoService")!=-1){
					line = line.replace("BaseDemoService", getFirstUppCaseName(secondPackage)+"Service");
					line = line.replace("DemoService", tablenameF+"Service");
				}
				if (line.indexOf("//obj.setCreateAccount(model.getUserName())") != -1&&IcreateAccount) {
					line = "			obj.setCreateAccount(model.getUserName());";
				}
				if (line.indexOf("//obj.setCreateTime(nowtime)") != -1&&IcreateTime) {
					line = "			obj.setCreateTime(nowtime);";
				}
				if (line.indexOf("//obj.setModifyAccount(model.getUserName())") != -1&&ImodifyAccount) {
					line = "			obj.setModifyAccount(model.getUserName());";
				}
				if (line.indexOf("//obj.setModifyTime(nowtime)") != -1&&ImodifyTime) {
					line = "			obj.setModifyTime(nowtime);";
				}
				if (line.indexOf("//PKI") != -1) {
					line = PKI_S;
				}
				if (line.indexOf("") != -1) {
					line = line.replace("", chineaseName);
				}							
				if (line.indexOf("Demo") != -1) {
					line = line.replace("Demo", tablenameF);
				}
				if (line.indexOf("smallDEMO") != -1) {
					line = line.replace("smallDEMO", tablenameF.toLowerCase());
				}
				line = line.replace("demo", tablenameF);
			}
			sb.append(line + "\r\n");
			line = br.readLine();
		}
		br.close();
		isr.close();
		fis.close();
		File file=new File(fullFileName);    
		if(!file.exists()){    
			createFileGBK(fullFileName,sb.toString());	
		}
	}
	
	/**
	 * 
	 * @param fileName
	 * @param fieldList
	 * @param typeList
	 * @throws IOException
	 */
	public static void createObjXml(String basePackage,String secondPackage,String model,String tablename, List fieldList,	List typeList,List pklist) throws IOException {
		String modelL = model.toLowerCase();
		String modelS = getFirstLowerCaseName(model);
		String modelF = getFirstUppCaseName(model);
		String tablenameL = tablename.toLowerCase();
		String tablenameS = getFirstLowerCaseName(tablename);
		String tablenameF = getFirstUppCaseName(tablename);		
		String fullPackage= basePackage+"."+secondPackage+"."+model.toLowerCase()+".model";
        String[] wordArray = fullPackage.split("\\.");
		String subDir=nsrcDir;
		for(int i=0;i<wordArray.length;i++){
			subDir=subDir+File.separator+wordArray[i];
			makeDirs(subDir);
		}
		String fullFileName=subDir+File.separator+(tablenameF)+"xml";
		String content=""+rl;
		//String demopath = sourceDir+"/base/";
		String demopath = nsrcDir+"/cn/autocode/";
		String demofile = "Demoxml";		
		FileInputStream fis = new FileInputStream(demopath + demofile); //ļ
		InputStreamReader isr = new InputStreamReader(fis,"GBK"); //ָȡΪUTF-8ʽ
		BufferedReader br = new BufferedReader(isr);
		StringBuffer sb = new StringBuffer();		
		String line = br.readLine();
		String insert_batchFieldNameList = "";
		String insert_batchParaNameList = "";
		String insertFieldNameList = "";
		String insertParamNameList = "";
		String updateFieldNameList = "";
		String updateParamNameList = "";
		String updateParamNameListKey = "";
		String deleteParamTypeList = "";
		String deleteParamNameList = "";
		String selectFieldNameList = "";
		String RH_tablefieldList = "";
		String RH_tablenameList = "";
		String selectParamNameList = "";
		String RH_conditionList = "";
		String insertUUID = "";
		String insertUUIDV = "";
		String updateUUIDV = "";
		String updateUUIDVField = "";
		String selectUUID = "";
		String deleteUUIDV = "";
		String pks = "";
		for(int x=0;x<pklist.size();x++){
			pks += pklist.get(x)+",";
		}
		int zz = 0;
		for (int i = 0; i < fieldList.size(); i++) {
			//String datatype = (String)dataList.get(i);
			String type = typeList.get(i).toString();
			//insertFieldNameList += fieldList.get(i) + ",";
			//Ż
			if(pks.indexOf((String)fieldList.get(i))!=-1){
				//System.out.println("=pks="+pks+"=value="+fieldList.get(i));
				String ddd = "";
				String AND = "";
				if(zz>0){					
					ddd = ",";
					AND = " AND ";
				}
				zz++;
				insertUUID += "<isNotEmpty prepend=',' property='"+fieldList.get(i)+"'>";
				insertUUID += ""+fieldList.get(i)+"";
				insertUUID += "</isNotEmpty>"+rl;
				insertUUIDV += "<isNotEmpty prepend=',' property='"+fieldList.get(i)+"'>";
				insertUUIDV += "#"+fieldList.get(i)+"#";
				insertUUIDV += "</isNotEmpty>"+rl; 
				/*
				insertUUID += "<isNotEmpty prepend='"+ddd+"' property='"+fieldList.get(i)+"'>";
				insertUUID += ""+fieldList.get(i)+"";
				insertUUID += "</isNotEmpty>"+rl;
				insertUUIDV += "<isNotEmpty prepend='"+ddd+"' property='"+fieldList.get(i)+"'>";
				insertUUIDV += "#"+fieldList.get(i)+"#";
				insertUUIDV += "</isNotEmpty>"+rl; 
				*/
				insert_batchFieldNameList += fieldList.get(i) + ",";
				if("uuid".equals(fieldList.get(i).toString().toLowerCase())){
					insert_batchParaNameList += "	sys_guid(),";
				}else{
					insert_batchParaNameList += "	#list[]." + fieldList.get(i) + "#,";
				}
				updateUUIDV += "<isNotEmpty prepend='AND ' property='XGTJ"+fieldList.get(i)+"'>";
				updateUUIDV += " "+fieldList.get(i)+" = #XGTJ"+fieldList.get(i)+"#";
				updateUUIDV += "</isNotEmpty>"+rl;
				
				//updateUUIDVField += ddd+" "+fieldList.get(i)+" = "+fieldList.get(i)+"";
				updateUUIDVField +=""+rl;
				
				selectUUID += ""+fieldList.get(i)+",";
				deleteUUIDV += AND+" "+fieldList.get(i)+" = #"+fieldList.get(i)+"#";
				RH_conditionList += "		<isNotEmpty prepend='AND ' property='LIKE"+fieldList.get(i)+"'>\r\n";
				//RH_conditionList += "			("+fieldList.get(i)+" like '%$LIKE"+fieldList.get(i)+"$%'  )\r\n";
				//RH_conditionList += "			("+fieldList.get(i)+" like '||#LIKE" + fieldList.get(i) + "#||'  )\r\n";
				RH_conditionList += "			("+fieldList.get(i)+" like '%$LIKE"+fieldList.get(i)+"$%'   )\r\n";
				RH_conditionList += "		</isNotEmpty>\r\n";
				RH_conditionList += "		<isNotEmpty prepend='AND ' property='"+fieldList.get(i)+"'>\r\n";
				RH_conditionList += "			("+fieldList.get(i)+" = #"+fieldList.get(i)+"#  )\r\n";
				RH_conditionList += "		</isNotEmpty>\r\n";
				continue;
			}
			/*¹
			if("uuid".equals(fieldList.get(i))||"id".equals(fieldList.get(i))){
				insertUUID += "<isNotEmpty prepend='' property='"+fieldList.get(i)+"'>";
				insertUUID += ""+fieldList.get(i)+"";
				insertUUID += "</isNotEmpty>";
				insertUUIDV += "<isNotEmpty prepend='' property='"+fieldList.get(i)+"'>";
				insertUUIDV += "'$"+fieldList.get(i)+"$'";
				insertUUIDV += "</isNotEmpty>"; 
				
				updateUUIDV += "<isNotEmpty prepend='' property='"+fieldList.get(i)+"'>";
				updateUUIDV += " "+fieldList.get(i)+" = '$"+fieldList.get(i)+"$'";
				updateUUIDV += "</isNotEmpty>";
				selectUUID += ""+fieldList.get(i)+",";
				deleteUUIDV += " "+fieldList.get(i)+" = '$"+fieldList.get(i)+"$'";
				RH_conditionList += "		<isNotEmpty prepend='AND ' property='L"+fieldList.get(i)+"'>\r\n";
				RH_conditionList += "			(x."+fieldList.get(i)+" like '%$L"+fieldList.get(i)+"$%'  )\r\n";
				RH_conditionList += "		</isNotEmpty>\r\n";
				RH_conditionList += "		<isNotEmpty prepend='AND ' property='"+fieldList.get(i)+"'>\r\n";
				RH_conditionList += "			(x."+fieldList.get(i)+" = '$"+fieldList.get(i)+"$'  )\r\n";
				RH_conditionList += "		</isNotEmpty>\r\n";
				continue;
			}
			*/
			
			if("GrTree".equals(tablename)){
				//System.out.println(tablename+"==============="+fieldList.get(i)+"===================================="+type);
			}
			insertFieldNameList += "			<isNotEmpty prepend=',' property='"+fieldList.get(i)+"'>";
			insertFieldNameList += ""+fieldList.get(i)+"";
			insertFieldNameList += "</isNotEmpty>"+rl;	
			insert_batchFieldNameList += fieldList.get(i) + ",";
			if(type.toLowerCase().indexOf("longblob")!=-1||type.toLowerCase().indexOf("blob")!=-1||type.toLowerCase().indexOf("clob")!=-1){
				insertParamNameList += "			<isNotEmpty prepend=',' property='"+fieldList.get(i)+"'>";
				insertParamNameList += "#" + fieldList.get(i) + ":BLOB#";
				insertParamNameList += "</isNotEmpty>"+rl;
				//#config:BLOB#
				insert_batchParaNameList += "#" + fieldList.get(i) + ":BLOB#,";
			}else{
				insertParamNameList += "			<isNotEmpty prepend=',' property='"+fieldList.get(i)+"'>";
				insertParamNameList += "#" + fieldList.get(i) + "#";
				insertParamNameList += "</isNotEmpty>"+rl;
				insert_batchParaNameList += "#list[]." + fieldList.get(i) + "#,";
				//insert_batchParaNameList += "to_char(sysdate,'yyyy-MM-dd HH24:mi:ss'),";
			}
			/*
			if(datatype.substring(0,1).equals("D")){
				if(fieldList.get(i).equals("createdate")){
					insertParamNameList += "<isNotEmpty prepend='' property='"+fieldList.get(i)+"'>";
					insertParamNameList += "sysdate,";
					insertParamNameList += "</isNotEmpty>";
				}else{
					//insertParamNameList += "to_date($" + fieldList.get(i) + "$,'yyyy-mm-dd hh24:mi:ss'),";
					insertParamNameList += "<isNotEmpty prepend='' property='"+fieldList.get(i)+"'>";
					insertParamNameList += "to_date('$" + fieldList.get(i) + "$','yyyy-mm-dd hh24:mi:ss'),";
					insertParamNameList += "</isNotEmpty>";
				}
			}else{
			*/
			//}				
			/*
			if(datatype.substring(0,1).equals("D")){
				if(fieldList.get(i).equals("createdate")){
					//insertParamNameList += "sysdate,";
				}else{
					//insertParamNameList += "to_date($" + fieldList.get(i) + "$,'yyyy-mm-dd hh24:mi:ss'),";
				}
				selectFieldNameList += "to_char(x."+fieldList.get(i) + ",'yyyy-mm-dd hh24:mi:ss') AS "+fieldList.get(i)+",";
			}else{
			*/
				//insertParamNameList += "$" + fieldList.get(i) + "$,";
				selectFieldNameList += ""+fieldList.get(i) + ",";
			//}
			if (i == 0) {
				updateParamNameList += "<isNotEmpty prepend='AND ' property='XGTJ"+fieldList.get(i)+"'>";
				updateParamNameList += " "+fieldList.get(i)+" = #XGTJ"+fieldList.get(i)+"#  ";
				updateParamNameList += "</isNotEmpty>"+rl;
				RH_conditionList += "		<isNotEmpty prepend='AND ' property='LIKE"+fieldList.get(i)+"'>\r\n";
				//RH_conditionList += "			("+fieldList.get(i)+" like '||#LIKE" + fieldList.get(i) + "#||'  )\r\n";
				RH_conditionList += "			("+fieldList.get(i)+" like '%$LIKE"+fieldList.get(i)+"$%'   )\r\n";
				RH_conditionList += "		</isNotEmpty>\r\n";
				RH_conditionList += "		<isNotEmpty prepend='AND ' property='"+fieldList.get(i)+"'>\r\n";
				RH_conditionList += "			("+fieldList.get(i)+" = #"+fieldList.get(i)+"#  )\r\n";
				RH_conditionList += "		</isNotEmpty>\r\n";
			} else {/*
				if(datatype.substring(0,1).equals("D")){
					if(fieldList.get(i).equals("modifydate")){
						//updateFieldNameList += fieldList.get(i) + "=sysdate,";
						updateFieldNameList += "<isNotEmpty prepend='' property='"+fieldList.get(i)+"'>";
						updateFieldNameList += fieldList.get(i) + "=sysdate,";
						updateFieldNameList += "</isNotEmpty>";		
					}else{
						//updateFieldNameList += fieldList.get(i) + "=to_date($" + fieldList.get(i) + "$,'yyyy-mm-dd hh24:mi:ss'),";
						updateFieldNameList += "<isNotEmpty prepend='' property='"+fieldList.get(i)+"'>";
						updateFieldNameList += fieldList.get(i) + "=to_date('$" + fieldList.get(i) + "$','yyyy-mm-dd hh24:mi:ss'),";
						updateFieldNameList += "</isNotEmpty>";	
					}
					RH_conditionList += "		<isNotEmpty prepend='AND ' property='"+fieldList.get(i)+"1'>\r\n";
					RH_conditionList += "			<![CDATA[ (x."+fieldList.get(i)+" >= to_date($"+fieldList.get(i)+"1$,'yyyy-mm-dd hh24:mi:ss') )]]>\r\n";
					RH_conditionList += "		</isNotEmpty>\r\n";
					RH_conditionList += 	"		<isNotEmpty prepend='AND ' property='"+fieldList.get(i)+"2'>\r\n";
					RH_conditionList += "			<![CDATA[ (x."+fieldList.get(i)+" <= to_date($"+fieldList.get(i)+"2$,'yyyy-mm-dd hh24:mi:ss') )]]>\r\n";
					RH_conditionList += "		</isNotEmpty>\r\n";
				}else{
				*/
					updateParamNameList += "			<isNotEmpty prepend='AND ' property='XGTJ"+fieldList.get(i)+"'>";
					updateParamNameList += " "+fieldList.get(i)+" = #XGTJ"+fieldList.get(i)+"# ";
					updateParamNameList += "</isNotEmpty>"+rl;
				
					updateFieldNameList += "			<isNotEmpty prepend=',' property='"+fieldList.get(i)+"'>";
					updateFieldNameList += fieldList.get(i) + "=#" + fieldList.get(i) + "#";
					updateFieldNameList += "</isNotEmpty>"+rl;		
					
					RH_conditionList += "		<isNotEmpty prepend='AND ' property='LIKE"+fieldList.get(i)+"'>\r\n";
					//RH_conditionList += "			("+fieldList.get(i)+" like '%$LIKE"+fieldList.get(i)+"$%' )\r\n";
					RH_conditionList += "			("+fieldList.get(i)+" like '%$LIKE"+fieldList.get(i)+"$%'  )\r\n";
					RH_conditionList += "		</isNotEmpty>\r\n";
					RH_conditionList += "		<isNotEmpty prepend='AND ' property='"+fieldList.get(i)+"'>\r\n";
					RH_conditionList += "			("+fieldList.get(i)+" = #"+fieldList.get(i)+"# )\r\n";
					RH_conditionList += "		</isNotEmpty>\r\n";
				//}
			}		
		}	
		RH_conditionList += "		<isNotEmpty property='tableparam'>\r\n";
		RH_conditionList += "			$tableparam$\r\n";
		RH_conditionList += "		</isNotEmpty>\r\n";	
		RH_conditionList += "		<isNotEmpty property='order'>\r\n";
		RH_conditionList += "			$order$\r\n";
		RH_conditionList += "		</isNotEmpty>";	
		insertFieldNameList = insertUUID + insertFieldNameList ;
		insertParamNameList = insertUUIDV + insertParamNameList ;
		insert_batchFieldNameList = insert_batchFieldNameList.substring(0,insert_batchFieldNameList.length()-1);
		insert_batchParaNameList = insert_batchParaNameList.substring(0,insert_batchParaNameList.length()-1);
		//insertFieldNameList = insertFieldNameList.substring(0,insertFieldNameList.length() - 1);
		//insertParamNameList = insertParamNameList.substring(0,insertParamNameList.length() - 1);
		//updateFieldNameList = updateFieldNameList.substring(0,updateFieldNameList.length() - 1);
		updateFieldNameList = updateUUIDVField+updateFieldNameList;
		updateParamNameList = updateUUIDV+updateParamNameList;
		deleteParamTypeList = updateUUIDV;
		selectFieldNameList = selectUUID+selectFieldNameList.substring(0,selectFieldNameList.length() - 1);
		RH_tablefieldList += "			<isNotEmpty property='$tablefieldlist$'>\r\n";
		RH_tablefieldList += "				$tablefieldlist$\r\n";
		RH_tablefieldList += "			</isNotEmpty>";	
		RH_tablenameList += "			<isNotEmpty property='tablenamelist'>\r\n";
		RH_tablenameList += "				tablenamelist\r\n";
		RH_tablenameList += "			</isNotEmpty>";	
		deleteParamNameList = updateParamNameList;		
		selectParamNameList = updateParamNameList;
		//iLog.debug("ֶ:" + insertFieldNameList);
		//iLog.info("ֶβ:" +tablename+"=="+insertParamNameList);
		String SeletePageStart = "SELECT * from (select rownum num , q.* from ( ";		
		String SeletePageEnd = ") q ) \r\n";
			   SeletePageEnd += "		where 1=1 \r\n";
			   
			   SeletePageEnd += "		<isNotEmpty  prepend='AND ' property='start'> \r\n";
			   SeletePageEnd += "			<![CDATA[ \r\n ";
			   SeletePageEnd += "				num > $start$ \r\n";
			   SeletePageEnd += "			]]> \r\n";
			   SeletePageEnd += "		</isNotEmpty>\r\n";
			   SeletePageEnd += "		<isNotEmpty  prepend='AND ' property='limit'> \r\n";
			   SeletePageEnd += "			<![CDATA[ \r\n ";
			   SeletePageEnd += "				num <= $limit$ \r\n";
			   SeletePageEnd += "			]]> \r\n";
			   SeletePageEnd += "		</isNotEmpty>\r\n";
			 
		while (line != null) {
			if (line != null) {
				if(line.indexOf("<sqlMap namespace=")!=-1){
					line = "<sqlMap namespace=\"\" >";
				}
				if(line.indexOf("<typeAlias alias=")!=-1){
					//line = "	<typeAlias alias=\"dto\" type=\"cn.base.dto.BaseDto\"/>\r\n";
					line += "	<typeAlias alias=\""+tablenameF+"\" type=\""+basePackage+"."+secondPackage+"."+modelL+"."+(tablenameF)+"Bean\"/>";
				}
				line = line.replaceAll("RH_demoProject", modelL);
				line = line.replaceAll("RH_BigName", tablenameF);
				line = line.replaceAll("RH_demoName", tablenameF);
				line = line.replaceAll("RH_TABLENAME", tablenameF.toLowerCase());
				line = line.replaceAll("RH_insertFieldNameList",insertFieldNameList);
				if(line.indexOf("RH_insertParamNameList")>0){
					line = "			"+insertParamNameList;	
				}						
				
				line = line.replaceAll("RH_batchInsert_FieldNameList", insert_batchFieldNameList);
				if(line.indexOf("RH_batchInsert_ParaNameList")>0){
					line = "			"+insert_batchParaNameList;	
				}
				
				if(line.indexOf("RH_updateFieldNameList")>0){
					line = "			"+ updateFieldNameList;	
				}
				if(line.indexOf("RH_updateParamNameList")>0){
					line =	"			"+ updateParamNameList;	
				}
				if(line.indexOf("RH_deleteParamTypeList")>0){
					line = deleteParamTypeList;	
				}
				if(line.indexOf("RH_demo_pkparam")>0){
					line = "	"+updateUUIDV;	
				}
				if(line.indexOf("RH_selectFieldNameList")>0){
					line = "			"+selectFieldNameList;	
				}
				if(line.indexOf("RH_tablefieldList")>0){
					line = RH_tablefieldList;	
				}	
				if(line.indexOf("RH_tablenameList")>0){
					line = RH_tablenameList;	
				}	
				if(line.indexOf("RH_conditionList")>0){
					line = RH_conditionList;
				}
				if(line.indexOf("RH_SelectPageStart")>0){
					line = "		"+SeletePageStart;	
				}
				if(line.indexOf("RH_SelectPageEnd")>0){
					line = "		"+SeletePageEnd;	
				}
				//line = line.replaceAll("RH_conditionList",RH_conditionList);
			}
			sb.append(line + "\r\n");
			line = br.readLine();
		}
		br.close();
		isr.close();
		fis.close();
		createFileUTF8(fullFileName,sb.toString());	
	}
	
	
	
	/**/
	public static void createFileGBK(String fullFileName,String sb){
		try {
			OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(fullFileName),"GBK");
	        out.write(sb);
	        out.flush();
	        out.close();
		} catch (Exception e) {
			e.printStackTrace();
		}	
	}
	
	public static void createFileUTF8(String fullFileName,String sb){
		try {
			OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(fullFileName), StandardCharsets.UTF_8);
	        out.write(sb);
	        out.flush();
	        out.close();
	        /*
			PrintStream fileStream = new PrintStream(new FileOutputStream(fullFileName),"UTF-8");
			fileStream.write(content.getBytes());
			if(fileStream!=null) fileStream.close();
			*/
		} catch (Exception e) {
			e.printStackTrace();
		}	
	}
	public static boolean makeDirs(String path){
	    File tmpFile=new File(path);
	    boolean ret=tmpFile.mkdirs();
	    return ret;
	}
	public static String getFirstUppCaseName(String name){
		String retName ="";
		if(name.length()>0){
			retName = name.substring(0, 1).toUpperCase()+name.substring(1);
		}
		return retName;
	}
	public static String getFirstLowerCaseName(String name){
		String retName ="";
		if(name.length()>0){
			retName = name.substring(0, 1).toLowerCase()+name.substring(1);
		}
		return retName;
	}
	
	/**
	 * 
	 * @param fileName
	 * @param fieldList
	 * @param typeList
	 * @throws IOException
	 */
	public static void createObjXml_ext(String basePackage,String secondPackage,String model,String tablename, List fieldList,	List typeList,List pklist) throws IOException {
		String modelL = model.toLowerCase();
		String modelS = getFirstLowerCaseName(model);
		String modelF = getFirstUppCaseName(model);
		String tablenameL = tablename.toLowerCase();
		String tablenameS = getFirstLowerCaseName(tablename);
		String tablenameF = getFirstUppCaseName(tablename);		
		String fullPackage= basePackage+"."+secondPackage+"."+model.toLowerCase();
        String[] wordArray = fullPackage.split("\\.");
		String subDir=nsrcDir;
		for(int i=0;i<wordArray.length;i++){
			subDir=subDir+File.separator+wordArray[i];
			makeDirs(subDir);
		}
		String fullFileName=subDir+File.separator+(tablenameF)+"_ext.xml";
		String content=""+rl;
		String demopath = sourceDir+"/base/";
		String demofile = "Demo_ext.xml";		
		FileInputStream fis = new FileInputStream(demopath + demofile); //ļ
		InputStreamReader isr = new InputStreamReader(fis, StandardCharsets.UTF_8); //ָȡΪGBKʽ
		BufferedReader br = new BufferedReader(isr);
		StringBuffer sb = new StringBuffer();		
		String line = br.readLine();
		String insertFieldNameList = "";
		String selectFieldNameList = "";
		String RH_conditionList = "";		
		for (int i = 0; i < fieldList.size(); i++) {
			String type = typeList.get(i).toString();
			selectFieldNameList += ""+fieldList.get(i) + ",";
			RH_conditionList += "		<isNotEmpty prepend='AND ' property='LIKE"+fieldList.get(i)+"'>\r\n";
			RH_conditionList += "			("+fieldList.get(i)+" like '%$LIKE"+fieldList.get(i)+"$%'  )\r\n";
			RH_conditionList += "		</isNotEmpty>\r\n";
			RH_conditionList += "		<isNotEmpty prepend='AND ' property='"+fieldList.get(i)+"'>\r\n";
			RH_conditionList += "			("+fieldList.get(i)+" = '$"+fieldList.get(i)+"$'  )\r\n";
			RH_conditionList += "		</isNotEmpty>\r\n";
		}	
		RH_conditionList += "		<isNotEmpty property='tableparam'>\r\n";
		RH_conditionList += "			$tableparam$\r\n";
		RH_conditionList += "		</isNotEmpty>\r\n";	
		RH_conditionList += "		<isNotEmpty property='order'>\r\n";
		RH_conditionList += "			$order$\r\n";
		RH_conditionList += "		</isNotEmpty>";	
		selectFieldNameList = selectFieldNameList.substring(0,selectFieldNameList.length() - 1);
		while (line != null) {
			if (line != null) {
				if(line.indexOf("<sqlMap namespace=")!=-1){
					line = "<sqlMap namespace=\"\" >";
				}
				if(line.indexOf("<typeAlias alias=")!=-1){
					line = "	<typeAlias alias=\"dto\" type=\"cn.base.dto.BaseDto\"/>\r\n";
					line += "	<typeAlias alias=\""+tablenameF+"_ext\" type=\""+basePackage+"."+secondPackage+"."+modelL+"."+(tablenameF)+"Bean\"/>";
				}
				line = line.replaceAll("RH_demoProject", modelL);
				line = line.replaceAll("RH_BigName", tablenameF);
				line = line.replaceAll("RH_demoName", tablenameF);
				if(line.indexOf("RH_selectFieldNameList")>0){
					line = "			"+selectFieldNameList;	
				}				
				if(line.indexOf("RH_conditionList")>0){
					line = RH_conditionList;
				}				
			}
			sb.append(line + "\r\n");
			line = br.readLine();
		}
		br.close();
		isr.close();
		fis.close();
		File file=new File(fullFileName);    
		if(!file.exists()){    
			createFileUTF8(fullFileName,sb.toString());	
		}
	}
	
}
