!(function($, win, top) {
	var RECORDBLOCK = function(options) {
		
		if(!options){throw new Error('ȡʧ!'); return ;}
		
		if(!options.serverConnection){throw new Error('serverConnection Ϊ!'); return ;}

		this.$content = null;
		this.title      = '';
		this.hideTitle      = '';
		this.cssClass   = 'num-1';
		this.$baseContainer = $("#global-container"); 
		this.onRightClick = $.noop();
		this.index = 0;
		this.uuid = null;
		this.monid = null;
		this.serverConnection=null;
		this.peerConnection=null;
		this.isRunning=false;
		this.fdId=null;
		this.channelId=null;
		$.extend(this, options);
		
		this.videoId = $.uniqueId();
		
	}
	
	RECORDBLOCK.prototype.init=function(){
		var ts = this ;
		this.$content = $("<div name='video-folder' index="+this.index+" class='"+ts.cssClass+"'></div>");
		this.$content.append("<div class=\"con-head\"><span class=\"icon-currentRecord\"></span>"+ts.title+"</div>"); 
		this.$content.append("<div class='con-content' ondblclick='BlockUtil.fullScreen("+this.index+")'><video  id='"+this.videoId +"' autoplay onplay='BlockUtil.changeBlockStatus("+this.index+");' emptied='alert(\"emptied\")' error='alert(\"error\")' style='width:100%;height:100%;object-fit:fill;' ></video></div>");
		this.$content.append("<div class='con-foot'><a href='#' class='ahref videohref' onclick='BlockUtil.startRecord("+this.index+")'>ʼ</a>&nbsp;<a href='#' class='ahref videohref' onclick='BlockUtil.pauseMonitor(\""+this.index+"\",this);'>ͣ</a>&nbsp;<a href='#' class='ahref videohref' onclick='BlockUtil.stopPlayback(\""+this.index+"\",this);'>ֹͣ</a>&nbsp;<a href='#' class='ahref videohref speedhref' onmouseup='BlockUtil.changeSpeed(\""+this.index+"\",1);'>x1</a>&nbsp;<a href='#' class='ahref videohref speedhref' onmouseup='BlockUtil.changeSpeed(\""+this.index+"\",2);'>x2</a>&nbsp;<a href='#' class='ahref videohref speedhref' onmouseup='BlockUtil.changeSpeed(\""+this.index+"\",4);'>x4</a>&nbsp;<a href='#' class='ahref videohref speedhref' onmouseup='BlockUtil.changeSpeed(\""+this.index+"\",8);'>x8</a>&nbsp;<a href='#' class='ahref videohref' onclick='BlockUtil.fullScreen("+this.index+")'>ȫ</a>&nbsp;</div> ");
		this.$content.append('<div class="loading">' +this.index+ '</div>');
		this.$content.bind("click",function(){
			$(this).siblings().find(".con-head").removeClass("current").end().end().find(".con-head").addClass("current");
			BlockUtil.setCurrentBlock(ts);
		});
		this.$content.appendTo(ts.$baseContainer);
		return this;
	}
	
	RECORDBLOCK.prototype.fullScreen=function(dom){
		dom.requestFullScreen();
	}
	
	
	RECORDBLOCK.prototype.getIndex=function(undefined){
		return this.index;
	}
	
	RECORDBLOCK.prototype.getUuId=function(undefined){
		return this.uuid;
	}
	
	RECORDBLOCK.prototype.getMonId=function(undefined){
		return this.monid;
	}

	RECORDBLOCK.prototype.setMonId=function(monid){
		this.monid = monid;
		return this;
	}
	
	RECORDBLOCK.prototype.getFdId=function(undefined){
		return this.fdId;
	}

	RECORDBLOCK.prototype.setFdId=function(fdId){
		this.fdId = fdId;
		return this;
	}
	
	RECORDBLOCK.prototype.getChannelId=function(undefined){
		return this.channelId;
	}

	RECORDBLOCK.prototype.setChannelId=function(channelId){
		this.channelId = channelId - 1 ;
		return this;
	}
	RECORDBLOCK.prototype.setHideTitle = function(title){
		this.$content.find("div.con-head").eq(0).attr("hidetitle",title);
		return this;
	}
	
	RECORDBLOCK.prototype.getHideTitle = function(){
		return this.$content.find("div.con-head").eq(0).attr("hidetitle");
	}
	
	
	RECORDBLOCK.prototype.setTitle = function(title){
		this.$content.find("div.con-head").eq(0).html(title+"<span class=\"icon-currentRecord\"></span>");
		return this;
	}
	
	RECORDBLOCK.prototype.getTitle = function(){
		return this.$content.find("div.con-head").eq(0).text();
	}
	RECORDBLOCK.prototype.startPlayback=function(begintime,endtime,currTime,playbackurl,fdid,channelid,subid){
		this.setHideTitle(this.getHideTitle());
		channelid = channelid - 1;
		this.serverConnection.send(JSON.stringify({'startplayback': {'fdid':fdid||this.getFdId(), 'channelid':channelid||this.getChannelId(), 'subid':subid || 0, 'begintime':0, 'endtime':0, 'record_item':[0, 0, playbackurl+'?s='+begintime+'&e='+(1*currTime+3600)+'&c='+currTime+'&v=1', '', '']}, 'uuid': this.getUuId()}));
		return this;
	}
	
	RECORDBLOCK.prototype.stopPlayback=function(){
		this.serverConnection.send(JSON.stringify({'stopplayback': {'monid':this.getMonId() }, 'uuid': this.getUuId()}));		
		return this;
	}
	
	RECORDBLOCK.prototype.pauseStopMonitor=function(){
		this.serverConnection.send(JSON.stringify({'controlplayback': {'monid':this.getMonId(),'action':'PAUSE','params':'' }, 'uuid': this.getUuId()}));		
		return this;
	}
	
	RECORDBLOCK.prototype.pauseStartMonitor=function(){
		this.serverConnection.send(JSON.stringify({'controlplayback': {'monid':this.getMonId(),'action':'PLAY','params':'' }, 'uuid': this.getUuId()}));		
		return this;
	}
	
	RECORDBLOCK.prototype.setPeerConnection=function(peerConnection){
		this.peerConnection = peerConnection;
		return this;
	}
	
	RECORDBLOCK.prototype.getContent=function(undefined){
		return this.$content;
	}
	
	RECORDBLOCK.prototype.setRunning=function(f){
		 this.isRunning = !!f;
		 return this;
	}
	
	RECORDBLOCK.prototype.onloading = function(n){
		this.$content.find("div.loading").show(n||200);
		return this;
	}
	
	RECORDBLOCK.prototype.unloading = function(){
		this.$content.find("div.loading").hide(n||200);
		return this;
	}
	
	RECORDBLOCK.prototype.getVideoComp = function(){
		return this.$content.find("#"+this.videoId)[0];
	}
	
	RECORDBLOCK.prototype.changeSpeed = function(speed){
		console.log(this.getMonId())
		console.log(speed)
		this.serverConnection.send(JSON.stringify({'controlplayback': {'monid':this.getMonId(), 'action':'SPEED', 'params':speed}, 'uuid': this.getUuId()}));		
		return this;
	}
	
	$.recordblock = function(_) {
		return !$.isEmptyObject(_) ? new RECORDBLOCK(_) : null;
	};

})(jQuery, window, top);