package cn.nhyw.yjjl.action;

 import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.nhyw.yjjl.service.NhywgyssbyjdService;

@SuppressWarnings({"all"})
@Component("nhywgyssbyjdAction")
public class NhywgyssbyjdAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(NhywgyssbyjdAction.class);
	
	@Autowired
	private NhywgyssbyjdService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listNhywgyssbyjdByPage")
	public void listNhywgyssbyjdByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listNhywgyssbyjdByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgyssbyjdAction-listNhywgyssbyjdByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Nhywgyssbyjd")
	public void count_Nhywgyssbyjd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Nhywgyssbyjd(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgyssbyjdAction-count_Nhywgyssbyjd-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Nhywgyssbyjd
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Nhywgyssbyjd")
	public void query_Nhywgyssbyjd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Nhywgyssbyjd(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgyssbyjdAction-query_Nhywgyssbyjd-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һNhywgyssbyjd
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Nhywgyssbyjd")
	public void get_Nhywgyssbyjd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Nhywgyssbyjd(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgyssbyjdActionquery_Nhywgyssbyjd-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteNhywgyssbyjd")
	public void delete_Nhywgyssbyjd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Nhywgyssbyjd(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgyssbyjdAction-delete_Nhywgyssbyjd-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Nhywgyssbyjd")
	public void insert_Nhywgyssbyjd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("xh"))){
				map.put("xh",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Nhywgyssbyjd(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Nhywgyssbyjd(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Nhywgyssbyjd(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgyssbyjdAction-insert_Nhywgyssbyjd()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Nhywgyssbyjd")
	public void update_Nhywgyssbyjd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Nhywgyssbyjd(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Nhywgyssbyjd(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Nhywgyssbyjd(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgyssbyjdAction-update_Nhywgyssbyjd-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}

	
	/**
	 * ɾ
	 */
	/*
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Nhywgyssbyjd")
	public void batch_delete_Nhywgyssbyjd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Nhywgyssbyjd(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgyssbyjdAction-batch_delete_Nhywgyssbyjd-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Nhywgyssbyjd")
	public void exp_Nhywgyssbyjd(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Nhywgyssbyjd(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "Ӧ豸ƽ-"+dateTime);
			params.put("sheetName", "Ӧ豸ƽ");
			params.put("header", "Ӧ豸ƽ");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgyssbyjdAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Nhywgyssbyjd")
	public String imp_Nhywgyssbyjd(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("NhywgyssbyjdAction-imp_Nhywgyssbyjd-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
	
	// ѯƽĵӼ豸Ϣ 
	public void query_yjd_dzjh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			 List<Map> list = service.query_yjd_dzjh(map);
			 Integer total = service.count_yjd_dzjh(map);
			 map.clear();
			 map.put("total", total);
			 map.put("rows", list);
			 Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgyssbyjdAction-batch_delete_Nhywgyssbyjd-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	
}
