package cn.map.szmap.cache.impl;

import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.map.szmap.cache.AbstractCache;
import com.google.gxp.com.google.common.collect.Maps;
import org.apache.log4j.Logger;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CheGpsLayerImpl extends AbstractCache {
	private static final Logger iLog = Logger.getLogger(CheGpsLayerImpl.class);
 
	public final Long type;

	public CheGpsLayerImpl(Long type) {
		this.type = type;
	}
	
	public void refreshAll(List<HashMap> list) {
		try {
			iLog.info("CheGpsLayerImpl-------refreshAll"+list.size());
			System.out.println("CheGpsLayerImpl-------refreshAll"+list.size());
			for (int i = 0; i < list.size(); i++) {
				Map m = list.get(i);
				m.put("id", m.get("xh"));
				String id = (String)m.get("id");
				if (RHUtil.isNotEmpty(id)) {
					m_cache.put(id, m);
					System.out.println("CheGpsLayerImpl-------m_cache"+id);
					iLog.info("CheGpsLayerImpl-------m_cache"+id);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("CheGpsLayerImpl  refreshAll error ,layer type:"+type ,e);
			refreshTime.set(System.currentTimeMillis());
		
		}
	}
	
	
	public Map getCheByParam(Map map){
		HashMap hm =  Maps.newHashMap();
		try {	
			String plateno =(String) map.get("plateNo");
			if(!StringUtil.isBlank(plateno)){
				Iterator<?> iterator = m_cache.keySet().iterator();
				while (iterator.hasNext()) {
					String key = (String) iterator.next();
					if(plateno.equalsIgnoreCase(key)){
						return (Map) m_cache.get(key);
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("CheGpsLayerImpl  updateCheGpsInfo error ,layer type:"+type ,e);
		}
		return hm;
	}
	
	public void updateCheGpsInfo(Map map){
		try {
			String vdId = (String) map.get("sbbh");
			if (RHUtil.isNotEmpty(vdId) && RHUtil.isNotEmpty(map.get("tdbh"))) {
				String channelId = map.get("tdbh").toString();
				String id = vdId + "-" + channelId;
				Iterator<?> iterator = m_cache.keySet().iterator();
				while(iterator.hasNext()){
					String key = (String) iterator.next();
					if(id.equalsIgnoreCase(key)){
						 HashMap che = (HashMap) m_cache.get(key);
						 che.put("jd", (String) map.get("jd"));
						 che.put("wd", (String) map.get("wd"));
						 che.put("gxsj", (String) map.get("jssj"));
						 m_cache.put(key, che);
						 break;
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("CheGpsLayerImpl  updateCheGpsInfo error ,layer type:"+type ,e);
		}
		
	}
	
	@Override
	public List<Map> getData(Map condition) {
		// TODO Auto-generated method stub
		return null;
	}

}
