package cn.bsystem.ptuserrole.service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.bsystem.ptuserrole.dao.PtyhcdjsDao;

@Service("ptyhcdjsService")
public class PtyhcdjsService extends BaseService {
	
	private static Log log = LogFactory.getLog(PtyhcdjsService.class);
	
	@Autowired
	private PtyhcdjsDao ptyhcdjsDao;
	
	/**
	 * ¼
	 * 
	 * @param
	 * @return
	 */
	public void insert_Ptyhcdjs(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ptyhcdjsDao.insert_Ptyhcdjs(map);
	}

	
	/**
	 * ޸ļ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer update_Ptyhcdjs(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ptyhcdjsDao.update_Ptyhcdjs(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 * @return
	 */
	public Integer delete_Ptyhcdjs(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ptyhcdjsDao.delete_Ptyhcdjs(map);
	}
	
	/**
	 * ɾ¼
	 * 
	 * @param
	 */
	public Integer batch_delete_Ptyhcdjs(Map map) throws SQLException{
		return ptyhcdjsDao.batch_delete_Ptyhcdjs(map);
	}

	
	/**
	 * ѯ
	 * 
	 * @param
	 * @return
	 */
	public Integer count_Ptyhcdjs(Map map) throws SQLException{
		return ptyhcdjsDao.count_Ptyhcdjs(map);
	}
	
	/**
	 * ѯб¼SELECT
	 * 
	 * @param
	 * @return
	 */
	public List<Map> query_Ptyhcdjs(Map map) throws SQLException{
		return ptyhcdjsDao.query_Ptyhcdjs(map);
	}
	
	/**
	 * ѯһ
	 * 
	 * @param
	 * @return
	 */
	public Map get_Ptyhcdjs(Map map) throws SQLException{
		return ptyhcdjsDao.get_Ptyhcdjs(map);
	}
	
	/**
	 * EXCEL
	 * 
	 * @param
	 * @return
	 */
	public Map exportPtyhcdjs(Map map) throws SQLException{
		return this.listPtyhcdjsByPage(map);
	}
	
	/**
	 * Ptyhcdjs ҳ
	 * @param map
	 * @return
	 * @throws SQLException
	 */
	public Map listPtyhcdjsByPage(Map map) throws SQLException {
		List<Map> list = ptyhcdjsDao.query_Ptyhcdjs(map);
		Integer totalCount = ptyhcdjsDao.count_Ptyhcdjs(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	/**
	 * query_ptyh_alreadyIn ҳ
	 * @throws SQLException
	 */
	public Map query_ptyh_alreadyIn(Map map) throws SQLException {
		List<Map> list = ptyhcdjsDao.query_ptyh_alreadyIn(map);
		Integer totalCount = ptyhcdjsDao.count_ptyh_alreadyIn(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	/**
	 * query_ptyh_alreadyOut ҳ
	 * @throws SQLException
	 */
	public Map query_ptyh_alreadyOut(Map map) throws SQLException {
		List<Map> list = ptyhcdjsDao.query_ptyh_alreadyOut(map);
		Integer totalCount = ptyhcdjsDao.count_ptyh_alreadyOut(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	public void insertPtyhcdjsByjsbh(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ptyhcdjsDao.insertPtyhcdjsByjsbh(map);
	}

	public Integer deletePtyhcdjsByjsbh(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ptyhcdjsDao.deletePtyhcdjsByjsbh(map);
	}
	
}
