//ע

function Label() {
    Label.graphic = null;
    Label.mapClickHandler = null;
}

Label.init = function () {
    Label();
};
//·αע
Label.addRoadLabel = function (html) {
    var Graphic = MapAPI.getGraphic();
    var Draw = MapAPI.getDraw();
    var Color = MapAPI.getColor();
    if (!Label.draw) {
        Label.draw = new Draw(MapAPI.getMap());
    }
    var PictureFillSymbol = MapAPI.getPictureFillSymbol();
    var SimpleLineSymbol = MapAPI.getSimpleLineSymbol();
    var SimpleFillSymbol = MapAPI.getSimpleFillSymbol();
    var CartographicLineSymbol = MapAPI.getCartographicLineSymbol();
    var lineSymbol = new CartographicLineSymbol(
        CartographicLineSymbol.STYLE_SOLID,
        new Color([255, 0, 0]), 5,
        CartographicLineSymbol.CAP_ROUND,
        CartographicLineSymbol.JOIN_MITER, 5
    );
    if (!MapAPI.getMap().isPan) {
        MapAPI.getMap().enableMapNavigation();
        Label.draw.deactivate();
        Label.draw = null;
    } else {
        MapAPI.getMap().disableMapNavigation();
        Label.draw.activate('polyline');
        Label.draw.on("draw-end", function (evt) {
            console.log("evt.geometry", evt.geometry);
            var positionStr = '';
            for (var i = 0, len = evt.geometry.paths[0].length; i < len; i++) {
                var x = evt.geometry.paths[0][i][0];
                var y = evt.geometry.paths[0][i][1];
                if (i == len - 1) {
                    positionStr += x + ',' + y;
                } else {
                    positionStr += x + ',' + y + ";";
                }
            }
            var attr = {position: positionStr};
            var InfoTemplate = MapAPI.getInfoTemplate();
            var Point = MapAPI.getPoint();
            var point = new Point(evt.geometry.paths[0][evt.geometry.paths[0].length - 1][0], evt.geometry.paths[0][evt.geometry.paths[0].length - 1][1]);
            var infoTemplate = new InfoTemplate("·", html);
            Label.graphic = new Graphic(evt.geometry, lineSymbol, attr, infoTemplate);
            MapAPI.getRoadGraphicsLayer().add(Label.graphic);
            MapAPI.getMap().setInfoWindowOnClick(true);
            MapAPI.getMap().centerAt(point).then(function () {
                MapAPI.getMap().infoWindow.setTitle(infoTemplate.title);
                MapAPI.getMap().infoWindow.setContent(infoTemplate.content);
                MapAPI.getMap().infoWindow.show(point, MapAPI.getMap().getInfoWindowAnchor(point));
                MapAPI.getMap().infoWindow.setFeatures([Label.graphic]);
                var hide = MapAPI.getMap().infoWindow.on("hide", function () {
                    Label.cancelRoad();
                    hide.remove();
                });
            });
            MapAPI.getMap().enableMapNavigation();
            Label.draw.deactivate();
            Label.draw = null;
        });
    }
};
//Ӽرע
Label.addCameraLabel = function (html) {
    if (Label.mapClickHandler) {
        Label.mapClickHandler.remove();
    }
    Label.mapClickHandler = MapAPI.getMap().on("click", function (e) {
        if (!e.graphic) {
            var mapPoint = MapAPI.getMap().toMap(e.screenPoint);
            var data = {"jd": mapPoint.x, "wd": mapPoint.y, "tdmc": "עͷ"};
            Label.graphic = MapUtil.addPoint(data, html);
            MapAPI.getCameraGraphicsLayer().add(Label.graphic);
            MapAPI.getMap().setInfoWindowOnClick(true);
            MapAPI.getMap().centerAt(Label.graphic.geometry).then(function () {
                MapAPI.getMap().infoWindow.setTitle(Label.graphic.getInfoTemplate().title);
                MapAPI.getMap().infoWindow.setContent(Label.graphic.getInfoTemplate().content);
                MapAPI.getMap().infoWindow.show(Label.graphic.geometry, MapAPI.getMap().getInfoWindowAnchor(e.screenPoint));
                MapAPI.getMap().infoWindow.setFeatures([Label.graphic]);
                var hide = MapAPI.getMap().infoWindow.on("hide", function () {
                    Label.cancelCamera();
                    hide.remove();
                });
            });
            if (Label.mapClickHandler) {
                Label.mapClickHandler.remove();
            }
        }
    });
};

// ע
Label.addJtjzwLabel = function (html) {
    if (Label.mapClickHandler) {
        Label.mapClickHandler.remove();
    }
    Label.mapClickHandler = MapAPI.getMap().on("click", function (e) {
        if (!e.graphic) {
            var mapPoint = MapAPI.getMap().toMap(e.screenPoint);
            var data = {"jd": mapPoint.x, "wd": mapPoint.y, "jzwmc": "ע"};
            Label.graphic = MapUtil.addJtjzwPoint(data, html);
            MapAPI.getJtjzwGraphicsLayer().add(Label.graphic);
            MapAPI.getMap().setInfoWindowOnClick(true);
            MapAPI.getMap().centerAt(Label.graphic.geometry).then(function () {
                MapAPI.getMap().infoWindow.setTitle(Label.graphic.getInfoTemplate().title);
                MapAPI.getMap().infoWindow.setContent(Label.graphic.getInfoTemplate().content);
                MapAPI.getMap().infoWindow.show(Label.graphic.geometry, MapAPI.getMap().getInfoWindowAnchor(e.screenPoint));
                MapAPI.getMap().infoWindow.setFeatures([Label.graphic]);
                var hide = MapAPI.getMap().infoWindow.on("hide", function () {
                    Label.cancelJtjzw();
                    hide.remove();
                });
            });
            if (Label.mapClickHandler) {
                Label.mapClickHandler.remove();
            }
        }
    });
}

// ־Ʊע
Label.addNhywjtbzLabel = function (html) {
    if (Label.mapClickHandler) {
        Label.mapClickHandler.remove();
    }
    Label.mapClickHandler = MapAPI.getMap().on("click", function (e) {
        if (!e.graphic) {
            var mapPoint = MapAPI.getMap().toMap(e.screenPoint);
            var data = {"jd": mapPoint.x, "wd": mapPoint.y, "bzmc": "ע־"};
            Label.graphic = MapUtil.addNhywjtbzPoint(data, html);
            MapAPI.getNhywjtbzGraphicsLayer().add(Label.graphic);
            MapAPI.getMap().setInfoWindowOnClick(true);
            MapAPI.getMap().centerAt(Label.graphic.geometry).then(function () {
                MapAPI.getMap().infoWindow.setTitle(Label.graphic.getInfoTemplate().title);
                MapAPI.getMap().infoWindow.setContent(Label.graphic.getInfoTemplate().content);
                MapAPI.getMap().infoWindow.show(Label.graphic.geometry, MapAPI.getMap().getInfoWindowAnchor(e.screenPoint));
                MapAPI.getMap().infoWindow.setFeatures([Label.graphic]);
                var hide = MapAPI.getMap().infoWindow.on("hide", function () {
                    Label.cancelNhywjtbz();
                    hide.remove();
                });
            });
            if (Label.mapClickHandler) {
                Label.mapClickHandler.remove();
            }
        }
    });
}

// ͨ߱ע
Label.addJtbxLabel = function (html) {
    if (Label.mapClickHandler) {
        Label.mapClickHandler.remove();
    }
    Label.mapClickHandler = MapAPI.getMap().on("click", function (e) {
        if (!e.graphic) {
            var mapPoint = MapAPI.getMap().toMap(e.screenPoint);
            var data = {"jd": mapPoint.x, "wd": mapPoint.y, "bxmc": "ע"};
            Label.graphic = MapUtil.addJtbxPoint(data, html);
            MapAPI.getJtbxGraphicsLayer().add(Label.graphic);
            MapAPI.getMap().setInfoWindowOnClick(true);
            MapAPI.getMap().centerAt(Label.graphic.geometry).then(function () {
                MapAPI.getMap().infoWindow.setTitle(Label.graphic.getInfoTemplate().title);
                MapAPI.getMap().infoWindow.setContent(Label.graphic.getInfoTemplate().content);
                MapAPI.getMap().infoWindow.show(Label.graphic.geometry, MapAPI.getMap().getInfoWindowAnchor(e.screenPoint));
                MapAPI.getMap().infoWindow.setFeatures([Label.graphic]);
                var hide = MapAPI.getMap().infoWindow.on("hide", function () {
                    Label.cancelJtbx();
                    hide.remove();
                });
            });
            if (Label.mapClickHandler) {
                Label.mapClickHandler.remove();
            }
        }
    });
}

// ͨע
Label.addJthlLabel = function (html) {
    if (Label.mapClickHandler) {
        Label.mapClickHandler.remove();
    }
    Label.mapClickHandler = MapAPI.getMap().on("click", function (e) {
        if (!e.graphic) {
            var mapPoint = MapAPI.getMap().toMap(e.screenPoint);
            var data = {"jd": mapPoint.x, "wd": mapPoint.y, "hlmc": "ע"};
            Label.graphic = MapUtil.addJthlPoint(data, html);
            MapAPI.getJthlGraphicsLayer().add(Label.graphic);
            MapAPI.getMap().setInfoWindowOnClick(true);
            MapAPI.getMap().centerAt(Label.graphic.geometry).then(function () {
                MapAPI.getMap().infoWindow.setTitle(Label.graphic.getInfoTemplate().title);
                MapAPI.getMap().infoWindow.setContent(Label.graphic.getInfoTemplate().content);
                MapAPI.getMap().infoWindow.show(Label.graphic.geometry, MapAPI.getMap().getInfoWindowAnchor(e.screenPoint));
                MapAPI.getMap().infoWindow.setFeatures([Label.graphic]);
                var hide = MapAPI.getMap().infoWindow.on("hide", function () {
                    Label.cancelJthl();
                    hide.remove();
                });
            });
            if (Label.mapClickHandler) {
                Label.mapClickHandler.remove();
            }
        }
    });
}

// ͨźŵƱע
Label.addJtxhdLabel = function (html) {
    if (Label.mapClickHandler) {
        Label.mapClickHandler.remove();
    }
    Label.mapClickHandler = MapAPI.getMap().on("click", function (e) {
        if (!e.graphic) {
            var mapPoint = MapAPI.getMap().toMap(e.screenPoint);
            var data = {"jd": mapPoint.x, "wd": mapPoint.y, "xhdmc": "עźŵ"};
            Label.graphic = MapUtil.addJtxhdPoint(data, html);
            MapAPI.getJtxhdGraphicsLayer().add(Label.graphic);
            MapAPI.getMap().setInfoWindowOnClick(true);
            MapAPI.getMap().centerAt(Label.graphic.geometry).then(function () {
                MapAPI.getMap().infoWindow.setTitle(Label.graphic.getInfoTemplate().title);
                MapAPI.getMap().infoWindow.setContent(Label.graphic.getInfoTemplate().content);
                MapAPI.getMap().infoWindow.show(Label.graphic.geometry, MapAPI.getMap().getInfoWindowAnchor(e.screenPoint));
                MapAPI.getMap().infoWindow.setFeatures([Label.graphic]);
                var hide = MapAPI.getMap().infoWindow.on("hide", function () {
                    Label.cancelJtxhd();
                    hide.remove();
                });
            });
            if (Label.mapClickHandler) {
                Label.mapClickHandler.remove();
            }
        }
    });
}

// ͨյע
Label.addJtydpLabel = function (html) {
    if (Label.mapClickHandler) {
        Label.mapClickHandler.remove();
    }
    Label.mapClickHandler = MapAPI.getMap().on("click", function (e) {
        if (!e.graphic) {
            var mapPoint = MapAPI.getMap().toMap(e.screenPoint);
            var data = {"jd": mapPoint.x, "wd": mapPoint.y, "ledmc": "עյ"};
            Label.graphic = MapUtil.addJtydpPoint(data, html);
            MapAPI.getJtydpGraphicsLayer().add(Label.graphic);
            MapAPI.getMap().setInfoWindowOnClick(true);
            MapAPI.getMap().centerAt(Label.graphic.geometry).then(function () {
                MapAPI.getMap().infoWindow.setTitle(Label.graphic.getInfoTemplate().title);
                MapAPI.getMap().infoWindow.setContent(Label.graphic.getInfoTemplate().content);
                MapAPI.getMap().infoWindow.show(Label.graphic.geometry, MapAPI.getMap().getInfoWindowAnchor(e.screenPoint));
                MapAPI.getMap().infoWindow.setFeatures([Label.graphic]);
                var hide = MapAPI.getMap().infoWindow.on("hide", function () {
                    Label.cancelJtydp();
                    hide.remove();
                });
            });
            if (Label.mapClickHandler) {
                Label.mapClickHandler.remove();
            }
        }
    });
}

// شűע
Label.adddcLabel = function (html) {
    if (Label.mapClickHandler) {
        Label.mapClickHandler.remove();
    }
    Label.mapClickHandler = MapAPI.getMap().on("click", function (e) {
        if (!e.graphic) {
            var mapPoint = MapAPI.getMap().toMap(e.screenPoint);
            var data = {"longitude": mapPoint.x, "latitude": mapPoint.y, "name": "עش","detectortype":"GVD"};
            Label.graphic = MapUtil.adddetectorPoint(data, html);
            MapAPI.getJtdcGraphicsLayer().add(Label.graphic);
            MapAPI.getMap().setInfoWindowOnClick(true);
            MapAPI.getMap().centerAt(Label.graphic.geometry).then(function () {
                MapAPI.getMap().infoWindow.setTitle(Label.graphic.getInfoTemplate().title);
                MapAPI.getMap().infoWindow.setContent(Label.graphic.getInfoTemplate().content);
                MapAPI.getMap().infoWindow.show(Label.graphic.geometry, MapAPI.getMap().getInfoWindowAnchor(e.screenPoint));
                MapAPI.getMap().infoWindow.setFeatures([Label.graphic]);
                var hide = MapAPI.getMap().infoWindow.on("hide", function () {
                    Label.canceldetector("GVD");
                    hide.remove();
                });
            });
            if (Label.mapClickHandler) {
                Label.mapClickHandler.remove();
            }
        }
    });
}


// ΢ע
Label.addwbLabel = function (html) {
    if (Label.mapClickHandler) {
        Label.mapClickHandler.remove();
    }
    Label.mapClickHandler = MapAPI.getMap().on("click", function (e) {
        if (!e.graphic) {
            var mapPoint = MapAPI.getMap().toMap(e.screenPoint);
            var data = {"longitude": mapPoint.x, "latitude": mapPoint.y, "name": "ע΢","detectortype":"SMARTSENSOR"};
            Label.graphic = MapUtil.adddetectorPoint(data, html);
            MapAPI.getJtwbGraphicsLayer().add(Label.graphic);
            MapAPI.getMap().setInfoWindowOnClick(true);
            MapAPI.getMap().centerAt(Label.graphic.geometry).then(function () {
                MapAPI.getMap().infoWindow.setTitle(Label.graphic.getInfoTemplate().title);
                MapAPI.getMap().infoWindow.setContent(Label.graphic.getInfoTemplate().content);
                MapAPI.getMap().infoWindow.show(Label.graphic.geometry, MapAPI.getMap().getInfoWindowAnchor(e.screenPoint));
                MapAPI.getMap().infoWindow.setFeatures([Label.graphic]);
                var hide = MapAPI.getMap().infoWindow.on("hide", function () {
                    Label.canceldetector("SMARTSENSOR");
                    hide.remove();
                });
            });
            if (Label.mapClickHandler) {
                Label.mapClickHandler.remove();
            }
        }
    });
}
// ״ע
Label.addldLabel = function (html) {
    if (Label.mapClickHandler) {
        Label.mapClickHandler.remove();
    }
    Label.mapClickHandler = MapAPI.getMap().on("click", function (e) {
        if (!e.graphic) {
            var mapPoint = MapAPI.getMap().toMap(e.screenPoint);
            var data = {"jd": mapPoint.x, "wd": mapPoint.y, "ldmc": "ע״"};
            Label.graphic = MapUtil.adddLdPoint(data, html);
            MapAPI.getJtldGraphicsLayer().add(Label.graphic);
            MapAPI.getMap().setInfoWindowOnClick(true);
            MapAPI.getMap().centerAt(Label.graphic.geometry).then(function () {
                MapAPI.getMap().infoWindow.setTitle(Label.graphic.getInfoTemplate().title);
                MapAPI.getMap().infoWindow.setContent(Label.graphic.getInfoTemplate().content);
                MapAPI.getMap().infoWindow.show(Label.graphic.geometry, MapAPI.getMap().getInfoWindowAnchor(e.screenPoint));
                MapAPI.getMap().infoWindow.setFeatures([Label.graphic]);
                var hide = MapAPI.getMap().infoWindow.on("hide", function () {
                    Label.cancelld();
                    hide.remove();
                });
            });
            if (Label.mapClickHandler) {
                Label.mapClickHandler.remove();
            }
        }
    });
}


//ע豸ȷ
Label.confirmCamera = function () {
    var jd = $("#jd").val();
    var wd = $("#wd").val();
    var sxt = $("#sxt").val();
    var xh = $("#videoId").val();
    var params = {"jd": jd, "wd": wd, "sxt": sxt, "xh": xh};
//		console.log("confirmCamera ",params);
    if (sxt.trim() != '') {
        var data = {"jd": jd, "wd": wd, "tdmc": sxt, "xh": xh};
        var html = "<div class='bcontent'><div><span style='color:#75767A'>" + sxt + "</span></div>" +
            "<ul  class='bcontentItem'><li onclick='Label.realtimeVideo(\"" + xh + "\")'>Ƶ</li>" +
            //							"<li onclick='Label.artificialAlarm(\""+xh+"\")'>˹澯</li>" +recordNav
            "<li onclick='Label.recordNav(\"" + xh + "\")'>¼</li>" +
            "<li onclick=' Label.editvideo(\"" + xh + "\")'>༭</li>" +
            "<li onclick=' Label.detailInformation(\"" + xh + "\")'></li>" +
            "<li onclick='removeCamera(\"" + xh + "\")'>ɾ</li>" +
            "</ul></div>";
        MapAPI.getMap().infoWindow.hide();
        MapAPI.getCameraGraphicsLayer().remove(Label.graphic);
        MapUtil.addPoint(data, html);
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'sbtdspsrAction!update_Sbtdspsr.do',
            data: params,
            success: function (flag) {
                if (flag == "success") {
                    $.showMsg("豸ӳɹ");
                } else {
                    $.showMsg("豸ʧ!");
                }
            }
        });
    } else {
        $.showMsg("ƲΪ!");
    }
};

//ע·豸ȷ
Label.confirmRoad = function () {

    var roadPart = $("#roadPart").val();
//	console.log("=======  Label.confirmRoad ========");
    var roadName = $("#roadName").val();
    var sxt = $("#sxt").val();
    var position = $("#position").val();
    var sbbh = $("#sbbh").val();
    var tdbh = $("#tdbh").val();
    var xh = $("#xh").val();
    var uuid = $.uniqueId();
    var params = {
        roadName: roadName, channelName: sxt, roadGridPosition: position,
        roadNumber: xh, vdid: sbbh, channelId: tdbh, remarks1: roadPart,
        remarks2: '1', roadGridId: uuid
    };
    var ssld = roadPart + "(" + roadName + ")";
// 	console.log("=======  Label.confirmRoad ========",params);
    if (roadPart.trim() != '' && sxt.trim() != '' && roadName.trim() != '') {

        $.ajax({										// 
            type: 'post',
            dataType: 'json',
            url: 'trafficroadgridinfoAction!insert_Trafficroadgridinfo.do',
            data: params,
            success: function (flag) {
                if (flag == "success") {

                    var data = {"position": position, "sxt": roadName, "xh": uuid, "tdmc": roadPart};
                    var html = "<div class='bcontent'><div><span style='color:#75767A'>" + ssld + "</span></div>" +
                        "<ul  class='bcontentItem'>" +
                        "<li onclick=' Label.editroad(\"" + uuid + "\")'>༭</li>" +
                        "<li onclick=' Label.detailInfoRoad(\"" + uuid + "\")'></li>" +
                        "<li onclick='Label.deleteRoad(\"" + uuid + "\")'>ɾ·</li>" +
                        "</ul></div>";

                    var result = [[]];
                    if (position != null && position.trim() != '') {
                        var positionArr = position.split(';');
                        for (var j = 0; j < positionArr.length; j++) {
                            result[0].push([positionArr[j].split(',')[0], positionArr[j].split(',')[1]]);
                        }
                    }
                    data.geometry = result;
                    MapUtil.addLine(data, html);
                    MapAPI.getMap().infoWindow.hide();
                    $.showMsg("·αעɹ");
                } else {
                    $.showMsg("·αעʧ!");
                }
            }
        });
    } else {
        $.showMsg("·,·βΪ!");
    }
};
//עȷ
Label.confirmJtjzw = function () {
    var jd = $("#jd").val();
    var wd = $("#wd").val();
    var jzwmc = $("#sxt").val();
    var xh = $("#xh").val();
    var params = {"jd": jd, "wd": wd, "XGTJjzwmc": jzwmc, "XGTJxh": xh};
//		console.log("confirmCamera ",params);
    if (jzwmc.trim() != '') {
        var data = {"jd": jd, "wd": wd, "jzwmc": jzwmc, "xh": xh};
        var html = "<div class='bcontent'><div><span style='color:#75767A'>" + jzwmc + "</span></div>" +
            "<ul  class='bcontentItem'>" +
            "<li onclick='Label.editJjzw(\"" + xh + "\")'>༭</li>" +
            "<li onclick='Label.detailInformationJtjzw(\"" + xh + "\")'></li>" +
            "<li onclick='removeJtjzw(\"" + xh + "\")'>ɾ</li>" +
            "</ul></div>";
        MapAPI.getMap().infoWindow.hide();
        MapAPI.getJtjzwGraphicsLayer().remove(Label.graphic);
        MapUtil.addJtjzwPoint(data, html);
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjtjzwxxbAction!update_Nhywjtjzwxxb.do',
            data: params,
            success: function (flag) {
                if (flag == "success") {
                    $.showMsg("ӳɹ");
                } else {
                    $.showMsg("ʧ!");
                }
            }
        });
    } else {
        $.showMsg("ƲΪ!");
    }
};
// ע־ȷ
Label.confirmNhywjtbz = function () {
    var jd = $("#jd").val();
    var wd = $("#wd").val();
    var bzmc = $("#sxt").val();
    var xh = $("#xh").val();
    var params = {"jd": jd, "wd": wd, "XGTJbzmc": bzmc, "XGTJxh": xh};
//	console.log("confirmCamera ",params);
    if (bzmc.trim() != '') {
        var data = {"jd": jd, "wd": wd, "bzmc": bzmc, "xh": xh};
        var html = "<div class='bcontent'><div><span style='color:#75767A'>" + bzmc + "</span></div>" +
            "<ul  class='bcontentItem'>" +
            "<li onclick='Label.editbzp(\"" + xh + "\")'>༭</li>" +
            "<li onclick='Label.detailInformationNhywjtbz(\"" + xh + "\")'></li>" +
            "<li onclick='removeNhywjtbz(\"" + xh + "\")'>ɾ</li>" +
            "</ul></div>";
        MapAPI.getMap().infoWindow.hide();
        MapAPI.getNhywjtbzGraphicsLayer().remove(Label.graphic);
        MapUtil.addNhywjtbzPoint(data, html);
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjtbzglAction!update_Nhywjtbzgl.do',
            data: params,
            success: function (flag) {
                if (flag == "success") {
                    $.showMsg("־ӳɹ");
                } else {
                    $.showMsg("־ʧ!");
                }
            }
        });
    } else {
        $.showMsg("־ƲΪ!");
    }
}

// ͨȷ
Label.confirmJtbx = function () {
    var jd = $("#jd").val();
    var wd = $("#wd").val();
    var bxmc = $("#sxt").val();
    var xh = $("#xh").val();
    var params = {"jd": jd, "wd": wd, "XGTJbxmc": bxmc, "XGTJxh": xh};
//	console.log("confirmCamera ",params);
    if (bxmc.trim() != '') {
        var data = {"jd": jd, "wd": wd, "bxmc": bxmc, "xh": xh};
        var html = "<div class='bcontent'><div><span style='color:#75767A'>" + bxmc + "</span></div>" +
            "<ul  class='bcontentItem'>" +
            "<li onclick='Label.editbx(\"" + xh + "\")'>༭</li>" +
            "<li onclick='Label.detailInformationJtbx(\"" + xh + "\")'></li>" +
            "<li onclick='removeJtbx(\"" + xh + "\")'>ɾ</li>" +
            "</ul></div>";
        MapAPI.getMap().infoWindow.hide();
        MapAPI.getJtbxGraphicsLayer().remove(Label.graphic);
        MapUtil.addJtbxPoint(data, html);
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjtbxglAction!update_Nhywjtbxgl.do',
            data: params,
            success: function (flag) {
                if (flag == "success") {
                    $.showMsg("ӳɹ");
                } else {
                    $.showMsg("ʧ!");
                }
            }
        });
    } else {
        $.showMsg("ƲΪ!");
    }
}

// ͨȷ
Label.confirmJthl = function () {
    var jd = $("#jd").val();
    var wd = $("#wd").val();
    var hlmc = $("#sxt").val();
    var xh = $("#xh").val();
    var params = {"jd": jd, "wd": wd, "XGTJhlmc": hlmc, "XGTJxh": xh};
//	console.log("confirmCamera ",params);
    if (hlmc.trim() != '') {
        var data = {"jd": jd, "wd": wd, "hlmc": hlmc, "xh": xh};
        var html = "<div class='bcontent'><div><span style='color:#75767A'>" + hlmc + "</span></div>" +
            "<ul  class='bcontentItem'>" +
            "<li onclick='Label.edithl(\"" + xh + "\")'>༭</li>" +
            "<li onclick='Label.detailInformationJthl(\"" + xh + "\")'></li>" +
            "<li onclick='removeJthl(\"" + xh + "\")'>ɾ</li>" +
            "</ul></div>";
        MapAPI.getMap().infoWindow.hide();
        MapAPI.getJthlGraphicsLayer().remove(Label.graphic);
        MapUtil.addJthlPoint(data, html);
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjthlglAction!update_Nhywjthlgl.do',
            data: params,
            success: function (flag) {
                if (flag == "success") {
                    $.showMsg("ӳɹ");
                } else {
                    $.showMsg("ʧ!");
                }
            }
        });
    } else {
        $.showMsg("ƲΪ!");
    }
}

// ͨźŵȷ
Label.confirmJtxhd = function () {
    var jd = $("#jd").val();
    var wd = $("#wd").val();
    var xhdmc = $("#sxt").val();
    var xh = $("#xh").val();
    var params = {"jd": jd, "wd": wd, "XGTJxhdmc": xhdmc, "XGTJxh": xh};
//	console.log("confirmCamera ",params);
    if (xhdmc.trim() != '') {
        var data = {"jd": jd, "wd": wd, "xhdmc": xhdmc, "xh": xh};
        var html = "<div class='bcontent'><div><span style='color:#75767A'>" + xhdmc + "</span></div>" +
            "<ul  class='bcontentItem'>" +
            "<li onclick='Label.editxhd(\"" + xh + "\")'>༭</li>" +
            "<li onclick='Label.detailInformationJtxhd(\"" + xh + "\")'></li>" +
            "<li onclick='removeJtxhd(\"" + xh + "\")'>ɾ</li>" +
            "</ul></div>";
        MapAPI.getMap().infoWindow.hide();
        MapAPI.getJtxhdGraphicsLayer().remove(Label.graphic);
        MapUtil.addJtxhdPoint(data, html);
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjtxhdglAction!update_Nhywjtxhdgl.do',
            data: params,
            success: function (flag) {
                if (flag == "success") {
                    $.showMsg("źŵӳɹ");
                } else {
                    $.showMsg("źŵʧ!");
                }
            }
        });
    } else {
        $.showMsg("źŵƲΪ!");
    }
}

//ͨյȷ
Label.confirmJtydp = function () {
    var jd = $("#jd").val();
    var wd = $("#wd").val();
    var ledmc = $("#sxt").val();
    var xh = $("#xh").val();
    var params = {"jd": jd, "wd": wd, "XGTJledmc": ledmc, "XGTJxh": xh};
//	console.log("confirmCamera ",params);
    if (ledmc.trim() != '') {
        var data = {"jd": jd, "wd": wd, "ledmc": ledmc, "xh": xh};
        var html = "<div class='bcontent'><div><span style='color:#75767A'>" + ledmc + "</span></div>" +
            "<ul  class='bcontentItem'>" +
            "<li onclick='Label.editydp(\"" + xh + "\")'>༭</li>" +
            "<li onclick='Label.detailInformationJtydp(\"" + xh + "\")'></li>" +
            "<li onclick='removeJtydp(\"" + xh + "\")'>ɾ</li>" +
            "</ul></div>";
        MapAPI.getMap().infoWindow.hide();
        MapAPI.getJtydpGraphicsLayer().remove(Label.graphic);
        MapUtil.addJtydpPoint(data, html);
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjtledydpglAction!update_Nhywjtledydpgl.do',
            data: params,
            success: function (flag) {
                if (flag == "success") {
                    $.showMsg("յӳɹ");
                } else {
                    $.showMsg("յʧ!");
                }
            }
        });
    } else {
        $.showMsg("յƲΪ!");
    }
}

//ע豸ȡ
Label.cancelCamera = function () {
    MapAPI.getCameraGraphicsLayer().remove(Label.graphic);
    MapAPI.getMap().infoWindow.hide();
    $.showMsg("ע豸ȡɹ!");
};
//ע·豸ȡ
Label.cancelRoad = function () {
    MapAPI.getRoadGraphicsLayer().remove(Label.graphic);
    MapAPI.getMap().infoWindow.hide();
    $.showMsg("ע·豸ȡɹ!");
};
//עȡ
Label.cancelJtjzw = function () {
    MapAPI.getJtjzwGraphicsLayer().remove(Label.graphic);
    MapAPI.getMap().infoWindow.hide();
    $.showMsg("עȡɹ!");
};
//ע־ȡ
Label.cancelNhywjtbz = function () {
    MapAPI.getNhywjtbzGraphicsLayer().remove(Label.graphic);
    MapAPI.getMap().infoWindow.hide();
    $.showMsg("ע־ȡɹ!");
}
//עȡ
Label.cancelJtbx = function () {
    MapAPI.getJtbxGraphicsLayer().remove(Label.graphic);
    MapAPI.getMap().infoWindow.hide();
    $.showMsg("עȡɹ!");
}
// עȡ
Label.cancelJthl = function () {
    MapAPI.getJthlGraphicsLayer().remove(Label.graphic);
    MapAPI.getMap().infoWindow.hide();
    $.showMsg("עȡɹ!");
}
// עźŵȡ
Label.cancelJtxhd = function () {
    MapAPI.getJtxhdGraphicsLayer().remove(Label.graphic);
    MapAPI.getMap().infoWindow.hide();
    $.showMsg("עźŵȡɹ!");
}
//עյȡ
Label.cancelJtydp = function () {
    MapAPI.getJtydpGraphicsLayer().remove(Label.graphic);
    MapAPI.getMap().infoWindow.hide();
    $.showMsg("עյȡɹ!");
}

//豸
Label.fillCamera = function (o) {
//	console.log("fillCamera",o);
    $("#arcgisIframe").hide();
    $(".esri-component").show();
    var dataJson = JSON.parse($(o).attr("data-json"));
//	console.log(": ",dataJson);
    $('#videoId').val(dataJson.xh);
    $("#sbbh").val(dataJson.sbbh);
    $("#tdbh").val(dataJson.tdbh);
    $("#sxt").val(dataJson.tdmc);
    $("#xh").val(dataJson.roadId);
    var roadName = $("#roadName").val();
    if (roadName == '' || roadName == null) {
        $("#roadName").val(dataJson.roadName);
    }
};
//·
Label.fillRoad = function (o) {
//	console.log("fillRoad",o);
    $("#arcgisIframe").hide();
    $(".esri-component").show();
    var dataJson = JSON.parse($(o).attr("data-json"));

    $("#roadName").val(dataJson.roadname);
    $("#xh").val(dataJson.roadid);
};

//
Label.fillJtjzw = function (o) {
//	console.log("fillCamera",o);
    $("#arcgisIframe").hide();
    $(".esri-component").show();
    var dataJson = JSON.parse($(o).attr("data-json"));
//	console.log("ݽ: ",dataJson);

    $('#xh').val(dataJson.xh);
    $("#sxt").val(dataJson.jzwmc);
    $("#jzwbh").val(dataJson.jzwbh);
};

// ־
Label.fillNhywjtbz = function (o) {
//	console.log("fillCamera",o);
    $("#arcgisIframe").hide();
    $(".esri-component").show();
    var dataJson = JSON.parse($(o).attr("data-json"));
//	console.log("ݽ: ",dataJson);

    $('#xh').val(dataJson.xh);
    $("#sxt").val(dataJson.bzmc);
    $("#bzbh").val(dataJson.bzbh);
}

// 
Label.fillJtbx = function (o) {
    $("#arcgisIframe").hide();
    $(".esri-component").show();
    var dataJson = JSON.parse($(o).attr("data-json"));

    $('#xh').val(dataJson.xh);
    $("#sxt").val(dataJson.bxmc);
    $("#bxbh").val(dataJson.bxbh);
}

// 
Label.fillJthl = function (o) {
    $("#arcgisIframe").hide();
    $(".esri-component").show();
    var dataJson = JSON.parse($(o).attr("data-json"));

    $('#xh').val(dataJson.xh);
    $("#sxt").val(dataJson.hlmc);
    $("#hlbh").val(dataJson.hlbh);
}

// ͨźŵ
Label.fillJtxhd = function (o) {
    $("#arcgisIframe").hide();
    $(".esri-component").show();
    var dataJson = JSON.parse($(o).attr("data-json"));

    $('#xh').val(dataJson.xh);
    $("#sxt").val(dataJson.xhdmc);
    $("#xhdbh").val(dataJson.xhdbh);
}

//ͨյ
Label.fillJtydp = function (o) {
    $("#arcgisIframe").hide();
    $(".esri-component").show();
    var dataJson = JSON.parse($(o).attr("data-json"));

    $('#xh').val(dataJson.xh);
    $("#sxt").val(dataJson.ledmc);
    $("#ledbh").val(dataJson.ledbh);
}

//豸ѯ
Label.cameraSearch = function () {
    var data_val = {Label: Label};
    var url = top.sysUrl + "/yw/szmap/map/toolbar_operation/itemPage/camera-search.jsp";
    top.windowid = top.$.createWin({
        title: '豸ѯ',
        width: '700',
        height: '420',
        data: data_val,
        url: url
    });
};
//·βѯ
Label.roadSearch = function () {
    var data_val = {Label: Label};
    var url = top.sysUrl + "/yw/szmap/map/toolbar_operation/itemPage/road-search.jsp";
    top.windowid = top.$.createWin({
        title: '·βѯ',
        width: '700',
        height: '420',
        data: data_val,
        url: url
    });
};

//ɾ·
Label.deleteRoad = function (xh) {
    console.log("ɾ·Σ", xh);

    $.ajax({										// 
        type: 'post',
        dataType: 'json',
        url: 'trafficroadgridinfoAction!delete_Trafficroadgridinfo.do',
        data: {"roadGridId": xh},
        success: function (flag) {
            if (flag == "success") {
                var graphicArr = MapAPI.getRoadGraphicsLayer().graphics;
                var graphic = null;
                for (var i = 0, len = graphicArr.length; i < len; i++) {
                    if (graphicArr[i].attributes.xh == xh) {
                        graphic = graphicArr[i];
                        break;
                    }
                }
                if (graphic != null) {
                    MapAPI.getRoadGraphicsLayer().remove(graphic);
                    MapAPI.getMap().infoWindow.hide();
                    $.showMsg("ע·ɾɹ!");
                }
            } else {
                $.showMsg("ע·ɾʧ!");
            }
        }
    });

    /*var graphicArr=MapAPI.getRoadGraphicsLayer().graphics;
	var graphic=null;
	for(var i=0,len=graphicArr.length;i<len;i++){
		if(graphicArr[i].attributes.xh==xh){
			graphic=graphicArr[i];
			break;
		}
	}
	if(graphic!=null){
		MapAPI.getRoadGraphicsLayer().remove(graphic);
		MapAPI.getMap().infoWindow.hide();
		$.showMsg("ע·豸ɾɹ!");
	}*/
};

//·ϸϢ
Label.detailInfoRoad = function (xh) {
    var sysUrl = top.sysUrl;
    windowId = top.$.createWin({
        title: 'ϸϢ',
        width: 650,
        height: 400,
        data: {"roadGridId": xh},
        url: sysUrl + "/yw/szmap/jx/roadDetail.jsp"
    });
};

//ʵʱƵ
Label.realtimeVideo = function (xh) {
//	console.log("xh",xh);
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'sbtdspsrAction!get_SbtdspsrDetail.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
                    //				console.log("res",res);

                    res.video = "1";
                    var sysUrl = top.sysUrl;
                    windowId = top.$.createWin({
                        title: 'ʵʱƵ',
                        width: 720,
                        height: 400,
                        data: res,
                        url: sysUrl + "/yw/szmap/jx/video.jsp"
                    });

                }
            }
        })
    }


};
//˹澯
Label.artificialAlarm = function (xh) {
//	console.log("xh",xh);
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'sbtdspsrAction!get_SbtdspsrDetail.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
                    //				console.log("res",res);
                    res.video = "1";
                    var sysUrl = top.sysUrl;
                    windowId = top.$.createWin({
                        title: '¼',
                        width: 650,
                        height: 400,
                        data: res,
                        url: sysUrl + "/yw/szmap/jx/video.jsp"
                    });

                }
            }
        })
    }


};

// ¼
Label.recordNav = function (xh) {
//	console.log("xh",xh);
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'sbtdspsrAction!get_SbtdspsrDetail.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
                    //				console.log("res",res);
                    res.video = "2";
                    var sysUrl = top.sysUrl;
                    windowId = top.$.createWin({
                        title: '¼',
                        width: 720,
                        height: 400,
                        data: res,
                        url: sysUrl + "/yw/szmap/jx/video.jsp"
                    });

                }
            }
        })
    }
};
//鿴豸άϢ
Label.repaire = function (sbbh, tdbh) {
//	console.log("xh",xh);
    var sysUrl = top.sysUrl;
    windowId = top.$.createWin({
        title: 'άϢ',
        width: 890,
        height: 400,
        scrolling: true,
        url: sysUrl + "/yw/szmap/jobinfo/ywrepairDevicejobinfo.jsp?sbbh=" + sbbh + "&tdbh=" + tdbh
    });
}

//ϸϢ
Label.detailInformation = function (xh) {

//	console.log("xh",xh);
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'sbtdspsrAction!get_SbtdspsrDetail.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
                    //				console.log("res",res);

                    var sysUrl = top.sysUrl;
                    windowId = top.$.createWin({
                        title: 'ϸϢ',
                        width: 720,
                        height: 400,
                        data: res,
                        url: sysUrl + "/yw/szmap/jx/videoDetail.jsp"
                    });
                }
            }
        })
    }


};
//༭
Label.editvideo = function (xh) {
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'sbtdspsrAction!get_SbtdspsrDetail.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
                    windowId = top.$.createWin({
                        id: $.uniqueId(),
                        title: '༭豸',
                        width: 650,
                        data: res,
                        scrolling:true,
                        height: 800,
                        buttons: [{
                            text: $.fn.textbox.defaults.ok,
                            handler: savevideoNodeInfo
                        }],
                        url: sysUrl + "/yw/videomanage/videochannelset/sbtdspsr/sbtdspsr_show.jsp"
                    });
                }
            }
        });
    }


};

//ϸϢ
Label.detailInformationJtjzw = function (xh) {
    console.log("res", xh);
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjtjzwxxbAction!get_Nhywjtjzwxxb.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
                    //				console.log("res",res);

                    var sysUrl = top.sysUrl;
                    windowId = top.$.createWin({
                        title: 'ϸϢ',
                        width: 720,
                        height: 400,
                        data: res,
                        url: sysUrl + "/yw/szmap/jx/jtjzwDetail.jsp"
                    });
                }
            }
        })
    }
};

// ־
Label.detailInformationNhywjtbz = function (xh) {
    console.log("res", xh);
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjtbzglAction!get_Nhywjtbzgl.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
//					console.log("res-------------",res);
                    var sysUrl = top.sysUrl;
                    windowId = top.$.createWin({
                        title: 'ϸϢ',
                        width: 860,
                        height: 400,
                        data: res,
                        url: sysUrl + "/yw/szmap/jx/nhywjtbzDetail.jsp"
                    });
                }
            }
        })
    }
}

// 
Label.detailInformationJtbx = function (xh) {
    console.log("res", xh);
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjtbxglAction!get_Nhywjtbxgl.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
//					console.log("res-------------",res);
                    var sysUrl = top.sysUrl;
                    windowId = top.$.createWin({
                        title: 'ϸϢ',
                        width: 860,
                        height: 400,
                        data: res,
                        url: sysUrl + "/yw/szmap/jx/jtbxDetail.jsp"
                    });
                }
            }
        })
    }
}

// 
Label.detailInformationJthl = function (xh) {
    console.log("res", xh);
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjthlglAction!get_Nhywjthlgl.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
//					console.log("res-------------",res);
                    var sysUrl = top.sysUrl;
                    windowId = top.$.createWin({
                        title: 'ϸϢ',
                        width: 860,
                        height: 400,
                        data: res,
                        url: sysUrl + "/yw/szmap/jx/jthlDetail.jsp"
                    });
                }
            }
        })
    }
}

// źŵ
Label.detailInformationJtxhd = function (xh) {
    console.log("res", xh);
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjtxhdglAction!get_Nhywjtxhdgl.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
//					console.log("res-------------",res);
                    var sysUrl = top.sysUrl;
                    windowId = top.$.createWin({
                        title: 'ϸϢ',
                        width: 860,
                        height: 400,
                        data: res,
                        url: sysUrl + "/yw/szmap/jx/jtxhdDetail.jsp"
                    });
                }
            }
        })
    }
}

//յ
Label.detailInformationJtydp = function (xh) {
    console.log("res", xh);
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjtledydpglAction!get_Nhywjtledydpgl.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
//					console.log("res-------------",res);
                    var sysUrl = top.sysUrl;
                    windowId = top.$.createWin({
                        title: 'ϸϢ',
                        width: 440,
                        height: 360,
                        data: res,
                        url: sysUrl + "/yw/szmap/jx/jtydpDetail.jsp"
                    });
                }
            }
        })
    }
}

Label.jtjzwSearch = function () {
    var data_val = {Label: Label};
    var url = top.sysUrl + "/yw/szmap/map/toolbar_operation/itemPage/jtjzw-search.jsp";
    top.windowid = top.$.createWin({
        title: 'ѯ',
        width: '700',
        height: '420',
        data: data_val,
        url: url
    });
};

// ־Ʋѯ
Label.nhywjtbzSearch = function () {
    var data_val = {Label: Label};
    var url = top.sysUrl + "/yw/szmap/map/toolbar_operation/itemPage/nhywjtbz-search.jsp";
    top.windowid = top.$.createWin({
        title: '־Ʋѯ',
        width: '700',
        height: '420',
        data: data_val,
        url: url
    });
}

// ߲ѯ
Label.jtbxSearch = function () {
    var data_val = {Label: Label};
    var url = top.sysUrl + "/yw/szmap/map/toolbar_operation/itemPage/jtbx-search.jsp";
    top.windowid = top.$.createWin({
        title: '߲ѯ',
        width: '700',
        height: '420',
        data: data_val,
        url: url
    });
}

// ѯ
Label.jthlSearch = function () {
    var data_val = {Label: Label};
    var url = top.sysUrl + "/yw/szmap/map/toolbar_operation/itemPage/jthl-search.jsp";
    top.windowid = top.$.createWin({
        title: 'ѯ',
        width: '700',
        height: '420',
        data: data_val,
        url: url
    });
}

// źŵƲѯ
Label.jtxhdSearch = function () {
    var data_val = {Label: Label};
    var url = top.sysUrl + "/yw/szmap/map/toolbar_operation/itemPage/jtxhd-search.jsp";
    top.windowid = top.$.createWin({
        title: 'źŵƲѯ',
        width: '700',
        height: '420',
        data: data_val,
        url: url
    });
}

//յѯ
Label.jtydpSearch = function () {
    var data_val = {Label: Label};
    var url = top.sysUrl + "/yw/szmap/map/toolbar_operation/itemPage/jtydp-search.jsp";
    top.windowid = top.$.createWin({
        title: 'յѯ',
        width: '700',
        height: '420',
        data: data_val,
        url: url
    });
}


//״ѯ
Label.ldSearch = function () {
    var data_val = {Label: Label};
    var url = top.sysUrl + "/yw/szmap/map/toolbar_operation/itemPage/ld-search.jsp";
    top.windowid = top.$.createWin({
        title: '״ѯ',
        width: '700',
        height: '420',
        data: data_val,
        url: url
    });
}

//΢ѯ
Label.wbSearch = function () {
    var data_val = {Label: Label};
    var url = top.sysUrl + "/yw/szmap/map/toolbar_operation/itemPage/detector-search.jsp?detectortype=SMARTSENSOR";
    top.windowid = top.$.createWin({
        title: 'شŲѯ',
        width: '700',
        height: '420',
        data: data_val,
        url: url
    });
}

//شŲѯ
Label.dcSearch = function () {
    var data_val = {Label: Label};
    var url = top.sysUrl + "/yw/szmap/map/toolbar_operation/itemPage/detector-search.jsp??detectortype=GVD";
    top.windowid = top.$.createWin({
        title: 'شŲѯ',
        width: '700',
        height: '420',
        data: data_val,
        url: url
    });
}





//༭źŵ
Label.editxhd = function (xh) {
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjtxhdglAction!get_Nhywjtxhdgl.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
                    windowId = top.$.createWin({
                        title: '޸Ϣ',
                        width: 650,
                        height: 620,
                        data: res,
                        buttons: [{
                            text: $.fn.textbox.defaults.ok,
                            handler: saveNodeInfo
                        }],
                        url: sysUrl + "/yw/nhyw/nhywjtxhdgl/nhywjtxhdgl_show.jsp"
                    });
                }
            }
        })
    }

}
//༭
Label.edithl = function (xh) {
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjthlglAction!get_Nhywjthlgl.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
                    windowId = top.$.createWin({
                        title: '޸Ϣ',
                        width: 650,
                        height: 600,
                        data: res,
                        buttons: [{
                            text: $.fn.textbox.defaults.ok,
                            handler: savehlNodeInfo
                        }],
                        url: sysUrl + "/yw/nhyw/nhywjthlgl/nhywjthlgl_show.jsp"
                    });
                }
            }
        });
    }
}
//༭յ
Label.editydp = function (xh) {
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjtledydpglAction!get_Nhywjtledydpgl.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
                    windowId = top.$.createWin({
                            title: '޸Ϣ',
                            width: 650,
                            height: 530,
                            data: res,
                            buttons: [{
                                text: $.fn.textbox.defaults.ok,
                                handler: saveydpNodeInfo
                            }],
                            url: sysUrl + "/yw/nhyw/nhywjtledydpgl/nhywjtledydpgl_show.jsp"
                        }
                    );
                }
            }
        });
    }
}

//༭ش,΢
Label.editdetector = function (id) {
    if (id != null && id != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'detectorAction!get_Detector.do',
            data: {id: id},
            success: function (res) {
                if (res) {
                    windowId = top.$.createWin({
                            title: '޸Ϣ',
                            width: 650,
                            height: 530,
                            data: res,
                            buttons: [{
                                text: $.fn.textbox.defaults.ok,
                                handler: saveDetectorNodeInfo
                            }],
                            url: sysUrl + "/yw/nhyw/detector/detector_show.jsp"
                        }
                    );
                }
            }
        });
    }
}

//༭״
Label.editld = function (id) {
    if (id != null && id != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'zxldAction!get_Zxld.do',
            data: {xh: id},
            success: function (res) {
                if (res) {
                    windowId = top.$.createWin({
                            title: '޸Ϣ',
                            width: 650,
                            height: 530,
                            data: res,
                            buttons: [{
                                text: $.fn.textbox.defaults.ok,
                                handler: saveldNodeInfo
                            }],
                            url: sysUrl + "/yw/nhyw/zxld/zxld_show.jsp"
                        }
                    );
                }
            }
        });
    }
}

//༭
Label.editbx = function (xh) {
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjtbxglAction!get_Nhywjtbxgl.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
                    windowId = top.$.createWin({
                        title: '޸Ϣ',
                        width: 650,
                        height: 600,
                        data: res,
                        buttons: [{
                            text: $.fn.textbox.defaults.ok,
                            handler: savebxNodeInfo
                        }],
                        url: sysUrl + "/yw/nhyw/nhywjtbxgl/nhywjtbxgl_show.jsp"
                    });
                }
            }
        });
    }

}
//༭־
Label.editbzp = function (xh) {
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjtbzglAction!get_Nhywjtbzgl.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
                    windowId = top.$.createWin({
                        title: '޸Ϣ',
                        width: 650,
                        height: 600,
                        data: res,
                        buttons: [{
                            text: $.fn.textbox.defaults.ok,
                            handler: savebzpNodeInfo
                        }],
                        url: sysUrl + "/yw/nhyw/nhywjtbzgl/nhywjtbzgl_show.jsp"
                    });
                }
            }
        });
    }

}
//༭
Label.editJjzw = function (xh) {
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'nhywjtjzwxxbAction!get_Nhywjtjzwxxb.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
                    windowId = top.$.createWin({
                        title: '޸Ϣ',
                        width: 650,
                        height: 600,
                        data: res,
                        buttons: [{
                            text: $.fn.textbox.defaults.ok,
                            handler: savejzwNodeInfo
                        }],
                        url: sysUrl + "/yw/nhyw/nhywjtjzwxxb/nhywjtjzwxxb_show.jsp"
                    });
                }
            }
        });
    }

}

//
function saveNodeInfo() {
    var win = $.getTopWindowById(windowId);
    var jq = win.$;
    var model = $.getFormValues("childform", windowId);
    console.log(model);
    if (!win.$('#childform').form('enableValidation').form('validate')) {
        return;
    }
    model.cpsm = jq("#cpsm").val();
    model.bz = jq("#bz").val();
    var frame = top.$("#" + windowId).children("iframe")[0];
    var winf = frame.contentWindow || frame.window;
    var picfile = winf.$("#picFile").prop('files');
    if (picfile != undefined && !picfile.length) {
        var fileStr = uploadFile();
        var fileInfo = JSON.parse(fileStr);
        var flag = fileInfo.flag;
        if (flag == "fail") {
            $.showMsg('ļϴʧܣ');
        } else {
            var jcbg = fileInfo.url0;
            var sbzp = fileInfo.url1;
            if (jcbg != "" || jcbg != null) {
                model.jcbg = jcbg;
            }
            if (sbzp != "" || sbzp != null) {
                model.sbzp = sbzp;
            }
        }
    }
    model.XGTJxh = jq('#xh').val();
    $.ajax({
        type: 'post',
        dataType: 'json',
        url: 'nhywjtxhdglAction!update_Nhywjtxhdgl.do',
        data: model,
        success: function (value) {
            if (value == "success") {
                $.showMsg("ɹ");
                top.$("#" + windowId).dialog('close');
            } else if (value == "same") {
                $.showMsg("Ѵڣ");
            } else {
                $.showMsg("ʧܣ");
            }
        }
    });
}

function savehlNodeInfo() {
    var win = $.getTopWindowById(windowId);
    var jq = win.$;
    var model = $.getFormValues("childform", windowId);
    var gysbh = jq("#gysbh").combotree("getValue");
    if (gysbh != null && gysbh != "") {
        model.gysmc = jq("#gysbh").combotree("getText");
    }
    var gxdwbm = jq("#gxdwbm").combotree("getValue")
    if (gxdwbm != "-1") {
        model.gxdwmc = jq("#gxdwbm").combotree("getText");
    } else {
        model.gxdwbm = "";
    }
    if (!win.$('#childform').form('enableValidation').form('validate')) {
        return;
    }
    var frame = top.$("#" + windowId).children("iframe")[0];
    var winf = frame.contentWindow || frame.window;
    var file = winf.$("#myfile").prop('files');
    if (!file.length) {
        //$.showMsg('ѡҪϴļ');
        //return;
    } else {
        var fileStr = uploadFile();
        var fileInfo = JSON.parse(fileStr);
        var flag = fileInfo.flag;
        if (flag == "success") {
            model.sjzp = fileInfo.url;
//			model.wdmc = fileInfo.fileName;
//			model.kz1 = fileInfo.kz1;
            console.log("", model);
        } else {
            $.showMsg('ļϴʧܣ');
            return;
        }
    }
    model.XGTJxh = jq('#xh').val();
    $.ajax({
        type: 'post',
        dataType: 'json',
        url: 'nhywjthlglAction!update_Nhywjthlgl.do',
        data: model,
        success: function (value) {
            if (value == "success") {
                $.showMsg("ɹ");
                top.$("#" + windowId).dialog('close');
            } else if (value == "same") {
                $.showMsg("Ѵڣ");
            } else {
                $.showMsg("ʧܣ");
            }
        }
    });
}

function saveydpNodeInfo() {
    var win = $.getTopWindowById(windowId);
    var jq = win.$;
    var model = $.getFormValues("childform", windowId);
    if (!win.$('#childform').form('enableValidation').form('validate')) {
        return;
    }
    model.XGTJid = jq('#id').val();
    $.ajax({
        type: 'post',
        dataType: 'json',
        url: 'detectorAction!update_Detector.do',
        data: model,
        success: function (value) {
            if (value == "success") {
                $.showMsg("ɹ");
                top.$("#" + windowId).dialog('close');
            } else if (value == "same") {
                $.showMsg("Ѵڣ");
            } else {
                $.showMsg("ʧܣ");
            }
        }
    });
}

function saveldNodeInfo() {
    var win = $.getTopWindowById(windowId);
    var jq = win.$;
    var model = $.getFormValues("childform", windowId);
    if (!win.$('#childform').form('enableValidation').form('validate')) {
        return;
    }
    model.XGTJxh = jq('#xh').val();
    $.ajax({
        type: 'post',
        dataType: 'json',
        url: 'zxldAction!update_Zxld.do',
        data: model,
        success: function (value) {
            if (value == "success") {
                $.showMsg("ɹ");
                top.$("#" + windowId).dialog('close');
            } else if (value == "same") {
                $.showMsg("Ѵڣ");
            } else {
                $.showMsg("ʧܣ");
            }
        }
    });
}
function saveDetectorNodeInfo() {
    var win = $.getTopWindowById(windowId);
    var jq = win.$;
    var model = $.getFormValues("childform", windowId);
    if (!win.$('#childform').form('enableValidation').form('validate')) {
        return;
    }
    model.XGTJid = jq('#id').val();
    $.ajax({
        type: 'post',
        dataType: 'json',
        url: 'detectorAction!update_Detector.do',
        data: model,
        success: function (value) {
            if (value == "success") {
                $.showMsg("ɹ");
                top.$("#" + windowId).dialog('close');
            } else if (value == "same") {
                $.showMsg("Ѵڣ");
            } else {
                $.showMsg("ʧܣ");
            }
        }
    });
}


function savebxNodeInfo() {
    var win = $.getTopWindowById(windowId);
    var jq = win.$;
    var model = $.getFormValues("childform", windowId);
    var gysbh = jq("#gysbh").combotree("getValue");
    if (gysbh != null && gysbh != "") {
        model.gysmc = jq("#gysbh").combotree("getText");
    }
    var gxdwbm = jq("#gxdwbm").combotree("getValue");
    if (gxdwbm != "-1") {
        model.gxdwmc = jq("#gxdwbm").combotree("getText");
    } else {
        model.gxdwbm = "";
    }
    console.log(model);
    if (!win.$('#childform').form('enableValidation').form('validate')) {
        return;
    }
    var frame = top.$("#" + windowId).children("iframe")[0];
    var winf = frame.contentWindow || frame.window;
    var file = winf.$("#myfile").prop('files');
    if (!file.length) {
        //$.showMsg('ѡҪϴļ');
        //return;
    } else {
        var fileStr = uploadFile();
        var fileInfo = JSON.parse(fileStr);
        var flag = fileInfo.flag;
        if (flag == "success") {
            model.sjzp = fileInfo.url;
//			model.wdmc = fileInfo.fileName;
//			model.kz1 = fileInfo.kz1;
            console.log("", model);
        } else {
            $.showMsg('ļϴʧܣ');
            return;
        }
    }
    model.XGTJxh = jq('#xh').val();
    $.ajax({
        type: 'post',
        dataType: 'json',
        url: 'nhywjtbxglAction!update_Nhywjtbxgl.do',
        data: model,
        success: function (value) {
            if (value == "success") {
                $.showMsg("ɹ");
                top.$("#" + windowId).dialog('close');
            } else if (value == "same") {
                $.showMsg("Ѵڣ");
            } else {
                $.showMsg("ʧܣ");
            }
        }
    });

}

//
function savebzpNodeInfo() {
    var win = $.getTopWindowById(windowId);
    var jq = win.$;
    var model = $.getFormValues("childform", windowId);
    var gysbh = jq("#gysbh").combotree("getValue");
    if (gysbh != null && gysbh != "") {
        model.gysmc = jq("#gysbh").combotree("getText");
    }
    var gxdwbm = jq("#gxdwbm").combotree("getValue");
    if (gxdwbm != "-1" && gxdwbm != null && gxdwbm != "") {
        model.gxdwmc = jq("#gxdwbm").combotree("getText");
    } else {
        model.gxdwbm = "";
    }
    if (!win.$('#childform').form('enableValidation').form('validate')) {
        return;
    }
    var frame = top.$("#" + windowId).children("iframe")[0];
    var winf = frame.contentWindow || frame.window;
    var file = winf.$("#myfile").prop('files');
    if (!file.length) {
        //$.showMsg('ѡҪϴļ');
        //return;
    } else {
        var fileStr = uploadFile();
        var fileInfo = JSON.parse(fileStr);
        var flag = fileInfo.flag;
        if (flag == "success") {
            model.sjzp = fileInfo.url;
//			model.wdmc = fileInfo.fileName;
//			model.kz1 = fileInfo.kz1;
            console.log("", model);
        } else {
            $.showMsg('ļϴʧܣ');
            return;
        }
    }
    model.XGTJxh = jq('#xh').val();
    $.ajax({
        type: 'post',
        dataType: 'json',
        url: 'nhywjtbzglAction!update_Nhywjtbzgl.do',
        data: model,
        success: function (value) {
            if (value == "success") {
                $.showMsg("ɹ");
                top.$("#" + windowId).dialog('close');
            } else if (value == "same") {
                $.showMsg("Ѵڣ");
            } else {
                $.showMsg("ʧܣ");
            }
        }
    });
}

function savevideoNodeInfo() {
    var frame = top.$("#" + windowId).children('iframe')[0];
    var win = frame.contentWindow || frame.window;
    var jq = win.$;
    var model = $.getFormValues("childform", windowId);
    model.XGTJsbbh = model.xh;
    $.ajax({
        type: 'post',
        dataType: 'json',
        url: 'sbtdspsrAction!update_Sbtdspsr.do',
        data: model,
        success: function (value) {
            if (value == 'success') {
                top.$("#" + windowId).dialog('close');
                $.showMsg('ִгɹ');
            }
        }
    });

}

function savejzwNodeInfo() {
    var win = $.getTopWindowById(windowId);
    var jq = win.$;
    var model = $.getFormValues("childform", windowId);
    if (!win.$('#childform').form('enableValidation').form('validate')) {
        return;
    }
    var frame = top.$("#" + windowId).children("iframe")[0];
    var winf = frame.contentWindow || frame.window;
    var file = winf.$("#myfile").prop('files');
    if (!file.length) {
        //$.showMsg('ѡҪϴļ');
        //return;
    } else {
        var fileStr = uploadFile();
        var fileInfo = JSON.parse(fileStr);
        var flag = fileInfo.flag;
        if (flag == "success") {
            model.jzwtp1 = fileInfo.url;
            console.log("", model);
        } else {
            $.showMsg('ļϴʧܣ');
            return;
        }
    }
    model.XGTJxh = jq('#xh').val();
    $.ajax({
        type: 'post',
        dataType: 'json',
        url: 'nhywjtjzwxxbAction!update_Nhywjtjzwxxb.do',
        data: model,
        success: function (value) {
            if (value == "success") {
                $.showMsg("ɹ");
                top.$("#" + windowId).dialog('close');
            } else if (value == "same") {
                $.showMsg("Ѵڣ");
            } else {
                $.showMsg("ʧܣ");
            }
        }
    });

}

function uploadFile() {
    var win = $.getTopWindowById(windowId);
    var res = '';
    win.$("#childform").ajaxSubmit({
        type: 'post', // ύʽ get/post
        cache: false,
        dataType: 'text',
        contentType: "application/x-www-form-urlencoded; charset=utf-8",
        async: false,
        url: "http://" + window.location.host + "/impnhyw/UploadNhywCpxh", // Ҫύ url
        success: function (responseText, statusText, xhr, $form) {
//	    	 console.log(responseText);
            res = responseText;
//	    	console.log("res",res);
        }
    });
    return res;
}

//صشţ΢ϸϢ
Label.detailInformationDetector = function (xh) {
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'detectorAction!get_Detector.do',
            data: {id: xh},
            success: function (res) {
                if (res) {
                    var sysUrl = top.sysUrl;
                    windowId = top.$.createWin({
                        title: 'ϸϢ',
                        width: 720,
                        height: 400,
                        data: res,
                        url: sysUrl + "/yw/nhyw/detector/detector_show.jsp"
                    });
                }
            }
        })
    }
};



//״ϸϢ
Label.detailInformationld = function (xh) {
    if (xh != null && xh != '') {
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'zxldAction!get_Zxld.do',
            data: {xh: xh},
            success: function (res) {
                if (res) {
                    var sysUrl = top.sysUrl;
                    windowId = top.$.createWin({
                        title: 'ϸϢ',
                        width: 620,
                        height: 430,
                        data: res,
                        url: sysUrl + "/yw/nhyw/zxld/zxld_show.jsp"
                    });
                }
            }
        })
    }
};



// עشš΢ѯ
Label.detectorSearch = function (detectortype) {
    var data_val = {Label: Label,detectortype:detectortype};
    var url = top.sysUrl + "/yw/szmap/map/toolbar_operation/itemPage/detector-search.jsp";
    top.windowid = top.$.createWin({
        title: 'ѯ',
        width: '700',
        height: '420',
        data: data_val,
        url: url
    });
}


//شš΢ȷ
Label.confirmdetector = function (detectortype) {
    var jd = $("#jd").val();
    var wd = $("#wd").val();
    var name = $("#sxt").val();
    var id = $("#id").val();
//	console.log("confirmCamera ",params);
    if (name.trim() != '') {
        var data = {"jd": jd, "wd": wd, "name": name,"XGTJid": id,"detectortype":detectortype,"id":id};
        var html = "<div class='bcontent'><div><span style='color:#75767A'>" + name + "</span></div>" +
            "<ul  class='bcontentItem'>" +
            "<li onclick='Label.editdetector(\"" + id + "\")'>༭</li>" +
            "<li onclick='Label.detailInformationDetector(\"" + id + "\")'></li>" +
            "<li onclick='removedetector(\"" + id + "\")'>ɾ</li>" +
            "</ul></div>";
        MapAPI.getMap().infoWindow.hide();
        if(detectortype=="GVD") {
            MapAPI.getJtwbGraphicsLayer().remove(Label.graphic);
        }else{
            MapAPI.getJtdcGraphicsLayer().remove(Label.graphic);
        }
        MapUtil.adddetectorPoint(data, html);
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'detectorAction!update_Detector.do',
            data: data,
            success: function (flag) {
                if (flag == "success") {
                    $.showMsg("ӳɹ");
                } else {
                    $.showMsg("ʧ!");
                }
            }
        });
    } else {
        $.showMsg("ƲΪ!");
    }
}

// شš΢
Label.filldetector = function (o) {
    $("#arcgisIframe").hide();
    $(".esri-component").show();
    var dataJson = JSON.parse($(o).attr("data-json"));
    $('#id').val(dataJson.id);
    $("#sxt").val(dataJson.name);
}

//עشš΢ȡ
Label.canceldetector = function (detectortype) {
    if(detectortype=="GVD") {
        MapAPI.getJtwbGraphicsLayer().remove(Label.graphic);
    }else{
        MapAPI.getJtdcGraphicsLayer().remove(Label.graphic);
    }
    MapAPI.getMap().infoWindow.hide();
    $.showMsg("עȡɹ!");
}


//״ѯ
Label.ldSearch = function () {
    var data_val = {Label: Label};
    var url = top.sysUrl + "/yw/szmap/map/toolbar_operation/itemPage/ld-search.jsp";
    top.windowid = top.$.createWin({
        title: '״ѯ',
        width: '700',
        height: '420',
        data: data_val,
        url: url
    });
}

//״ȷ
Label.confirmld = function () {
    var jd = $("#jd").val();
    var wd = $("#wd").val();
    var name = $("#sxt").val();
    var xh = $("#id").val();
//	console.log("confirmCamera ",params);
    if (name.trim() != '') {
        var data = {"jd": jd, "wd": wd, "ldmc": name,"XGTJxh":xh};
        var html = "<div class='bcontent'><div><span style='color:#75767A'>" + name + "</span></div>" +
            "<ul  class='bcontentItem'>" +
            "<li onclick='Label.editdld(\"" + xh + "\")'>༭</li>" +
            "<li onclick='removeld(\"" + xh + "\")'>ɾ</li>" +
            "<li onclick='Label.detailInformationld(\"" + xh + "\")'></li>" +
            "</ul></div>";
        MapAPI.getMap().infoWindow.hide();
        MapAPI.getJtldGraphicsLayer().remove(Label.graphic);
        MapUtil.adddLdPoint(data, html);
        $.ajax({
            type: 'post',
            dataType: 'json',
            url: 'zxldAction!update_Zxld.do',
            data: data,
            success: function (flag) {
                if (flag == "success") {
                    $.showMsg("ӳɹ");
                } else {
                    $.showMsg("ʧ!");
                }
            }
        });
    } else {
        $.showMsg("ƲΪ!");
    }
}

// ״
Label.fillld = function (o) {
    $("#arcgisIframe").hide();
    $(".esri-component").show();
    var dataJson = JSON.parse($(o).attr("data-json"));
    $("#sxt").val(dataJson.ldmc);
    $("#id").val(dataJson.xh);
}

//ע״ȡ
Label.cancelld = function () {
    MapAPI.getJtldGraphicsLayer().remove(Label.graphic);
    MapAPI.getMap().infoWindow.hide();
    $.showMsg("ע״豸ȡɹ!");
};