function MonitorLayer(seq ,config ){
	LayerBase.call(this,seq,config);
}

MonitorLayer.prototype = Object.create(LayerBase.prototype);  

MonitorLayer.prototype.OnMapChange = function(){
	if(this.isChecked) this.loadLayerData();
}

MonitorLayer.prototype.loadLayerData = function(){
	var that = this ,layers  =  MapMain.getLayer(this.seq);
	if(layers){
		var model = LayerBase.getBaseQueryCondition(that.getLayerSeq());
		model.page = 1;
		model.rows = 10000;
		model.LIKExzbh = "";
		model.LIKEsbbh = "";
		model.LIKEtdbh = "";
		model.LIKEtdmc = "";
		$.ajax({
			type:'post',
			dataType : 'json',
			data:model,
			url:'szMapHttpAction!getMapGridData.do',
			success:function(data){
			 	if(data && data.rows.length ){
			 		that.tryCloseCurrPopUpHtmlWindow(data.rows);
				    that.removeMarkers();
			 		console.log( "monitor data length"+data.rows.length);
			 		var i = 0 ;
			 		while(data.rows[i] && data.rows[i].tdmc){
				 		that.drawMarker(data.rows[i],i);
				 		i++;
			 		}
			 	}
			 }
	    });
	}
} 

MonitorLayer.prototype.getMark = function(result,withTitle){
	if(!result) return ;
	//ͷ
	if(result.tdlx == '0' || result.tdlx == '1' 
		|| result.tdlx == '2' || result.tdlx == '3' 
			|| result.tdlx == '4' || result.tdlx == '9' 
				|| result.tdlx == '15'){
		var pIcon 	= this.getIcon(MapConst.MARKER_ICON_MONITOR_QIU , MapConst.LAYER_ICON_WIDTH ,MapConst.LAYER_ICON_HEIGHT);
	}else{
		var pIcon 	= this.getIcon(MapConst.MARKER_ICON_MONITOR , MapConst.LAYER_ICON_WIDTH ,MapConst.LAYER_ICON_HEIGHT);
	}	
	var point = new Point(result.jd,result.wd);	
	var resultMsg = PopUpBase.createVideoPopUp(result);	
	var title = this.getTitle(result);	
	var marker = new Marker(point,pIcon) ;	
	var markerObj = [this.seq , result.id , result.jd,result.wd ];	 
	marker.addListener("click", function(){
		//MapMain.createVideoPopUp(markerObj);
		marker.openInfoWindowHtml(resultMsg);
	});	
	marker.setZIndex(MapConst.MARKER_ZINDEX_MONITOR);
	return marker;
}

MonitorLayer.prototype.getTitle = function(data) {
	return new Title(data.tdmc||"", 12, 7, "", "black", '#EBEBEB',"#76A9A9", 1);
}

MonitorLayer.prototype.createPopUp = function(data){
	  return PopUpBase.createVideoPopUp(data);
}