package cn.bsystem.ptConst.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptConst.service.XtclService;

@SuppressWarnings({"all"})
//ϵͳ  sysConst ---> xtcl 
@Component("xtclAction")
public class XtclAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(XtclAction.class);
	
	@Autowired
	private XtclService service;
	
	/**
	 * ҳ
	 */
//	@OperateType(value = LogConstants.LOG_QUERY ,info ="listXtclByPage")
	public void listXtclByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ((page == 0 ? 1 : page) - 1) * rows;
			map.put("start", start);
			map.put("limit", rows);
			Struts2Utils.renderJson(this.service.listXtclByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtclAction - listXtclByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
//	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Xtcl")
	public void count_Xtcl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Xtcl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtclAction - count_Xtcl() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Xtcl
	 */
//	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Xtcl")
	public void query_Xtcl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			map.put("order", "order by cspx ,csdm");
			Struts2Utils.renderJson(this.service.query_Xtcl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtclAction - query_Xtcl() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	public void query_Xtcl_task(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String csdl = (String)map.get("csdl");
			String[] csdls = csdl.split(",");
			if(csdls!=null && csdls.length>0){
				String insertP = "'";
				for(int i=0;i<csdls.length;i++){
					insertP += csdls[i]+"','";
				}
				map.put("csdl", insertP.substring(0, insertP.lastIndexOf(",")));
				Struts2Utils.renderJson(this.service.query_Xtcl_task(map));
			}else{
				Struts2Utils.renderJson(null);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtclAction - query_Xtcl_task() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һXtcl
	 */
//	@OperateType(value = LogConstants.LOG_QUERY ,info ="get_Xtcl")
	public void get_Xtcl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Xtcl(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtclAction - query_Xtcl() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteXtcl")
	public void delete_Xtcl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Xtcl(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtclAction - delete_Xtcl() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
//	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Xtcl")
	public void insert_Xtcl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			map.put("xh", StringUtil.getUUID());
			service.insert_Xtcl(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtclAction - listXtclByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Xtcl")
	public void update_Xtcl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Xtcl(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtclAction - update_Xtcl() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Xtcl")
	public void batch_delete_Xtcl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Xtcl(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtclAction - batch_delete_Xtcl() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="exoprtExcel")
	public void exoprtExcel(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			map = service.exportXtcl(map);
			ExcelCol[] cells = new ExcelCol[2];
			cells[0] = new ExcelCol();
			cells[0].setColKey("ֶ");
			cells[0].setColName("ֶ");
			cells[1] = new ExcelCol();
			cells[1].setColKey("ֶ");
			cells[1].setColName("ֶ");
			Map params = new HashMap();
			params.put("fileName", "");
			params.put("sheetName", "");
			params.put("header", "");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			iLog.error("XtclAction - exoprtExcel() : error === " +e);
			e.printStackTrace();
		}
	}
}
