package cn.yw.alarmcode.action;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.yw.alarmcode.service.GjbhxxService;

@SuppressWarnings({"all"})
@Component("gjbhxxAction")
public class GjbhxxAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(GjbhxxAction.class);
	
	@Autowired
	private GjbhxxService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listGjbhxxByPage")
	public void listGjbhxxByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listGjbhxxByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("GjbhxxAction-listGjbhxxByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteGjbhxx")
	public void delete_Gjbhxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Gjbhxx(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("GjbhxxAction-delete_Gjbhxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Gjbhxx")
	public void insert_Gjbhxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("xh"))){
				map.put("xh",StringUtil.getUUID());
			}
			Map hm = new HashMap();
			hm.put("gjbh", map.get("gjbh"));
			hm = this.service.get_Gjbhxx(hm);
			if(hm!=null && hm.containsKey("gjbh")){
				Struts2Utils.renderJson(Constants.EXIST);
			}else{
				service.insert_Gjbhxx(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("GjbhxxAction-listGjbhxxByPage()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Gjbhxx")
	public void update_Gjbhxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Gjbhxx(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("GjbhxxAction-update_Gjbhxx-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Gjgzsbjq
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Gjbhxx")
	public void query_Gjbhxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Gjbhxx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("GjbhxxAction-query_Gjbhxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
}
