package cn.base.bean;

import java.lang.reflect.Field;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
public class BaseBean {
	private static Log iLog = LogFactory.getLog(Thread.currentThread().getClass());
	@Override
	public String toString(){
		StringBuilder sbd = new StringBuilder();
		sbd.append(this.getClass().getSimpleName()).append(":[ ");
		Field[] fields = this.getClass().getDeclaredFields();
		int i = 0;
		for(Field field : fields) {
			try {
				field.setAccessible(true);
				sbd.append(field.getName()).append("=").append(field.get(this));
				if(i< fields.length-1) sbd.append(",");
			} catch (Exception e) {
				e.printStackTrace();
				iLog.error(Thread.currentThread().getClass().getSimpleName()+" toString error,field"+field.getName()+":"+e);
				continue;
			}
			i++;
		}
		return sbd.append("]").toString();
	}
}
