package cn.nhyw.khpj.service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.nhyw.khpj.dao.MonthlyKPIDao;
import cn.nhyw.khpj.dao.YwglbmkhDao;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

@Service("monthlyKPIService")
public class MonthlyKPIService extends BaseService {

	private static Log log = LogFactory.getLog(MonthlyKPIService.class);

	@Autowired
	private MonthlyKPIDao dao;


	/**
	 * ѯ
	 */
	public List<Map> listMonthlyKPI(Map map) throws SQLException {
	return  dao.queryMonthlyKPI(map);
	}




	/**
	 * ޸ļ¼
	 */
	public Integer batchupdateMonthlyKPI(List<Map> batch) throws SQLException{
		return dao.batchupdateMonthlyKPI(batch);
	}



	/**
	 * ѯ
	 */
	public Integer getMonthlyKPITotalScore() throws SQLException{
		return dao.getMonthlyKPITotalScore(null);
	}

	/**
	 * ѯ
	 */
	public Map listMonthlyKPIByVer(Map map) throws SQLException {
		List<Map>  list= dao.queryMonthlyKPIByVer(map);
		Integer  total= dao.countMonthlyKPIByVer(map);
		map.clear();
		map.put("total", total);
		map.put("rows", list);
		return map;
	}

	public Map  maxMonthlyKPIByVer(Map map) throws SQLException {
		return  dao.maxMonthlyKPIByVer(map);
	}
	public void   insert_MonthlyKPIByVer(Map map) throws SQLException {
		CommUtils.addYhParams(map, false);
		dao.insert_MonthlyKPIByVer(map);
	}
	public void   update_MonthlyKPIByXh(Map map) throws SQLException {
		CommUtils.addYhParams(map, true);
		dao.update_MonthlyKPIByxh(map);
	}

	public void   update_MonthlyKPIByUsingVer(Map map) throws SQLException {
		CommUtils.addYhParams(map, true);
		dao.update_MonthlyKPIByUsingVer(map);
	}
	public void   update_MonthlyKPIVerByUsingVer(Map map) throws SQLException {
		CommUtils.addYhParams(map, true);
		dao.update_MonthlyKPIVerByUsingVer(map);
	}

	public void   delete_MonthlyKPI(Map map) throws SQLException {
		CommUtils.validateUpdateParams(map);
		dao.delete_MonthlyKPI(map);
	}
	public void   update_MaxMonthlyKPIByUsingVer(Map map) throws SQLException {
		CommUtils.addYhParams(map, true);
		dao.update_MaxMonthlyKPIByUsingVer(map);
	}
	public void update_Max_Usingver(Map map) throws SQLException{
		dao.update_Max_Usingver(map);
	}
}
