package cn.im.xtyh.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.im.xtyh.service.XtpzyhService;

@SuppressWarnings({"all"})
@Component("xtpzyhAction")
public class XtpzyhAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(XtpzyhAction.class);
	
	@Autowired
	private XtpzyhService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listXtpzyhByPage")
	public void listXtpzyhByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listXtpzyhByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtpzyhAction - listXtpzyhByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Xtpzyh")
	public void count_Xtpzyh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Xtpzyh(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtpzyhAction - count_Xtpzyh() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Xtpzyh
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Xtpzyh")
	public void query_Xtpzyh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Xtpzyh(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtpzyhAction - query_Xtpzyh() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һXtpzyh
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="get_Xtpzyh")
	public void get_Xtpzyh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Xtpzyh(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtpzyhAction - query_Xtpzyh() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteXtpzyh")
	public void delete_Xtpzyh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Xtpzyh(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtpzyhAction - delete_Xtpzyh() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Xtpzyh")
	public void insert_Xtpzyh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			map.put("yhbh", StringUtil.getUUID());
			service.insert_Xtpzyh(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtpzyhAction - listXtpzyhByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Xtpzyh")
	public void update_Xtpzyh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			CommUtils.MD5MapValueByKey(map,"yhmm");
			int result = service.update_Xtpzyh(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtpzyhAction - update_Xtpzyh() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Xtpzyh")
	public void batch_delete_Xtpzyh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Xtpzyh(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtpzyhAction - batch_delete_Xtpzyh() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="exoprtExcel")
	public void exoprtExcel(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			map = service.exportXtpzyh(map);
			ExcelCol[] cells = new ExcelCol[2];
			cells[0] = new ExcelCol();
			cells[0].setColKey("ֶ");
			cells[0].setColName("ֶ");
			cells[1] = new ExcelCol();
			cells[1].setColKey("ֶ");
			cells[1].setColName("ֶ");
			Map params = new HashMap();
			params.put("fileName", "");
			params.put("sheetName", "");
			params.put("header", "");	
			new ExportEngine().exportCommData(params, cells, (List<Map>) map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			iLog.error("XtpzyhAction - exoprtExcel() : error === " +e);
			e.printStackTrace();
		}
	}
}
