package cn.base.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import javax.imageio.ImageIO;

import org.apache.log4j.Logger;
import org.apache.lucene.util.IOUtils;
import sun.misc.BASE64Decoder;

public class ImageHepler {
	
	static Logger logger = Logger.getLogger(ImageHepler.class);
	public  static BufferedImage makeThumbnail(Image img, int width, int height) {
		BufferedImage tag = new BufferedImage(width, height, 1);
		Graphics g = tag.getGraphics();
		g.drawImage(img.getScaledInstance(width, height, 4), 0, 0, null);
		g.dispose();
		return tag;
	}

	private static void saveSubImage(BufferedImage image, Rectangle subImageBounds, File subImageFile) throws IOException {
		String fileName = subImageFile.getName();
		String formatName = fileName.substring(fileName.lastIndexOf(46) + 1);
		BufferedImage subImage = new BufferedImage(subImageBounds.width, subImageBounds.height, 1);
		Graphics g = subImage.getGraphics();
		if ((subImageBounds.width > image.getWidth()) || (subImageBounds.height > image.getHeight())) {
			int left = subImageBounds.x;
			int top = subImageBounds.y;
			if (image.getWidth() < subImageBounds.width)
				left = (subImageBounds.width - image.getWidth()) / 2;
			if (image.getHeight() < subImageBounds.height)
				top = (subImageBounds.height - image.getHeight()) / 2;
			g.setColor(Color.white);
			g.fillRect(0, 0, subImageBounds.width, subImageBounds.height);
			g.drawImage(image, left, top, null);
			ImageIO.write(image, formatName, subImageFile);
		} else {
			int width = subImageBounds.width;
			int height = subImageBounds.height;
			if(image.getWidth()<(subImageBounds.x+subImageBounds.width)) {
				width = width-(subImageBounds.x+subImageBounds.width-image.getWidth());
			}
			if(image.getHeight()<(subImageBounds.y+subImageBounds.height)) {
				height = height-(subImageBounds.y+subImageBounds.height-image.getHeight());
			}
			g.drawImage(image.getSubimage(subImageBounds.x, subImageBounds.y, width, height), 0, 0, null);
		}
		g.dispose();
		ImageIO.write(subImage, formatName, subImageFile);
	}

	public static void cut(String srcImageFile, String descDir, int width, int height, Rectangle rect) throws IOException {
		Image image = ImageIO.read(new File(srcImageFile));
		BufferedImage bImage = makeThumbnail(image, width, height);
		saveSubImage(bImage, rect, new File(descDir));
	}

	public static void cut(File srcImageFile, File descDir, int width, int height, Rectangle rect) throws IOException {
		Image image = ImageIO.read(srcImageFile);
		BufferedImage bImage = makeThumbnail(image, width, height);
		saveSubImage(bImage, rect, descDir);
	}
	public static void cut(BufferedImage img, File descDir,int width, int height, Rectangle rect) throws IOException {
		saveSubImage(img, rect, descDir);
	}
	//ͼƬţΪbase64ܵͼƬ
		public static InputStream cutImage(String imgStr,int width,int height){
			InputStream inputstream = null;
			ByteArrayInputStream in = null;
			ByteArrayOutputStream os =null;
			BufferedImage image = null;
	        try
	        {  
	        	//base64
	        	BASE64Decoder decoder = new BASE64Decoder();
	        	byte[] b = decoder.decodeBuffer(imgStr);
	        	in = new ByteArrayInputStream(b);
	            //ָͼƬ
	            image = ImageHepler.makeThumbnail(ImageIO.read(in),width,height);
	            os = new ByteArrayOutputStream();  
	            ImageIO.write(image, "jpg", os);  
	            inputstream = new ByteArrayInputStream(os.toByteArray());  
	        }catch (Exception e)   
	        {  
	        	logger.error("TraffAccidentThreadPool cutImage error:", e);
	            return null;  
	        }finally{
	        	try {
					IOUtils.close(os,in);
				} catch (IOException e){}
	        }
	        return inputstream;
		}
}